/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzma;
import com.google.android.gms.internal.zzmi;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzmp;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmr;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsd;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzmg
extends GoogleApiClient
implements zzmm.zza {
    private final Lock zzafz;
    private final zzk zzagh;
    private zzmm zzagi = null;
    private final int zzaeI;
    private final Context mContext;
    private final Looper zzaeK;
    final Queue<zzlx.zza<?, ?>> zzagj = new LinkedList();
    private volatile boolean zzagk;
    private long zzagl = 120000L;
    private long zzagm = 5000L;
    private final zza zzagn;
    private final GoogleApiAvailability zzaeL;
    zzc zzago;
    final Map<Api.zzc<?>, Api.zzb> zzagp;
    Set<Scope> zzagq = new HashSet<Scope>();
    final zzf zzafT;
    final Map<Api<?>, Integer> zzafU;
    final Api.zza<? extends zzsc, zzsd> zzaeM;
    private final Set<zzmn<?>> zzagr = Collections.newSetFromMap(new WeakHashMap());
    final Set<zze<?>> zzags = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private com.google.android.gms.common.api.zza zzagt;
    private final ArrayList<zzlz> zzagu;
    private Integer zzagv = null;
    private final zzd zzagw = new zzd(){

        @Override
        public void zzc(zze<?> zze2) {
            zzmg.this.zzags.remove(zze2);
            if (zze2.zzoL() != null && zzmg.this.zzagt != null) {
                zzmg.this.zzagt.remove(zze2.zzoL());
            }
        }
    };
    private final zzk.zza zzagx = new zzk.zza(){

        @Override
        public boolean isConnected() {
            return zzmg.this.isConnected();
        }

        @Override
        public Bundle zznQ() {
            return null;
        }
    };

    private static void zza(zze<?> zze2, com.google.android.gms.common.api.zza zza2, IBinder iBinder) {
        if (zze2.isReady()) {
            zzb zzb2 = new zzb(zze2, zza2, iBinder);
            zze2.zza(zzb2);
        } else if (iBinder != null && iBinder.isBinderAlive()) {
            zzb zzb3 = new zzb(zze2, zza2, iBinder);
            zze2.zza(zzb3);
            try {
                iBinder.linkToDeath((IBinder.DeathRecipient)zzb3, 0);
            }
            catch (RemoteException remoteException) {
                zze2.cancel();
                zza2.remove(zze2.zzoL());
            }
        } else {
            zze2.zza(null);
            zze2.cancel();
            zza2.remove(zze2.zzoL());
        }
    }

    public zzmg(Context context, Lock lock, Looper looper, zzf zzf2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzsc, zzsd> zza2, Map<Api<?>, Integer> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zzb> map2, int n, int n2, ArrayList<zzlz> arrayList) {
        this.mContext = context;
        this.zzafz = lock;
        this.zzagh = new zzk(looper, this.zzagx);
        this.zzaeK = looper;
        this.zzagn = new zza(looper);
        this.zzaeL = googleApiAvailability;
        this.zzaeI = n;
        if (this.zzaeI >= 0) {
            this.zzagv = n2;
        }
        this.zzafU = map;
        this.zzagp = map2;
        this.zzagu = arrayList;
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzagh.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzagh.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzafT = zzf2;
        this.zzaeM = zza2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zzb, R extends Result, T extends zzlx.zza<R, A>> T zza(T t) {
        zzx.zzb(t.zzoA() != null, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        zzx.zzb(this.zzagp.containsKey(t.zzoA()), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        this.zzafz.lock();
        try {
            if (this.zzagi == null) {
                this.zzagj.add(t);
                T t2 = t;
                return t2;
            }
            T t3 = this.zzagi.zza(t);
            return t3;
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zzb, T extends zzlx.zza<? extends Result, A>> T zzb(T t) {
        zzx.zzb(t.zzoA() != null, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        this.zzafz.lock();
        try {
            if (this.zzagi == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzpo()) {
                Object object;
                this.zzagj.add(t);
                while (!this.zzagj.isEmpty()) {
                    object = this.zzagj.remove();
                    this.zzb((zze<A>)object);
                    object.zzx(Status.zzaeZ);
                }
                object = t;
                return (T)object;
            }
            T t2 = this.zzagi.zzb(t);
            return t2;
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> zzmn<L> zzq(L l) {
        zzx.zzb(l, (Object)"Listener must not be null");
        this.zzafz.lock();
        try {
            zzmn<L> zzmn2 = new zzmn<L>(this.zzaeK, l);
            this.zzagr.add(zzmn2);
            zzmn<L> zzmn3 = zzmn2;
            return zzmn3;
        }
        finally {
            this.zzafz.unlock();
        }
    }

    @Override
    public <C extends Api.zzb> C zza(Api.zzc<C> zzc2) {
        Api.zzb zzb2 = this.zzagp.get(zzc2);
        zzx.zzb(zzb2, (Object)"Appropriate Api was not requested.");
        return (C)zzb2;
    }

    @Override
    public boolean zza(Api<?> api) {
        return this.zzagp.containsKey(api.zzoA());
    }

    @Override
    public boolean hasConnectedApi(Api<?> api) {
        Api.zzb zzb2 = this.zzagp.get(api.zzoA());
        return zzb2 != null && zzb2.isConnected();
    }

    @Override
    public ConnectionResult getConnectionResult(Api<?> api) {
        this.zzafz.lock();
        try {
            if (!this.isConnected() && !this.zzpo()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzagp.containsKey(api.zzoA())) {
                ConnectionResult connectionResult = this.zzagi.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.zzpo()) {
                        ConnectionResult connectionResult2 = ConnectionResult.zzadR;
                        return connectionResult2;
                    }
                    Log.i((String)"GoogleApiClientImpl", (String)this.zzpt());
                    Log.wtf((String)"GoogleApiClientImpl", (String)(api.getName() + " requested in getConnectionResult" + " is not connected but is not present in the failed " + " connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(api.getName() + " was never registered with GoogleApiClient");
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zzafz.lock();
        try {
            if (this.zzaeI >= 0) {
                zzx.zza(this.zzagv != null, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzagv == null) {
                this.zzagv = zzmg.zza(this.zzagp.values(), false);
            } else if (this.zzagv == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.zzagv);
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(int signInMode) {
        this.zzafz.lock();
        try {
            zzx.zzb(signInMode == 3 || signInMode == 1 || signInMode == 2, (Object)("Illegal sign-in mode: " + signInMode));
            this.zzbC(signInMode);
            this.zzpp();
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzafz.lock();
        try {
            if (this.zzaeI >= 0) {
                zzx.zza(this.zzagv != null, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzagv == null) {
                this.zzagv = zzmg.zza(this.zzagp.values(), false);
            } else if (this.zzagv == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbC(this.zzagv);
            this.zzagh.zzqB();
            ConnectionResult connectionResult = this.zzagi.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        zzx.zzb(unit, (Object)"TimeUnit must not be null");
        this.zzafz.lock();
        try {
            if (this.zzagv == null) {
                this.zzagv = zzmg.zza(this.zzagp.values(), false);
            } else if (this.zzagv == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbC(this.zzagv);
            this.zzagh.zzqB();
            ConnectionResult connectionResult = this.zzagi.blockingConnect(timeout, unit);
            return connectionResult;
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzafz.lock();
        try {
            this.zzpm();
            if (this.zzagi == null) {
                this.zzpn();
                return;
            }
            this.zzps();
            this.zzagi.disconnect();
            this.zzagh.zzqA();
        }
        finally {
            this.zzafz.unlock();
        }
    }

    void zzpm() {
        for (zze<?> object : this.zzags) {
            object.zza(null);
            if (object.zzoL() == null) {
                object.cancel();
                continue;
            }
            object.zzoP();
            IBinder iBinder = this.zza(object.zzoA()).zzoC();
            zzmg.zza(object, this.zzagt, iBinder);
        }
        this.zzags.clear();
        for (zzmn zzmn2 : this.zzagr) {
            zzmn2.clear();
        }
        this.zzagr.clear();
    }

    void zzpn() {
        for (zze zze2 : this.zzagj) {
            zze2.zza(null);
            zze2.cancel();
        }
        this.zzagj.clear();
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzx.zza(this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzx.zza(this.zzagv != 2, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzmq zzmq2 = new zzmq(this);
        if (this.zzagp.containsKey(zzmz.zzTo)) {
            this.zza(this, zzmq2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle connectionHint) {
                    zzmg.this.zza((GoogleApiClient)atomicReference.get(), zzmq2, true);
                }

                @Override
                public void onConnectionSuspended(int cause) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    zzmq2.zzb(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzmz.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzagn).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzmq2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzmq zzmq2, final boolean bl) {
        zzmz.zzakJ.zze(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzp(Status status) {
                zzn.zzae(zzmg.this.mContext).zzmZ();
                if (status.isSuccess() && zzmg.this.isConnected()) {
                    zzmg.this.reconnect();
                }
                zzmq2.zzb(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zzp((Status)x0);
            }
        });
    }

    @Override
    public void stopAutoManage(final FragmentActivity lifecycleActivity) {
        if (this.zzaeI >= 0) {
            zzmr zzmr2 = zzmr.zza(lifecycleActivity);
            if (zzmr2 == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (lifecycleActivity.isFinishing() || lifecycleActivity.getSupportFragmentManager().isDestroyed()) {
                            return;
                        }
                        zzmr.zzb(lifecycleActivity).zzbE(zzmg.this.zzaeI);
                    }
                });
            } else {
                zzmr2.zzbE(this.zzaeI);
            }
        } else {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzagi != null && this.zzagi.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.zzagi != null && this.zzagi.isConnecting();
    }

    boolean zzpo() {
        return this.zzagk;
    }

    private void zzbC(int n) {
        if (this.zzagv == null) {
            this.zzagv = n;
        } else if (this.zzagv != n) {
            throw new IllegalStateException("Cannot use sign-in mode: " + zzmg.zzbD(n) + ". Mode was already set to " + zzmg.zzbD(this.zzagv));
        }
        if (this.zzagi != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zzb zzb2 : this.zzagp.values()) {
            if (zzb2.zzmn()) {
                bl = true;
            }
            if (!zzb2.zzmJ()) continue;
            bl2 = true;
        }
        switch (this.zzagv) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.zzagi = new zzma(this.mContext, this, this.zzafz, this.zzaeK, this.zzaeL, this.zzagp, this.zzafT, this.zzafU, this.zzaeM, this.zzagu);
                return;
            }
        }
        this.zzagi = new zzmi(this.mContext, this, this.zzafz, this.zzaeK, this.zzaeL, this.zzagp, this.zzafT, this.zzafU, this.zzaeM, this.zzagu, this);
    }

    private void zzpp() {
        this.zzagh.zzqB();
        this.zzagi.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.zzafz.lock();
        try {
            if (this.zzpo()) {
                this.zzpp();
            }
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzpq() {
        this.zzafz.lock();
        try {
            boolean bl = this.zzps();
            if (bl) {
                this.zzpp();
            }
        }
        finally {
            this.zzafz.unlock();
        }
    }

    void zzpr() {
        if (this.zzpo()) {
            return;
        }
        this.zzagk = true;
        if (this.zzago == null) {
            this.zzago = zzmk.zza(this.mContext.getApplicationContext(), new zzc(this), this.zzaeL);
        }
        this.zzagn.sendMessageDelayed(this.zzagn.obtainMessage(1), this.zzagl);
        this.zzagn.sendMessageDelayed(this.zzagn.obtainMessage(2), this.zzagm);
    }

    boolean zzps() {
        if (!this.zzpo()) {
            return false;
        }
        this.zzagk = false;
        this.zzagn.removeMessages(2);
        this.zzagn.removeMessages(1);
        if (this.zzago != null) {
            this.zzago.unregister();
            this.zzago = null;
        }
        return true;
    }

    <A extends Api.zzb> void zzb(zze<A> zze2) {
        this.zzags.add(zze2);
        zze2.zza(this.zzagw);
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzagh.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.zzagh.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzagh.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzagh.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.zzagh.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzagh.unregisterConnectionFailedListener(listener);
    }

    @Override
    public void zzi(Bundle bundle) {
        while (!this.zzagj.isEmpty()) {
            this.zzb(this.zzagj.remove());
        }
        this.zzagh.zzk(bundle);
    }

    @Override
    public void zze(ConnectionResult connectionResult) {
        if (!this.zzaeL.zzd(this.mContext, connectionResult.getErrorCode())) {
            this.zzps();
        }
        if (!this.zzpo()) {
            this.zzagh.zzl(connectionResult);
            this.zzagh.zzqA();
        }
    }

    @Override
    public void zzbz(int n) {
        if (n == 1) {
            this.zzpr();
        }
        for (zze<?> zze2 : this.zzags) {
            zze2.zzy(new Status(8, "The connection to Google Play services was lost"));
        }
        this.zzagh.zzbV(n);
        this.zzagh.zzqA();
        if (n == 2) {
            this.zzpp();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzaeK;
    }

    @Override
    public boolean zza(zzmp zzmp2) {
        return this.zzagi != null && this.zzagi.zza(zzmp2);
    }

    @Override
    public void zzoF() {
        if (this.zzagi != null) {
            this.zzagi.zzoF();
        }
    }

    String zzpt() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).append("mContext=").println(this.mContext);
        writer.append(prefix).append("mResuming=").print(this.zzagk);
        writer.append(" mWorkQueue.size()=").print(this.zzagj.size());
        writer.append(" mUnconsumedRunners.size()=").println(this.zzags.size());
        if (this.zzagi != null) {
            this.zzagi.dump(prefix, fd, writer, args);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zzb> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zzb zzb2 : iterable) {
            if (zzb2.zzmn()) {
                bl2 = true;
            }
            if (!zzb2.zzmJ()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzbD(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zzmg.this.zzpq();
                    break;
                }
                case 2: {
                    zzmg.this.resume();
                    break;
                }
                default: {
                    Log.w((String)"GoogleApiClientImpl", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }

    static class zzc
    extends zzmk {
        private WeakReference<zzmg> zzagG;

        zzc(zzmg zzmg2) {
            this.zzagG = new WeakReference<zzmg>(zzmg2);
        }

        @Override
        public void zzpv() {
            zzmg zzmg2 = (zzmg)this.zzagG.get();
            if (zzmg2 == null) {
                return;
            }
            zzmg2.resume();
        }
    }

    private static class zzb
    implements IBinder.DeathRecipient,
    zzd {
        private final WeakReference<zze<?>> zzagD;
        private final WeakReference<com.google.android.gms.common.api.zza> zzagE;
        private final WeakReference<IBinder> zzagF;

        private zzb(zze zze2, com.google.android.gms.common.api.zza zza2, IBinder iBinder) {
            this.zzagE = new WeakReference<com.google.android.gms.common.api.zza>(zza2);
            this.zzagD = new WeakReference<zze>(zze2);
            this.zzagF = new WeakReference<IBinder>(iBinder);
        }

        @Override
        public void zzc(zze<?> zze2) {
            this.zzpu();
        }

        public void binderDied() {
            this.zzpu();
        }

        private void zzpu() {
            zze zze2 = (zze)this.zzagD.get();
            com.google.android.gms.common.api.zza zza2 = (com.google.android.gms.common.api.zza)this.zzagE.get();
            if (zza2 != null && zze2 != null) {
                zza2.remove(zze2.zzoL());
            }
            IBinder iBinder = (IBinder)this.zzagF.get();
            if (this.zzagF != null) {
                iBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
            }
        }
    }

    static interface zze<A extends Api.zzb> {
        public void cancel();

        public Api.zzc<A> zzoA();

        public void zzb(A var1) throws DeadObjectException;

        public void zzy(Status var1);

        public void zzx(Status var1);

        public void zza(zzd var1);

        public void zzoP();

        public int zzoQ();

        public Integer zzoL();

        public boolean isReady();
    }

    static interface zzd {
        public void zzc(zze<?> var1);
    }
}

