/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmi;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmp;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsd;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;

public class zzma
implements zzmm {
    private final Context mContext;
    private final zzmg zzafp;
    private final Looper zzaeK;
    private final zzmi zzafq;
    private final zzmi zzafr;
    private final Map<Api.zzc<?>, zzmi> zzafs = new ArrayMap();
    private final Set<zzmp> zzaft = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zzb zzafu;
    private Bundle zzafv;
    private ConnectionResult zzafw = null;
    private ConnectionResult zzafx = null;
    private final AtomicInteger zzafy = new AtomicInteger(0);
    private final Lock zzafz;
    private int zzafA = 0;

    public zzma(Context context, zzmg zzmg2, Lock lock, Looper looper, GoogleApiAvailability googleApiAvailability, Map<Api.zzc<?>, Api.zzb> map, zzf zzf2, Map<Api<?>, Integer> map2, Api.zza<? extends zzsc, zzsd> zza2, ArrayList<zzlz> arrayList) {
        Api.zzc<?> zzc2;
        Object object;
        this.mContext = context;
        this.zzafp = zzmg2;
        this.zzafz = lock;
        this.zzaeK = looper;
        Api.zzb zzb2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Api.zzc<?> arrayMap4 : map.keySet()) {
            object = map.get(arrayMap4);
            if (object.zzmJ()) {
                zzb2 = object;
            }
            if (object.zzmn()) {
                arrayMap2.put(arrayMap4, object);
                continue;
            }
            arrayMap3.put(arrayMap4, object);
        }
        this.zzafu = zzb2;
        if (arrayMap2.isEmpty()) {
            throw new IllegalStateException("CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        }
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            zzc2 = api.zzoA();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the apiTypeMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzlz>();
        ArrayList<zzlz> arrayList2 = new ArrayList<zzlz>();
        for (zzlz zzlz2 : arrayList) {
            if (arrayMap5.containsKey(zzlz2.zzafm)) {
                ((ArrayList)object).add(zzlz2);
                continue;
            }
            if (arrayMap.containsKey(zzlz2.zzafm)) {
                arrayList2.add(zzlz2);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the apiTypeMap");
        }
        zzc2 = new zzmm.zza(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzi(Bundle bundle) {
                zzma.this.zzafz.lock();
                try {
                    zzma.this.zzh(bundle);
                    zzma.this.zzafw = ConnectionResult.zzadR;
                    zzma.this.zzoW();
                }
                finally {
                    zzma.this.zzafz.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zze(ConnectionResult connectionResult) {
                zzma.this.zzafz.lock();
                try {
                    zzma.this.zzafw = connectionResult;
                    zzma.this.zzoW();
                }
                finally {
                    zzma.this.zzafz.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzbz(int n) {
                zzma.this.zzafz.lock();
                try {
                    zzma.this.zza(zzma.this.zzafr, n);
                }
                finally {
                    zzma.this.zzafz.unlock();
                }
            }
        };
        this.zzafq = new zzmi(context, this.zzafp, lock, looper, googleApiAvailability, (Map<Api.zzc<?>, Api.zzb>)arrayMap3, null, (Map<Api<?>, Integer>)arrayMap, null, arrayList2, (zzmm.zza)((Object)zzc2));
        zzmm.zza zza3 = new zzmm.zza(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzi(Bundle bundle) {
                zzma.this.zzafz.lock();
                try {
                    zzma.this.zzafx = ConnectionResult.zzadR;
                    zzma.this.zzoW();
                }
                finally {
                    zzma.this.zzafz.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zze(ConnectionResult connectionResult) {
                zzma.this.zzafz.lock();
                try {
                    zzma.this.zzafx = connectionResult;
                    zzma.this.zzoW();
                }
                finally {
                    zzma.this.zzafz.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzbz(int n) {
                zzma.this.zzafz.lock();
                try {
                    zzma.this.zza(zzma.this.zzafq, n);
                }
                finally {
                    zzma.this.zzafz.unlock();
                }
            }
        };
        this.zzafr = new zzmi(context, this.zzafp, lock, looper, googleApiAvailability, (Map<Api.zzc<?>, Api.zzb>)arrayMap2, zzf2, (Map<Api<?>, Integer>)arrayMap5, zza2, (ArrayList<zzlz>)object, zza3);
        for (Api.zzc zzc3 : arrayMap3.keySet()) {
            this.zzafs.put(zzc3, this.zzafq);
        }
        for (Api.zzc zzc3 : arrayMap2.keySet()) {
            this.zzafs.put(zzc3, this.zzafr);
        }
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzlx.zza<R, A>> T zza(T t) {
        if (t.zzoQ() == 1) {
            throw new IllegalStateException("ReportingServices.getReportingState is not supported with SIGN_IN_MODE_OPTIONAL.");
        }
        if (this.zzc(t)) {
            if (this.zzoZ()) {
                t.zzx(new Status(4, null, this.zzpa()));
                return t;
            }
            return this.zzafr.zza(t);
        }
        return this.zzafq.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzlx.zza<? extends Result, A>> T zzb(T t) {
        if (this.zzc(t)) {
            if (this.zzoZ()) {
                t.zzx(new Status(4, null, this.zzpa()));
                return t;
            }
            return this.zzafr.zzb(t);
        }
        return this.zzafq.zzb(t);
    }

    @Override
    public ConnectionResult getConnectionResult(Api<?> api) {
        if (this.zzafs.get(api.zzoA()).equals(this.zzafr)) {
            if (this.zzoZ()) {
                return new ConnectionResult(4, this.zzpa());
            }
            return this.zzafr.getConnectionResult(api);
        }
        return this.zzafq.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.zzafA = 2;
        this.zzoV();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        this.zzafx = null;
        this.zzafw = null;
        this.zzafA = 0;
        this.zzafq.disconnect();
        this.zzafr.disconnect();
        this.zzoY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        this.zzafz.lock();
        try {
            boolean bl = this.zzafq.isConnected() && (this.zzoU() || this.zzoZ() || this.zzafA == 1);
            return bl;
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        this.zzafz.lock();
        try {
            boolean bl = this.zzafq.isConnecting() || this.zzafr.isConnecting() && this.zzafA == 2;
            return bl;
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zza(zzmp zzmp2) {
        this.zzafz.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzoU()) {
                this.zzaft.add(zzmp2);
                if (this.zzafA == 0) {
                    this.zzafA = 1;
                }
                this.zzafx = null;
                this.zzafr.connect();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.zzafz.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzoF() {
        this.zzafz.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzafr.disconnect();
            this.zzafx = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzaeK);
                handler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        zzma.this.zzafz.lock();
                        try {
                            zzma.this.zzoW();
                        }
                        finally {
                            zzma.this.zzafz.unlock();
                        }
                    }
                });
            } else {
                this.zzoY();
            }
        }
        finally {
            this.zzafz.unlock();
        }
    }

    public boolean zzoU() {
        return this.zzafr.isConnected();
    }

    private void zzoV() {
        this.zzafx = null;
        this.zzafw = null;
        this.zzafq.connect();
        this.zzafr.connect();
    }

    private void zzoW() {
        if (zzma.zzd(this.zzafw)) {
            if (zzma.zzd(this.zzafx) || this.zzoZ()) {
                this.zzoX();
            } else if (this.zzafx != null) {
                if (this.zzafA == 1) {
                    this.zzoY();
                } else {
                    this.zzc(this.zzafx);
                    this.zzafq.disconnect();
                }
            }
        } else if (this.zzafw != null && zzma.zzd(this.zzafx)) {
            this.zzafr.disconnect();
            this.zzc(this.zzafw);
        } else if (this.zzafw != null && this.zzafx != null) {
            ConnectionResult connectionResult = this.zzafw;
            if (this.zzafr.zzagM < this.zzafq.zzagM) {
                connectionResult = this.zzafx;
            }
            this.zzc(connectionResult);
        }
    }

    private void zzoX() {
        switch (this.zzafA) {
            case 2: {
                this.zzafp.zzi(this.zzafv);
            }
            case 1: {
                this.zzoY();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CALLBACK_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzafA = 0;
    }

    private void zzc(ConnectionResult connectionResult) {
        switch (this.zzafA) {
            case 2: {
                this.zzafp.zze(connectionResult);
            }
            case 1: {
                this.zzoY();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CALLBACK_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzafA = 0;
    }

    private void zzoY() {
        for (zzmp zzmp2 : this.zzaft) {
            zzmp2.zzmI();
        }
        this.zzaft.clear();
    }

    private void zza(zzmi zzmi2, int n) {
        if (this.zzafy.getAndIncrement() % 2 == 1) {
            this.zzafp.zzbz(n);
        }
        zzmi2.onConnectionSuspended(n);
        this.zzafx = null;
        this.zzafw = null;
    }

    private boolean zzoZ() {
        return this.zzafx != null && this.zzafx.getErrorCode() == 4;
    }

    private boolean zzc(zzlx.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzoA();
        zzx.zzb(this.zzafs.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzafs.get(zzc2).equals(this.zzafr);
    }

    private PendingIntent zzpa() {
        if (this.zzafu == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzafp.getSessionId(), (Intent)this.zzafu.zzmK(), (int)0x8000000);
    }

    private void zzh(Bundle bundle) {
        if (this.zzafv == null) {
            this.zzafv = bundle;
        } else if (bundle != null) {
            this.zzafv.putAll(bundle);
        }
    }

    private static boolean zzd(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).append("authClient").println(":");
        this.zzafr.dump(prefix + "  ", fd, writer, args);
        writer.append(prefix).append("unauthClient").println(":");
        this.zzafq.dump(prefix + "  ", fd, writer, args);
    }
}

