/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.clearcut.LogEventParcelable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlu;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zznl;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zztk;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class zzlt
implements com.google.android.gms.clearcut.zzb {
    private static final Object zzadD = new Object();
    private static final zze zzadE = new zze();
    private static final long zzadF = TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES);
    private final zznl zzqD;
    private final zza zzadG;
    private final Object zzadH = new Object();
    private long zzadI = 0L;
    private final long zzadJ;
    private ScheduledFuture<?> zzadK = null;
    private GoogleApiClient zzYC = null;
    private final Runnable zzadL = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = zzlt.this.zzadH;
            synchronized (object) {
                if (zzlt.this.zzadI <= zzlt.this.zzqD.elapsedRealtime() && zzlt.this.zzYC != null) {
                    Log.i((String)"ClearcutLoggerApiImpl", (String)"disconnect managed GoogleApiClient");
                    zzlt.this.zzYC.disconnect();
                    zzlt.this.zzYC = null;
                }
            }
        }
    };

    public zzlt() {
        this(new zzno(), zzadF, new zzb());
    }

    public zzlt(zznl zznl2, long l, zza zza2) {
        this.zzqD = zznl2;
        this.zzadJ = l;
        this.zzadG = zza2;
    }

    @Override
    public boolean zza(GoogleApiClient googleApiClient, long l, TimeUnit timeUnit) {
        try {
            return zzadE.zza(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"ClearcutLoggerApiImpl", (String)"flush interrupted");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public PendingResult<Status> zza(GoogleApiClient googleApiClient, LogEventParcelable logEventParcelable) {
        zzlt.zza(logEventParcelable);
        return googleApiClient.zza(this.zzb(googleApiClient, logEventParcelable));
    }

    private zzd zzb(GoogleApiClient googleApiClient, LogEventParcelable logEventParcelable) {
        zzadE.zzop();
        zzd zzd2 = new zzd(logEventParcelable, googleApiClient);
        zzd2.zza(new PendingResult.zza(){

            @Override
            public void zzu(Status status) {
                zzadE.zzoq();
            }
        });
        return zzd2;
    }

    private static void zza(LogEventParcelable logEventParcelable) {
        if (logEventParcelable.zzadB != null && logEventParcelable.zzadA.zzbqD.length == 0) {
            logEventParcelable.zzadA.zzbqD = logEventParcelable.zzadB.zzon();
        }
        if (logEventParcelable.zzadC != null && logEventParcelable.zzadA.zzbqK.length == 0) {
            logEventParcelable.zzadA.zzbqK = logEventParcelable.zzadC.zzon();
        }
        logEventParcelable.zzady = zztk.toByteArray(logEventParcelable.zzadA);
    }

    private static final class zze {
        private int mSize = 0;

        private zze() {
        }

        public synchronized void zzop() {
            ++this.mSize;
        }

        public synchronized void zzoq() {
            if (this.mSize == 0) {
                throw new RuntimeException("too many decrements");
            }
            --this.mSize;
            if (this.mSize == 0) {
                this.notifyAll();
            }
        }

        public boolean zza(long l, TimeUnit timeUnit) throws InterruptedException {
            long l2 = System.currentTimeMillis();
            long l3 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            zze zze2 = this;
            synchronized (zze2) {
                while (true) {
                    if (this.mSize == 0) {
                        return true;
                    }
                    if (l3 <= 0L) {
                        return false;
                    }
                    this.wait(l3);
                    l3 -= System.currentTimeMillis() - l2;
                }
            }
        }
    }

    final class zzd
    extends zzc<Status> {
        private final LogEventParcelable zzadN;

        zzd(LogEventParcelable logEventParcelable, GoogleApiClient googleApiClient) {
            super(googleApiClient);
            this.zzadN = logEventParcelable;
        }

        @Override
        protected void zza(zzlu zzlu2) throws RemoteException {
            zzlv.zza zza2 = new zzlv.zza(){

                @Override
                public void zzv(Status status) {
                    zzd.this.zzb(status);
                }
            };
            try {
                zzlt.zza(this.zzadN);
            }
            catch (Throwable throwable) {
                Log.e((String)"ClearcutLoggerApiImpl", (String)("MessageNanoProducer " + this.zzadN.zzadB.toString() + " threw: " + throwable.toString()));
                return;
            }
            zzlu2.zza(zza2, this.zzadN);
        }

        protected Status zzb(Status status) {
            return status;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof zzd)) {
                return false;
            }
            zzd zzd2 = (zzd)rhs;
            return this.zzadN.equals(zzd2.zzadN);
        }

        public String toString() {
            return "MethodImpl(" + this.zzadN + ")";
        }

        @Override
        protected /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    public static class zzb
    implements zza {
    }

    public static interface zza {
    }

    static abstract class zzc<R extends Result>
    extends zzlx.zza<R, zzlu> {
        public zzc(GoogleApiClient googleApiClient) {
            super(com.google.android.gms.clearcut.zza.zzTo, googleApiClient);
        }
    }
}

