/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zznv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzqV();

    protected abstract Object zzcH(String var1);

    protected boolean zza(Field field) {
        if (field.zzqU() == 11) {
            if (field.zzra()) {
                return this.zzcK(field.zzrb());
            }
            return this.zzcJ(field.zzrb());
        }
        return this.zzcI(field.zzrb());
    }

    protected abstract boolean zzcI(String var1);

    protected boolean zzcJ(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzcK(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).zzald != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public HashMap<String, Object> zzqW() {
        return null;
    }

    public HashMap<String, Object> zzqX() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzqV();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzqU()) {
                case 8: {
                    stringBuilder.append("\"").append(zzni.zzj((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzni.zzk((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zznv.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzqZ()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzrb();
        if (field.zzrd() != null) {
            HashMap<String, Object> hashMap;
            zzx.zza(this.zzcH(field.zzrb()) == null, "Concrete field shouldn't be value object: %s", field.zzrb());
            HashMap<String, Object> hashMap2 = hashMap = field.zzra() ? this.zzqX() : this.zzqW();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                String string3 = "get" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                return this.getClass().getMethod(string3, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzcH(field.zzrb());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzqT() == 11) {
            Class<FastJsonResponse> clazz = field.zzrd();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzqT() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zznu.zzcO((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public int zzqT();

        public int zzqU();

        public I convertBack(O var1);
    }

    public static class Field<I, O>
    implements SafeParcelable {
        private final int mVersionCode;
        protected final int zzakU;
        protected final boolean zzakV;
        protected final int zzakW;
        protected final boolean zzakX;
        protected final String zzakY;
        protected final int zzakZ;
        protected final Class<? extends FastJsonResponse> zzala;
        protected final String zzalb;
        private FieldMappingDictionary zzalc;
        private zza<I, O> zzald;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int versionCode, int typeIn, boolean typeInArray, int typeOut, boolean typeOutArray, String outputFieldName, int safeParcelableFieldId, String concreteTypeName, ConverterWrapper wrappedConverter) {
            this.mVersionCode = versionCode;
            this.zzakU = typeIn;
            this.zzakV = typeInArray;
            this.zzakW = typeOut;
            this.zzakX = typeOutArray;
            this.zzakY = outputFieldName;
            this.zzakZ = safeParcelableFieldId;
            if (concreteTypeName == null) {
                this.zzala = null;
                this.zzalb = null;
            } else {
                this.zzala = SafeParcelResponse.class;
                this.zzalb = concreteTypeName;
            }
            this.zzald = wrappedConverter == null ? null : wrappedConverter.zzqR();
        }

        protected Field(int typeIn, boolean typeInArray, int typeOut, boolean typeOutArray, String outputFieldName, int safeParcelableFieldId, Class<? extends FastJsonResponse> concreteType, zza<I, O> converter) {
            this.mVersionCode = 1;
            this.zzakU = typeIn;
            this.zzakV = typeInArray;
            this.zzakW = typeOut;
            this.zzakX = typeOutArray;
            this.zzakY = outputFieldName;
            this.zzakZ = safeParcelableFieldId;
            this.zzala = concreteType;
            this.zzalb = concreteType == null ? null : concreteType.getCanonicalName();
            this.zzald = converter;
        }

        public Field<I, O> zzqY() {
            return new Field<I, O>(this.mVersionCode, this.zzakU, this.zzakV, this.zzakW, this.zzakX, this.zzakY, this.zzakZ, this.zzalb, this.zzrg());
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzqT() {
            return this.zzakU;
        }

        public boolean zzqZ() {
            return this.zzakV;
        }

        public int zzqU() {
            return this.zzakW;
        }

        public boolean zzra() {
            return this.zzakX;
        }

        public String zzrb() {
            return this.zzakY;
        }

        public int zzrc() {
            return this.zzakZ;
        }

        public Class<? extends FastJsonResponse> zzrd() {
            return this.zzala;
        }

        String zzre() {
            if (this.zzalb == null) {
                return null;
            }
            return this.zzalb;
        }

        public boolean zzrf() {
            return this.zzald != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.zzalc = fieldMappingDictionary;
        }

        ConverterWrapper zzrg() {
            if (this.zzald == null) {
                return null;
            }
            return ConverterWrapper.zza(this.zzald);
        }

        public Map<String, Field<?, ?>> zzrh() {
            zzx.zzy(this.zzalb);
            zzx.zzy(this.zzalc);
            return this.zzalc.zzcL(this.zzalb);
        }

        public I convertBack(O output) {
            return this.zzald.convertBack(output);
        }

        public static Field<Integer, Integer> zzi(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Double, Double> zzj(String string2, int n) {
            return new Field<Double, Double>(4, false, 4, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzk(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzl(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static Field<ArrayList<String>, ArrayList<String>> zzm(String string2, int n) {
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(zza2.zzqT(), bl, zza2.zzqU(), false, string2, n, null, zza2);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            com.google.android.gms.common.server.response.zza.zza(this, out, flags);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field\n");
            stringBuilder.append("            versionCode=").append(this.mVersionCode).append('\n');
            stringBuilder.append("                 typeIn=").append(this.zzakU).append('\n');
            stringBuilder.append("            typeInArray=").append(this.zzakV).append('\n');
            stringBuilder.append("                typeOut=").append(this.zzakW).append('\n');
            stringBuilder.append("           typeOutArray=").append(this.zzakX).append('\n');
            stringBuilder.append("        outputFieldName=").append(this.zzakY).append('\n');
            stringBuilder.append("      safeParcelFieldId=").append(this.zzakZ).append('\n');
            stringBuilder.append("       concreteTypeName=").append(this.zzre()).append('\n');
            if (this.zzrd() != null) {
                stringBuilder.append("     concreteType.class=").append(this.zzrd().getCanonicalName()).append('\n');
            }
            stringBuilder.append("          converterName=").append(this.zzald == null ? "null" : this.zzald.getClass().getCanonicalName()).append('\n');
            return stringBuilder.toString();
        }
    }
}

