/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzm
extends zzl
implements Handler.Callback {
    private final HashMap<zza, zzb> zzaki = new HashMap();
    private final Context zzrI;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb zzakj;
    private final long zzakk;

    zzm(Context context) {
        this.zzrI = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzakj = com.google.android.gms.common.stats.zzb.zzrz();
        this.zzakk = 5000L;
    }

    @Override
    public boolean zza(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2), serviceConnection, string3);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzaki;
        synchronized (hashMap) {
            zzb zzb2 = this.zzaki.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzcB(string2);
                this.zzaki.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    throw new IllegalStateException("Trying to bind a GmsServiceConnection that was already connected before.  config=" + zza2);
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzcB(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2), serviceConnection, string3);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzaki;
        synchronized (hashMap) {
            zzb zzb2 = this.zzaki.get(zza2);
            if (zzb2 == null) {
                throw new IllegalStateException("Nonexistent connection status for service config: " + zza2);
            }
            if (!zzb2.zza(serviceConnection)) {
                throw new IllegalStateException("Trying to unbind a GmsServiceConnection  that was not bound before.  config=" + zza2);
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzqD()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.zzakk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                zzb zzb2 = (zzb)msg.obj;
                HashMap<zza, zzb> hashMap = this.zzaki;
                synchronized (hashMap) {
                    if (zzb2.zzqD()) {
                        if (zzb2.isBound()) {
                            zzb2.zzcC("GmsClientSupervisor");
                        }
                        this.zzaki.remove(zzb2.zzakp);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzRA;
        private final ComponentName zzakl;

        public zza(String string2) {
            this.zzRA = zzx.zzcG(string2);
            this.zzakl = null;
        }

        public zza(ComponentName componentName) {
            this.zzRA = null;
            this.zzakl = zzx.zzy(componentName);
        }

        public String toString() {
            return this.zzRA == null ? this.zzakl.flattenToString() : this.zzRA;
        }

        public Intent zzqC() {
            Intent intent = this.zzRA != null ? new Intent(this.zzRA).setPackage("com.google.android.gms") : new Intent().setComponent(this.zzakl);
            return intent;
        }

        public int hashCode() {
            return zzw.hashCode(this.zzRA, this.zzakl);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return zzw.equal(this.zzRA, zza2.zzRA) && zzw.equal(this.zzakl, zza2.zzakl);
        }
    }

    private final class zzb {
        private final zza zzakm;
        private final Set<ServiceConnection> zzakn;
        private int mState;
        private boolean zzako;
        private IBinder zzaiT;
        private final com.google.android.gms.common.internal.zzm$zza zzakp;
        private ComponentName zzakl;

        public zzb(com.google.android.gms.common.internal.zzm$zza zza2) {
            this.zzakp = zza2;
            this.zzakm = new zza();
            this.zzakn = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        public void zzcB(String string2) {
            this.mState = 3;
            this.zzako = zzm.this.zzakj.zza(zzm.this.zzrI, string2, this.zzakp.zzqC(), this.zzakm, 129);
            if (!this.zzako) {
                this.mState = 2;
                try {
                    zzm.this.zzakj.zza(zzm.this.zzrI, this.zzakm);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzcC(String string2) {
            zzm.this.zzakj.zza(zzm.this.zzrI, this.zzakm);
            this.zzako = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzm.this.zzakj.zza(zzm.this.zzrI, serviceConnection, string2, this.zzakp.zzqC());
            this.zzakn.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzm.this.zzakj.zzb(zzm.this.zzrI, serviceConnection);
            this.zzakn.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzako;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzakn.contains(serviceConnection);
        }

        public boolean zzqD() {
            return this.zzakn.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzaiT;
        }

        public ComponentName getComponentName() {
            return this.zzakl;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName component, IBinder binder) {
                HashMap hashMap = zzm.this.zzaki;
                synchronized (hashMap) {
                    zzb.this.zzaiT = binder;
                    zzb.this.zzakl = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzakn) {
                        serviceConnection.onServiceConnected(component, binder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName component) {
                HashMap hashMap = zzm.this.zzaki;
                synchronized (hashMap) {
                    zzb.this.zzaiT = null;
                    zzb.this.zzakl = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzakn) {
                        serviceConnection.onServiceDisconnected(component);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

