/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzk
implements Handler.Callback {
    private final zza zzajZ;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzaka = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzakb = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzakc = new ArrayList();
    private volatile boolean zzakd = false;
    private final AtomicInteger zzake = new AtomicInteger(0);
    private boolean zzakf = false;
    private final Handler mHandler;
    private final Object zzpK = new Object();

    public zzk(Looper looper, zza zza2) {
        this.zzajZ = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzqA() {
        this.zzakd = false;
        this.zzake.incrementAndGet();
    }

    public void zzqB() {
        this.zzakd = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzk(Bundle bundle) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzpK;
        synchronized (object) {
            zzx.zzaa(!this.zzakf);
            this.mHandler.removeMessages(1);
            this.zzakf = true;
            zzx.zzaa(this.zzakb.size() == 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzaka);
            int n = this.zzake.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzakd || !this.zzajZ.isConnected() || this.zzake.get() != n) break;
                if (this.zzakb.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzakb.clear();
            this.zzakf = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbV(int n) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpK;
        synchronized (object) {
            this.zzakf = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzaka);
            int n2 = this.zzake.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzakd || this.zzake.get() != n2) break;
                if (!this.zzaka.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzakb.clear();
            this.zzakf = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzl(ConnectionResult connectionResult) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpK;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzakc);
            int n = this.zzake.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.zzakd || this.zzake.get() != n) {
                    return;
                }
                if (!this.zzakc.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzy(listener);
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzaka.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                this.zzaka.add(listener);
            }
        }
        if (this.zzajZ.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzy(listener);
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzaka.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzy(listener);
        Object object = this.zzpK;
        synchronized (object) {
            boolean bl = this.zzaka.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
            } else if (this.zzakf) {
                this.zzakb.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzy(listener);
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzakc.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                this.zzakc.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzy(listener);
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzakc.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzy(listener);
        Object object = this.zzpK;
        synchronized (object) {
            boolean bl = this.zzakc.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)msg.obj;
            Object object = this.zzpK;
            synchronized (object) {
                if (this.zzakd && this.zzajZ.isConnected() && this.zzaka.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzajZ.zznQ();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        Log.wtf((String)"GmsClientEvents", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zznQ();
    }
}

