/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.ValidateAccountRequest;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.internal.zzx;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzj<T extends IInterface>
implements Api.zzb,
zzk.zza {
    private final Context mContext;
    private final com.google.android.gms.common.internal.zzf zzafT;
    private final Looper zzaeK;
    private final zzl zzajH;
    private final GoogleApiAvailability zzaeL;
    final Handler mHandler;
    private final Object zzpK = new Object();
    private zzs zzajI;
    private GoogleApiClient.zza zzajJ;
    private T zzajK;
    private final ArrayList<zzc<?>> zzajL = new ArrayList();
    private zze zzajM;
    private int zzajN = 1;
    private final Set<Scope> zzVH;
    private final Account zzSo;
    private final GoogleApiClient.ConnectionCallbacks zzajO;
    private final GoogleApiClient.OnConnectionFailedListener zzajP;
    private final int zzajQ;
    protected AtomicInteger zzajR = new AtomicInteger(0);
    public static final String[] zzajS = new String[]{"service_esmobile", "service_googleme"};

    protected zzj(Context context, Looper looper, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, zzl.zzat(context), GoogleApiAvailability.getInstance(), n, zzf2, zzx.zzy(connectionCallbacks), zzx.zzy(onConnectionFailedListener));
    }

    protected zzj(Context context, Looper looper, zzl zzl2, GoogleApiAvailability googleApiAvailability, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.mContext = zzx.zzb(context, (Object)"Context must not be null");
        this.zzaeK = zzx.zzb(looper, (Object)"Looper must not be null");
        this.zzajH = zzx.zzb(zzl2, (Object)"Supervisor must not be null");
        this.zzaeL = zzx.zzb(googleApiAvailability, (Object)"API availability must not be null");
        this.mHandler = new zzb(looper);
        this.zzajQ = n;
        this.zzafT = zzx.zzy(zzf2);
        this.zzSo = zzf2.getAccount();
        this.zzVH = this.zza(zzf2.zzqb());
        this.zzajO = connectionCallbacks;
        this.zzajP = onConnectionFailedListener;
    }

    private Set<Scope> zza(Set<Scope> set) {
        Set<Scope> set2 = this.zzb(set);
        if (set2 == null) {
            return set2;
        }
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    protected Set<Scope> zzb(Set<Scope> set) {
        return set;
    }

    protected abstract String zzgh();

    protected abstract String zzgi();

    protected final String zzql() {
        return this.zzafT.zzqe();
    }

    protected abstract T zzW(IBinder var1);

    protected void zzqm() {
    }

    protected void onConnectionSuspended(int cause) {
    }

    protected void onConnectionFailed(ConnectionResult result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzx.zzab(n == 3 == (t != null));
        Object object = this.zzpK;
        synchronized (object) {
            this.zzajN = n;
            this.zzajK = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzqn();
                    break;
                }
                case 3: {
                    this.zzqm();
                    break;
                }
                case 1: {
                    this.zzqo();
                }
            }
        }
    }

    protected void zzc(int n, T t) {
    }

    private void zzqn() {
        if (this.zzajM != null) {
            Log.e((String)"GmsClient", (String)("Calling connect() while still connected, missing disconnect() for " + this.zzgh()));
            this.zzajH.zzb(this.zzgh(), (ServiceConnection)this.zzajM, this.zzql());
            this.zzajR.incrementAndGet();
        }
        this.zzajM = new zze(this.zzajR.get());
        boolean bl = this.zzajH.zza(this.zzgh(), (ServiceConnection)this.zzajM, this.zzql());
        if (!bl) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.zzgh()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzajR.get(), 9));
        }
    }

    private void zzqo() {
        if (this.zzajM != null) {
            this.zzajH.zzb(this.zzgh(), (ServiceConnection)this.zzajM, this.zzql());
            this.zzajM = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzajN != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zzqp() {
        int n = this.zzaeL.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.zzajJ = new zzf();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzajR.get(), n));
            return;
        }
        this.zza(new zzf());
    }

    @Override
    public void zza(GoogleApiClient.zza zza2) {
        this.zzajJ = zzx.zzb(zza2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzajN == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzajN == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzajR.incrementAndGet();
        ArrayList<zzc<?>> arrayList = this.zzajL;
        synchronized (arrayList) {
            int n = this.zzajL.size();
            for (int i = 0; i < n; ++i) {
                this.zzajL.get(i).zzqy();
            }
            this.zzajL.clear();
        }
        this.zzb(1, null);
    }

    public void zzbT(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.zzajR.get(), n));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzaeK;
    }

    public final Account zzpY() {
        return this.zzSo != null ? this.zzSo : new Account("<<default account>>", "com.google");
    }

    protected final com.google.android.gms.common.internal.zzf zzqq() {
        return this.zzafT;
    }

    protected Bundle zzlU() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzg(n, iBinder, bundle)));
    }

    protected void zza(int n, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzi(n, bundle)));
    }

    protected void zzbU(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, n, -1, (Object)new zzh()));
    }

    protected final void zzqr() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle zznQ() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzqs() throws DeadObjectException {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzajN == 4) {
                throw new DeadObjectException();
            }
            this.zzqr();
            zzx.zza(this.zzajK != null, (Object)"Client is connected but service is null");
            return this.zzajK;
        }
    }

    @Override
    public void zza(zzp zzp2) {
        Bundle bundle = this.zzqt();
        ValidateAccountRequest validateAccountRequest = new ValidateAccountRequest(zzp2, this.zzVH.toArray(new Scope[this.zzVH.size()]), this.mContext.getPackageName(), bundle);
        try {
            this.zzajI.zza((zzr)new zzd(this, this.zzajR.get()), validateAccountRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbT(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    protected Bundle zzqt() {
        return null;
    }

    @Override
    public void zza(zzp zzp2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzlU();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzajQ).zzcA(this.mContext.getPackageName()).zzj(bundle);
            if (set != null) {
                getServiceRequest.zzd(set);
            }
            if (this.zzmn()) {
                getServiceRequest.zzc(this.zzpY()).zzc(zzp2);
            } else if (this.zzqu()) {
                getServiceRequest.zzc(this.zzSo);
            }
            this.zzajI.zza((zzr)new zzd(this, this.zzajR.get()), getServiceRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbT(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    @Override
    public boolean zzmn() {
        return false;
    }

    public boolean zzqu() {
        return false;
    }

    @Override
    public boolean zzmJ() {
        return false;
    }

    @Override
    public Intent zzmK() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        T t;
        int n;
        Object object = this.zzpK;
        synchronized (object) {
            n = this.zzajN;
            t = this.zzajK;
        }
        writer.append(prefix).append("mConnectState=");
        switch (n) {
            case 2: {
                writer.print("CONNECTING");
                break;
            }
            case 3: {
                writer.print("CONNECTED");
                break;
            }
            case 4: {
                writer.print("DISCONNECTING");
                break;
            }
            case 1: {
                writer.print("DISCONNECTED");
                break;
            }
            default: {
                writer.print("UNKNOWN");
            }
        }
        writer.append(" mService=");
        if (t == null) {
            writer.println("null");
        } else {
            writer.append(this.zzgi()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
    }

    @Override
    public IBinder zzoC() {
        if (this.zzajI == null) {
            return null;
        }
        return this.zzajI.asBinder();
    }

    public static final class zzd
    extends zzr.zza {
        private zzj zzajW;
        private final int zzajX;

        public zzd(zzj zzj2, int n) {
            this.zzajW = zzj2;
            this.zzajX = n;
        }

        @Override
        public void zzb(int n, Bundle bundle) {
            zzx.zzb(this.zzajW, (Object)"onAccountValidationComplete can be called only once per call to validateAccount");
            this.zzajW.zza(n, bundle, this.zzajX);
            this.zzqz();
        }

        @Override
        public void zza(int n, IBinder iBinder, Bundle bundle) {
            zzx.zzb(this.zzajW, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzajW.zza(n, iBinder, bundle, this.zzajX);
            this.zzqz();
        }

        private void zzqz() {
            this.zzajW = null;
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        public final int statusCode;
        public final Bundle zzajT;

        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzajT = bundle;
        }

        protected abstract boolean zzqv();

        protected abstract void zzk(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzj.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzqv()) break;
                    zzj.this.zzb(1, null);
                    this.zzk(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzj.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzj.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzajT != null) {
                        pendingIntent = (PendingIntent)this.zzajT.getParcelable("pendingIntent");
                    }
                    this.zzk(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzqw() {
        }

        @Override
        protected /* synthetic */ void zzv(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzg
    extends zza {
        public final IBinder zzajY;

        public zzg(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzajY = iBinder;
        }

        @Override
        protected void zzk(ConnectionResult connectionResult) {
            if (zzj.this.zzajP != null) {
                zzj.this.zzajP.onConnectionFailed(connectionResult);
            }
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzqv() {
            String string2;
            try {
                string2 = this.zzajY.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzj.this.zzgi().equals(string2)) {
                Log.e((String)"GmsClient", (String)("service descriptor mismatch: " + zzj.this.zzgi() + " vs. " + string2));
                return false;
            }
            Object t = zzj.this.zzW(this.zzajY);
            if (t != null && zzj.this.zza(2, 3, t)) {
                Bundle bundle = zzj.this.zznQ();
                if (zzj.this.zzajO != null) {
                    zzj.this.zzajO.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzi
    extends zza {
        public zzi(int n, Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzk(ConnectionResult connectionResult) {
            zzj.this.zzajJ.zzb(connectionResult);
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzqv() {
            zzj.this.zzajJ.zzb(ConnectionResult.zzadR);
            return true;
        }
    }

    protected final class zzh
    extends zza {
        public zzh() {
            super(0, null);
        }

        @Override
        protected void zzk(ConnectionResult connectionResult) {
            zzj.this.zzajJ.zza(connectionResult);
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzqv() {
            zzj.this.zzajJ.zza(ConnectionResult.zzadR);
            return true;
        }
    }

    protected class zzf
    implements GoogleApiClient.zza {
        @Override
        public void zza(ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzj.this.zza(null, zzj.this.zzVH);
            } else if (zzj.this.zzajP != null) {
                zzj.this.zzajP.onConnectionFailed(connectionResult);
            }
        }

        @Override
        public void zzb(ConnectionResult connectionResult) {
            throw new IllegalStateException("Legacy GmsClient received onReportAccountValidation callback.");
        }
    }

    protected abstract class zzc<TListener> {
        private TListener mListener;
        private boolean zzajV;

        public zzc(TListener TListener) {
            this.mListener = TListener;
            this.zzajV = false;
        }

        protected abstract void zzv(TListener var1);

        protected abstract void zzqw();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzqx() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.mListener;
                if (this.zzajV) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.zzv(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzqw();
                    throw runtimeException;
                }
            } else {
                this.zzqw();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzajV = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzqy();
            ArrayList arrayList = zzj.this.zzajL;
            synchronized (arrayList) {
                zzj.this.zzajL.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzqy() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.mListener = null;
            }
        }
    }

    final class zzb
    extends Handler {
        public zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (zzj.this.zzajR.get() != msg.arg1) {
                if (this.zzb(msg)) {
                    this.zza(msg);
                }
                return;
            }
            if (!(msg.what != 1 && msg.what != 5 && msg.what != 6 || zzj.this.isConnecting())) {
                this.zza(msg);
                return;
            }
            if (msg.what == 3) {
                ConnectionResult connectionResult = new ConnectionResult(msg.arg2, null);
                zzj.this.zzajJ.zza(connectionResult);
                zzj.this.onConnectionFailed(connectionResult);
                return;
            }
            if (msg.what == 4) {
                zzj.this.zzb(4, null);
                if (zzj.this.zzajO != null) {
                    zzj.this.zzajO.onConnectionSuspended(msg.arg2);
                }
                zzj.this.onConnectionSuspended(msg.arg2);
                zzj.this.zza(4, 1, null);
                return;
            }
            if (msg.what == 2 && !zzj.this.isConnected()) {
                this.zza(msg);
                return;
            }
            if (this.zzb(msg)) {
                zzc zzc2 = (zzc)msg.obj;
                zzc2.zzqx();
                return;
            }
            Log.wtf((String)"GmsClient", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zzqw();
            zzc2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5 || message.what == 6;
        }
    }

    public final class zze
    implements ServiceConnection {
        private final int zzajX;

        public zze(int n) {
            this.zzajX = n;
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            zzx.zzb(binder, (Object)"Expecting a valid IBinder");
            zzj.this.zzajI = zzs.zza.zzaS(binder);
            zzj.this.zzbU(this.zzajX);
        }

        public void onServiceDisconnected(ComponentName component) {
            zzj.this.mHandler.sendMessage(zzj.this.mHandler.obtainMessage(4, this.zzajX, 1));
        }
    }
}

