/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;

public final class Status
implements Result,
SafeParcelable {
    public static final Status zzaeX = new Status(0);
    public static final Status zzaeY = new Status(14);
    public static final Status zzaeZ = new Status(8);
    public static final Status zzafa = new Status(15);
    public static final Status zzafb = new Status(16);
    public static final Parcelable.Creator<Status> CREATOR = new zzd();
    private final int mVersionCode;
    private final int zzabx;
    private final String zzadS;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.mVersionCode = versionCode;
        this.zzabx = statusCode;
        this.zzadS = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent zzoN() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.zzadS;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzabx <= 0;
    }

    public boolean isCanceled() {
        return this.zzabx == 16;
    }

    public boolean isInterrupted() {
        return this.zzabx == 14;
    }

    public int getStatusCode() {
        return this.zzabx;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzw.hashCode(this.mVersionCode, this.zzabx, this.zzadS, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.mVersionCode == status.mVersionCode && this.zzabx == status.zzabx && zzw.equal(this.zzadS, status.zzadS) && zzw.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzoO() {
        if (this.zzadS != null) {
            return this.zzadS;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzabx);
    }

    public String toString() {
        return zzw.zzx(this).zzg("statusCode", this.zzoO()).zzg("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

