/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzly;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zzly<BatchResult> {
    private int zzaes;
    private boolean zzaet;
    private boolean zzaeu;
    private final PendingResult<?>[] zzaev;
    private final Object zzpK = new Object();

    private Batch(List<PendingResult<?>> pendingResultList, GoogleApiClient apiClient) {
        super(apiClient);
        this.zzaes = pendingResultList.size();
        this.zzaev = new PendingResult[this.zzaes];
        for (int i = 0; i < pendingResultList.size(); ++i) {
            PendingResult<?> pendingResult = pendingResultList.get(i);
            this.zzaev[i] = pendingResult;
            pendingResult.zza(new PendingResult.zza(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzu(Status status) {
                    Object object = Batch.this.zzpK;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzaeu = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzaet = true;
                        }
                        Batch.this.zzaes--;
                        if (Batch.this.zzaes == 0) {
                            if (Batch.this.zzaeu) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzaet ? new Status(13) : Status.zzaeX;
                                Batch.this.zzb(new BatchResult(status2, Batch.this.zzaev));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzaev) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzaev);
    }

    @Override
    public /* synthetic */ Result zzc(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzaex = new ArrayList();
        private GoogleApiClient zzYC;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzYC = googleApiClient;
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzaex.size());
            this.zzaex.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzaex, this.zzYC);
        }
    }
}

