/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Api<O extends ApiOptions> {
    private final zza<?, O> zzaep;
    private final zze<?, O> zzaeq;
    private final zzc<?> zzacX;
    private final zzf<?> zzaer;
    private final String mName;

    public <C extends zzb> Api(String name, zza<C, O> clientBuilder, zzc<C> clientKey) {
        zzx.zzb(clientBuilder, (Object)"Cannot construct an Api with a null ClientBuilder");
        zzx.zzb(clientKey, (Object)"Cannot construct an Api with a null ClientKey");
        this.mName = name;
        this.zzaep = clientBuilder;
        this.zzaeq = null;
        this.zzacX = clientKey;
        this.zzaer = null;
    }

    public zza<?, O> zzoy() {
        zzx.zza(this.zzaep != null, (Object)"This API was constructed with a SimpleClientBuilder. Use getSimpleClientBuilder");
        return this.zzaep;
    }

    public zze<?, O> zzoz() {
        zzx.zza(this.zzaeq != null, (Object)"This API was constructed with a ClientBuilder. Use getClientBuilder");
        return this.zzaeq;
    }

    public zzc<?> zzoA() {
        zzx.zza(this.zzacX != null, (Object)"This API was constructed with a SimpleClientKey. Use getSimpleClientKey");
        return this.zzacX;
    }

    public boolean zzoB() {
        return this.zzaer != null;
    }

    public String getName() {
        return this.mName;
    }

    public static interface zzd<T extends IInterface> {
        public String zzgh();

        public String zzgi();

        public T zzW(IBinder var1);

        public void zza(int var1, T var2);
    }

    public static interface zzb {
        public void zza(GoogleApiClient.zza var1);

        public void disconnect();

        public boolean isConnected();

        public void zza(zzp var1);

        public void zza(zzp var1, Set<Scope> var2);

        public boolean zzmn();

        public boolean zzmJ();

        public Intent zzmK();

        public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

        public IBinder zzoC();
    }

    public static final class zzf<C extends zzd> {
    }

    public static final class zzc<C extends zzb> {
    }

    public static interface ApiOptions {

        public static final class NoOptions
        implements NotRequiredOptions {
            private NoOptions() {
            }
        }

        public static interface Optional
        extends HasOptions,
        NotRequiredOptions {
        }

        public static interface HasOptions
        extends ApiOptions {
        }

        public static interface NotRequiredOptions
        extends ApiOptions {
        }
    }

    public static interface zze<T extends zzd, O> {
        public T zzp(O var1);

        public int getPriority();

        public int zzoD();
    }

    public static abstract class zza<T extends zzb, O> {
        public abstract T zza(Context var1, Looper var2, com.google.android.gms.common.internal.zzf var3, O var4, GoogleApiClient.ConnectionCallbacks var5, GoogleApiClient.OnConnectionFailedListener var6);

        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public List<Scope> zzn(O o) {
            return Collections.emptyList();
        }
    }
}

