/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
implements Api.ApiOptions.Optional,
SafeParcelable {
    public static final Scope zzVA = new Scope("profile");
    public static final Scope zzVB = new Scope("email");
    public static final Scope zzVC = new Scope("openid");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzd();
    final int versionCode;
    private final ArrayList<Scope> zzVr;
    private Account zzSo;
    private boolean zzVD;
    private final boolean zzVE;
    private final boolean zzVF;
    private String zzVG;

    public static GoogleSignInOptions zzbG(String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        String string4 = jSONObject.optString("serverClientId", null);
        return new GoogleSignInOptions(hashSet, account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), string4);
    }

    GoogleSignInOptions(int versionCode, ArrayList<Scope> scopes, Account account, boolean idTokenRequested, boolean serverAuthCodeRequested, boolean forceCodeForRefreshToken, String serverClientId) {
        this.versionCode = versionCode;
        this.zzVr = scopes;
        this.zzSo = account;
        this.zzVD = idTokenRequested;
        this.zzVE = serverAuthCodeRequested;
        this.zzVF = forceCodeForRefreshToken;
        this.zzVG = serverClientId;
    }

    private GoogleSignInOptions(Set<Scope> scopes, Account account, boolean idTokenRequested, boolean serverAuthCodeRequested, boolean forceCodeForRefreshToken, String serverClientId) {
        this(1, new ArrayList<Scope>(scopes), account, idTokenRequested, serverAuthCodeRequested, forceCodeForRefreshToken, serverClientId);
    }

    public ArrayList<Scope> zzmu() {
        return new ArrayList<Scope>(this.zzVr);
    }

    public Scope[] getScopeArray() {
        return this.zzVr.toArray(new Scope[this.zzVr.size()]);
    }

    public Account getAccount() {
        return this.zzSo;
    }

    public boolean zzmy() {
        return this.zzVD;
    }

    public boolean zzmz() {
        return this.zzVE;
    }

    public boolean zzmA() {
        return this.zzVF;
    }

    public String zzmB() {
        return this.zzVG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)obj;
            if (this.zzVr.size() != googleSignInOptions.zzmu().size() || !this.zzVr.containsAll(googleSignInOptions.zzmu())) {
                return false;
            }
            return (this.zzSo == null ? googleSignInOptions.getAccount() == null : this.zzSo.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.zzVG) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzmB()) : this.zzVG.equals(googleSignInOptions.zzmB())) && this.zzVF == googleSignInOptions.zzmA() && this.zzVD == googleSignInOptions.zzmy() && this.zzVE == googleSignInOptions.zzmz();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.zzVr) {
            arrayList.add(scope.zzoM());
        }
        Collections.sort(arrayList);
        return new zze().zzo(arrayList).zzo(this.zzSo).zzo(this.zzVG).zzP(this.zzVF).zzP(this.zzVD).zzP(this.zzVE).zzmM();
    }

    public String zzmr() {
        return this.zzms().toString();
    }

    private JSONObject zzms() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            for (Scope scope : this.zzVr) {
                jSONArray.put((Object)scope.zzoM());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzSo != null) {
                jSONObject.put("accountName", (Object)this.zzSo.name);
            }
            jSONObject.put("idTokenRequested", this.zzVD);
            jSONObject.put("forceCodeForRefreshToken", this.zzVF);
            jSONObject.put("serverAuthRequested", this.zzVE);
            if (!TextUtils.isEmpty((CharSequence)this.zzVG)) {
                jSONObject.put("serverClientId", (Object)this.zzVG);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> zzVH = new HashSet<Scope>();
        private boolean zzVE;
        private boolean zzVF;
        private boolean zzVD;
        private String zzVG;
        private Account zzSo;

        public Builder() {
        }

        public Builder(GoogleSignInOptions googleSignInOptions) {
            zzx.zzy(googleSignInOptions);
            this.zzVH = new HashSet<Scope>(googleSignInOptions.zzVr);
            this.zzVE = googleSignInOptions.zzVE;
            this.zzVF = googleSignInOptions.zzVF;
            this.zzVD = googleSignInOptions.zzVD;
            this.zzVG = googleSignInOptions.zzVG;
            this.zzSo = googleSignInOptions.zzSo;
        }

        public Builder requestId() {
            this.zzVH.add(zzVC);
            return this;
        }

        public Builder requestEmail() {
            this.zzVH.add(zzVB);
            return this;
        }

        public Builder requestProfile() {
            this.zzVH.add(zzVA);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopes) {
            this.zzVH.add(scope);
            this.zzVH.addAll(Arrays.asList(scopes));
            return this;
        }

        public Builder requestIdToken(String serverClientId) {
            this.requestId();
            this.zzVD = true;
            this.zzVG = this.zzbH(serverClientId);
            return this;
        }

        public Builder requestServerAuthCode(String serverClientId) {
            return this.requestServerAuthCode(serverClientId, false);
        }

        public Builder requestServerAuthCode(String serverClientId, boolean forceCodeForRefreshToken) {
            this.zzVE = true;
            this.zzVG = this.zzbH(serverClientId);
            this.zzVF = forceCodeForRefreshToken;
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzSo = new Account(zzx.zzcG(accountName), "com.google");
            return this;
        }

        public GoogleSignInOptions build() {
            return new GoogleSignInOptions(this.zzVH, this.zzSo, this.zzVD, this.zzVE, this.zzVF, this.zzVG);
        }

        private String zzbH(String string2) {
            zzx.zzcG(string2);
            zzx.zzb(this.zzVG == null || this.zzVG.equals(string2), (Object)"two different server client ids provided");
            return string2;
        }
    }
}

