/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Patterns;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import org.json.JSONException;
import org.json.JSONObject;

public class EmailSignInOptions
implements SafeParcelable {
    public static final Parcelable.Creator<EmailSignInOptions> CREATOR = new zza();
    final int versionCode;
    private final Uri zzVo;
    private String zzVp;
    private Uri zzVq;

    EmailSignInOptions(int versionCode, Uri serverWidgetUrl, String modeQueryName, Uri tosUrl) {
        zzx.zzb(serverWidgetUrl, (Object)"Server widget url cannot be null in order to use email/password sign in.");
        zzx.zzh(serverWidgetUrl.toString(), "Server widget url cannot be null in order to use email/password sign in.");
        zzx.zzb(Patterns.WEB_URL.matcher(serverWidgetUrl.toString()).matches(), (Object)"Invalid server widget url");
        this.versionCode = versionCode;
        this.zzVo = serverWidgetUrl;
        this.zzVp = modeQueryName;
        this.zzVq = tosUrl;
    }

    public Uri zzmo() {
        return this.zzVo;
    }

    public Uri zzmp() {
        return this.zzVq;
    }

    public String zzmq() {
        return this.zzVp;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            EmailSignInOptions emailSignInOptions = (EmailSignInOptions)obj;
            return this.zzVo.equals((Object)emailSignInOptions.zzmo()) && (this.zzVq == null ? emailSignInOptions.zzmp() == null : this.zzVq.equals((Object)emailSignInOptions.zzmp())) && (TextUtils.isEmpty((CharSequence)this.zzVp) ? TextUtils.isEmpty((CharSequence)emailSignInOptions.zzmq()) : this.zzVp.equals(emailSignInOptions.zzmq()));
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return new zze().zzo(this.zzVo).zzo(this.zzVq).zzo(this.zzVp).zzmM();
    }

    public String zzmr() {
        return this.zzms().toString();
    }

    private JSONObject zzms() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("serverWidgetUrl", (Object)this.zzVo.toString());
            if (!TextUtils.isEmpty((CharSequence)this.zzVp)) {
                jSONObject.put("modeQueryName", (Object)this.zzVp);
            }
            if (this.zzVq != null) {
                jSONObject.put("tosUrl", (Object)this.zzVq.toString());
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

