/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.internal.zzav;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzoH;
    zzav zzoI;
    boolean zzoJ;
    Object zzoK = new Object();
    zza zzoL;
    private final Context mContext;
    final long zzoM;
    private static boolean zzoN = false;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L);
    }

    public AdvertisingIdClient(Context context, long timeoutInMillis) {
        zzx.zzy(context);
        this.mContext = context;
        this.zzoJ = false;
        this.zzoM = timeoutInMillis;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzb(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzb(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzx.zzcy("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzoJ) {
                this.finish();
            }
            this.zzoH = AdvertisingIdClient.zzp(this.mContext);
            this.zzoI = AdvertisingIdClient.zza(this.mContext, this.zzoH);
            this.zzoJ = true;
            if (bl) {
                this.zzaL();
            }
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean shouldSkipGmsCoreVersionCheck) {
        zzoN = shouldSkipGmsCoreVersionCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzaL() {
        Object object = this.zzoK;
        synchronized (object) {
            if (this.zzoL != null) {
                this.zzoL.cancel();
                try {
                    this.zzoL.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.zzoM > 0L) {
                this.zzoL = new zza(this, this.zzoM);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        zzx.zzcy("Calling this from your main thread can lead to deadlock");
        Info info = null;
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzoJ) {
                Object object = this.zzoK;
                synchronized (object) {
                    if (this.zzoL == null || !this.zzoL.zzaM()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zzb(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzoJ) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzx.zzy(this.zzoH);
            zzx.zzy(this.zzoI);
            try {
                info = new Info(this.zzoI.getId(), this.zzoI.zzc(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzaL();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzx.zzcy("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzoH == null) {
                return;
            }
            try {
                if (this.zzoJ) {
                    zzb.zzrz().zza(this.mContext, this.zzoH);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            this.zzoJ = false;
            this.zzoI = null;
            this.zzoH = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzp(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        if (zzoN) {
            Log.d((String)"Ads", (String)"Skipping gmscore version check");
            int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            switch (n) {
                case 0: 
                case 2: {
                    break;
                }
                default: {
                    throw new IOException("Google Play services not available");
                }
            }
        } else {
            try {
                GooglePlayServicesUtil.zzac(context);
            }
            catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                throw new IOException(googlePlayServicesNotAvailableException);
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (zzb.zzrz().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L);
        try {
            advertisingIdClient.zzb(false);
            Info info = advertisingIdClient.getInfo();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static zzav zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzav.zza.zzb(zza2.zzor());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzoS;
        private final boolean zzoT;

        public Info(String advertisingId, boolean limitAdTrackingEnabled) {
            this.zzoS = advertisingId;
            this.zzoT = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.zzoS;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzoT;
        }

        public String toString() {
            return "{" + this.zzoS + "}" + this.zzoT;
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzoO;
        private long zzoP;
        CountDownLatch zzoQ;
        boolean zzoR;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzoO = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzoP = l;
            this.zzoQ = new CountDownLatch(1);
            this.zzoR = false;
            this.start();
        }

        public void cancel() {
            this.zzoQ.countDown();
        }

        public boolean zzaM() {
            return this.zzoR;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzoO.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzoR = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzoQ.await(this.zzoP, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

