/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzll;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzlp
extends Fragment
implements DialogInterface.OnCancelListener {
    private static final GoogleApiAvailability zzacJ = GoogleApiAvailability.getInstance();
    private boolean mStarted;
    private boolean zzacK;
    private int zzacL = -1;
    private ConnectionResult zzacM;
    private final Handler zzacN = new Handler(Looper.getMainLooper());
    private zzll zzacO;
    private final SparseArray<zza> zzacP = new SparseArray();

    public static zzlp zza(FragmentActivity fragmentActivity) {
        zzlp zzlp2;
        zzx.zzci("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzlp2 = (zzlp)fragmentManager.findFragmentByTag("GmsSupportLifecycleFragment");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFragment is not a SupportLifecycleFragment", classCastException);
        }
        if (zzlp2 == null || zzlp2.isRemoving()) {
            return null;
        }
        return zzlp2;
    }

    public static zzlp zzb(FragmentActivity fragmentActivity) {
        zzlp zzlp2 = zzlp.zza(fragmentActivity);
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        if (zzlp2 == null) {
            zzlp2 = new zzlp();
            fragmentManager.beginTransaction().add((Fragment)zzlp2, "GmsSupportLifecycleFragment").commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return zzlp2;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzx.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzx.zza(this.zzacP.indexOfKey(n) < 0, (Object)("Already managing a GoogleApiClient with id " + n));
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzacP.put(n, (Object)zza2);
        if (this.mStarted && !this.zzacK) {
            googleApiClient.connect();
        }
    }

    public void zzbp(int n) {
        zza zza2 = (zza)this.zzacP.get(n);
        this.zzacP.remove(n);
        if (zza2 != null) {
            zza2.zzom();
        }
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzacL, new ConnectionResult(13, null));
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzacK = savedInstanceState.getBoolean("resolving_error", false);
            this.zzacL = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzacL >= 0) {
                this.zzacM = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzacK);
        if (this.zzacL >= 0) {
            outState.putInt("failed_client_id", this.zzacL);
            outState.putInt("failed_status", this.zzacM.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzacM.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
        if (!this.zzacK) {
            for (int i = 0; i < this.zzacP.size(); ++i) {
                zza zza2 = (zza)this.zzacP.valueAt(i);
                zza2.zzacR.connect();
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (zzacJ.isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode == -1) {
                    bl = true;
                    break;
                }
                if (resultCode != 0) break;
                this.zzacM = new ConnectionResult(13, null);
            }
        }
        if (bl) {
            this.zzok();
        } else {
            this.zza(this.zzacL, this.zzacM);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
        for (int i = 0; i < this.zzacP.size(); ++i) {
            zza zza2 = (zza)this.zzacP.valueAt(i);
            zza2.zzacR.disconnect();
        }
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        for (int i = 0; i < this.zzacP.size(); ++i) {
            zza zza2 = (zza)this.zzacP.valueAt(i);
            zza2.dump(prefix, fd, writer, args);
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFragment", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zza zza2 = (zza)this.zzacP.get(n);
        if (zza2 != null) {
            this.zzbp(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzacS;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zzok();
    }

    private void zzok() {
        this.zzacK = false;
        this.zzacL = -1;
        this.zzacM = null;
        if (this.zzacO != null) {
            this.zzacO.unregister();
            this.zzacO = null;
        }
        for (int i = 0; i < this.zzacP.size(); ++i) {
            zza zza2 = (zza)this.zzacP.valueAt(i);
            zza2.zzacR.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzacQ;
        public final GoogleApiClient zzacR;
        public final GoogleApiClient.OnConnectionFailedListener zzacS;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzacQ = n;
            this.zzacR = googleApiClient;
            this.zzacS = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zzlp.this.zzacN.post((Runnable)new zzb(this.zzacQ, result));
        }

        public void zzom() {
            this.zzacR.unregisterConnectionFailedListener(this);
            this.zzacR.disconnect();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.append(prefix).append("GoogleApiClient #").print(this.zzacQ);
            writer.println(":");
            this.zzacR.dump(prefix + "  ", fd, writer, args);
        }
    }

    private class zzb
    implements Runnable {
        private final int zzacU;
        private final ConnectionResult zzacV;

        public zzb(int n, ConnectionResult connectionResult) {
            this.zzacU = n;
            this.zzacV = connectionResult;
        }

        @Override
        public void run() {
            if (!zzlp.this.mStarted || zzlp.this.zzacK) {
                return;
            }
            zzlp.this.zzacK = true;
            zzlp.this.zzacL = this.zzacU;
            zzlp.this.zzacM = this.zzacV;
            if (this.zzacV.hasResolution()) {
                try {
                    int n = zzlp.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)zzlp.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzacV.startResolutionForResult((Activity)zzlp.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzlp.this.zzok();
                }
            } else if (zzacJ.isUserResolvableError(this.zzacV.getErrorCode())) {
                GooglePlayServicesUtil.showErrorDialogFragment(this.zzacV.getErrorCode(), (Activity)zzlp.this.getActivity(), zzlp.this, 2, zzlp.this);
            } else if (this.zzacV.getErrorCode() == 18) {
                final Dialog dialog = zzacJ.zza((Activity)zzlp.this.getActivity(), zzlp.this);
                zzlp.this.zzacO = zzll.zza(zzlp.this.getActivity().getApplicationContext(), new zzll(){

                    @Override
                    protected void zzoi() {
                        zzlp.this.zzok();
                        dialog.dismiss();
                    }
                });
            } else {
                zzlp.this.zza(this.zzacU, this.zzacV);
            }
        }
    }
}

