/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzm
extends zzl
implements Handler.Callback {
    private final HashMap<zza, zzb> zzafY = new HashMap();
    private final Context zzqZ;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb zzafZ;
    private final long zzaga;

    zzm(Context context) {
        this.zzqZ = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzafZ = com.google.android.gms.common.stats.zzb.zzqh();
        this.zzaga = 5000L;
    }

    @Override
    public boolean zza(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2), serviceConnection, string3);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzafY;
        synchronized (hashMap) {
            zzb zzb2 = this.zzafY.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzcm(string2);
                this.zzafY.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    throw new IllegalStateException("Trying to bind a GmsServiceConnection that was already connected before.  config=" + zza2);
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzcm(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2), serviceConnection, string3);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzafY;
        synchronized (hashMap) {
            zzb zzb2 = this.zzafY.get(zza2);
            if (zzb2 == null) {
                throw new IllegalStateException("Nonexistent connection status for service config: " + zza2);
            }
            if (!zzb2.zza(serviceConnection)) {
                throw new IllegalStateException("Trying to unbind a GmsServiceConnection  that was not bound before.  config=" + zza2);
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzpn()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.zzaga);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                zzb zzb2 = (zzb)msg.obj;
                HashMap<zza, zzb> hashMap = this.zzafY;
                synchronized (hashMap) {
                    if (zzb2.zzpn()) {
                        if (zzb2.isBound()) {
                            zzb2.zzcn("GmsClientSupervisor");
                        }
                        this.zzafY.remove(zzb2.zzagf);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzPp;
        private final ComponentName zzagb;

        public zza(String string2) {
            this.zzPp = zzx.zzcr(string2);
            this.zzagb = null;
        }

        public zza(ComponentName componentName) {
            this.zzPp = null;
            this.zzagb = zzx.zzw(componentName);
        }

        public String toString() {
            return this.zzPp == null ? this.zzagb.flattenToString() : this.zzPp;
        }

        public Intent zzpm() {
            Intent intent = this.zzPp != null ? new Intent(this.zzPp).setPackage("com.google.android.gms") : new Intent().setComponent(this.zzagb);
            return intent;
        }

        public int hashCode() {
            return zzw.hashCode(this.zzPp, this.zzagb);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return zzw.equal(this.zzPp, zza2.zzPp) && zzw.equal(this.zzagb, zza2.zzagb);
        }
    }

    private final class zzb {
        private final zza zzagc;
        private final Set<ServiceConnection> zzagd;
        private int mState;
        private boolean zzage;
        private IBinder zzaeJ;
        private final com.google.android.gms.common.internal.zzm$zza zzagf;
        private ComponentName zzagb;

        public zzb(com.google.android.gms.common.internal.zzm$zza zza2) {
            this.zzagf = zza2;
            this.zzagc = new zza();
            this.zzagd = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        public void zzcm(String string2) {
            this.mState = 3;
            this.zzage = zzm.this.zzafZ.zza(zzm.this.zzqZ, string2, this.zzagf.zzpm(), this.zzagc, 129);
            if (!this.zzage) {
                this.mState = 2;
                try {
                    zzm.this.zzafZ.zza(zzm.this.zzqZ, this.zzagc);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzcn(String string2) {
            zzm.this.zzafZ.zza(zzm.this.zzqZ, this.zzagc);
            this.zzage = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzm.this.zzafZ.zza(zzm.this.zzqZ, serviceConnection, string2, this.zzagf.zzpm());
            this.zzagd.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzm.this.zzafZ.zzb(zzm.this.zzqZ, serviceConnection);
            this.zzagd.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzage;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzagd.contains(serviceConnection);
        }

        public boolean zzpn() {
            return this.zzagd.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzaeJ;
        }

        public ComponentName getComponentName() {
            return this.zzagb;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName component, IBinder binder) {
                HashMap hashMap = zzm.this.zzafY;
                synchronized (hashMap) {
                    zzb.this.zzaeJ = binder;
                    zzb.this.zzagb = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzagd) {
                        serviceConnection.onServiceConnected(component, binder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName component) {
                HashMap hashMap = zzm.this.zzafY;
                synchronized (hashMap) {
                    zzb.this.zzaeJ = null;
                    zzb.this.zzagb = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzagd) {
                        serviceConnection.onServiceDisconnected(component);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

