/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzk
implements Handler.Callback {
    private final zza zzafP;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzafQ = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzafR = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzafS = new ArrayList();
    private volatile boolean zzafT = false;
    private final AtomicInteger zzafU = new AtomicInteger(0);
    private boolean zzafV = false;
    private final Handler mHandler;
    private final Object zzpd = new Object();

    public zzk(Looper looper, zza zza2) {
        this.zzafP = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzpk() {
        this.zzafT = false;
        this.zzafU.incrementAndGet();
    }

    public void zzpl() {
        this.zzafT = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzh(Bundle bundle) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzpd;
        synchronized (object) {
            zzx.zzZ(!this.zzafV);
            this.mHandler.removeMessages(1);
            this.zzafV = true;
            zzx.zzZ(this.zzafR.size() == 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzafQ);
            int n = this.zzafU.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzafT || !this.zzafP.isConnected() || this.zzafU.get() != n) break;
                if (this.zzafR.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzafR.clear();
            this.zzafV = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbG(int n) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpd;
        synchronized (object) {
            this.zzafV = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzafQ);
            int n2 = this.zzafU.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzafT || this.zzafU.get() != n2) break;
                if (!this.zzafQ.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzafR.clear();
            this.zzafV = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzi(ConnectionResult connectionResult) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpd;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzafS);
            int n = this.zzafU.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.zzafT || this.zzafU.get() != n) {
                    return;
                }
                if (!this.zzafS.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzw(listener);
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzafQ.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                this.zzafQ.add(listener);
            }
        }
        if (this.zzafP.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzw(listener);
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzafQ.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzw(listener);
        Object object = this.zzpd;
        synchronized (object) {
            boolean bl = this.zzafQ.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
            } else if (this.zzafV) {
                this.zzafR.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzw(listener);
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzafS.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                this.zzafS.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzw(listener);
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzafS.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzw(listener);
        Object object = this.zzpd;
        synchronized (object) {
            boolean bl = this.zzafS.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)msg.obj;
            Object object = this.zzpd;
            synchronized (object) {
                if (this.zzafT && this.zzafP.isConnected() && this.zzafQ.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzafP.zzmS();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        Log.wtf((String)"GmsClientEvents", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzmS();
    }
}

