/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlc;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zzlc<BatchResult> {
    private int zzaay;
    private boolean zzaaz;
    private boolean zzaaA;
    private final PendingResult<?>[] zzaaB;
    private final Object zzpd = new Object();

    private Batch(List<PendingResult<?>> pendingResultList, GoogleApiClient apiClient) {
        super(apiClient);
        this.zzaay = pendingResultList.size();
        this.zzaaB = new PendingResult[this.zzaay];
        for (int i = 0; i < pendingResultList.size(); ++i) {
            PendingResult<?> pendingResult = pendingResultList.get(i);
            this.zzaaB[i] = pendingResult;
            pendingResult.zza(new PendingResult.zza(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzt(Status status) {
                    Object object = Batch.this.zzpd;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzaaA = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzaaz = true;
                        }
                        Batch.this.zzaay--;
                        if (Batch.this.zzaay == 0) {
                            if (Batch.this.zzaaA) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzaaz ? new Status(13) : Status.zzabb;
                                Batch.this.zzb(new BatchResult(status2, Batch.this.zzaaB));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzaaB) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzaaB);
    }

    @Override
    public /* synthetic */ Result zzb(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzaaD = new ArrayList();
        private GoogleApiClient zzVs;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzVs = googleApiClient;
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzaaD.size());
            this.zzaaD.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzaaD, this.zzVs);
        }
    }
}

