/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.proxy;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Patterns;
import com.google.android.gms.auth.api.proxy.zzb;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProxyRequest
implements SafeParcelable {
    public static final int VERSION_CODE = 2;
    public static final Parcelable.Creator<ProxyRequest> CREATOR = new zzb();
    public static final int HTTP_METHOD_GET;
    public static final int HTTP_METHOD_POST;
    public static final int HTTP_METHOD_PUT;
    public static final int HTTP_METHOD_DELETE;
    public static final int HTTP_METHOD_HEAD;
    public static final int HTTP_METHOD_OPTIONS;
    public static final int HTTP_METHOD_TRACE;
    public static final int HTTP_METHOD_PATCH;
    public static final int LAST_CODE;
    final int versionCode;
    public final String url;
    public final int httpMethod;
    public final long timeoutMillis;
    public final byte[] body;
    Bundle zzSK;

    ProxyRequest(int version, String googleUrl, int httpMethod, long timeoutMillis, byte[] body, Bundle headers) {
        this.versionCode = version;
        this.url = googleUrl;
        this.httpMethod = httpMethod;
        this.timeoutMillis = timeoutMillis;
        this.body = body;
        this.zzSK = headers;
    }

    public Map<String, String> getHeaderMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.zzSK.size());
        for (String string2 : this.zzSK.keySet()) {
            linkedHashMap.put(string2, this.zzSK.getString(string2));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public String toString() {
        return "ProxyRequest[ url: " + this.url + ", method: " + this.httpMethod + " ]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzb.zza(this, parcel, flags);
    }

    static {
        int n = 0;
        HTTP_METHOD_GET = n++;
        HTTP_METHOD_POST = n++;
        HTTP_METHOD_PUT = n++;
        HTTP_METHOD_DELETE = n++;
        HTTP_METHOD_HEAD = n++;
        HTTP_METHOD_OPTIONS = n++;
        HTTP_METHOD_TRACE = n++;
        HTTP_METHOD_PATCH = n++;
        LAST_CODE = n - 1;
    }

    public static class Builder {
        private String zzSL;
        private int zzSM = HTTP_METHOD_GET;
        private long zzSN = 3000L;
        private byte[] zzSO = null;
        private Bundle zzSP = new Bundle();

        public Builder(String url) {
            zzx.zzcr(url);
            if (!Patterns.WEB_URL.matcher(url).matches()) {
                throw new IllegalArgumentException("The supplied url [ " + url + "] is not match Patterns.WEB_URL!");
            }
            this.zzSL = url;
        }

        public Builder setHttpMethod(int method) {
            zzx.zzb(method >= 0 && method <= LAST_CODE, (Object)"Unrecognized http method code.");
            this.zzSM = method;
            return this;
        }

        public Builder setTimeoutMillis(long timeoutMillis) {
            zzx.zzb(timeoutMillis >= 0L, (Object)"The specified timeout must be non-negative.");
            this.zzSN = timeoutMillis;
            return this;
        }

        public Builder putHeader(String name, String value) {
            zzx.zzh(name, "Header name cannot be null or empty!");
            this.zzSP.putString(name, value == null ? "" : value);
            return this;
        }

        public Builder setBody(byte[] body) {
            this.zzSO = body;
            return this;
        }

        public ProxyRequest build() {
            if (this.zzSO == null) {
                this.zzSO = new byte[0];
            }
            return new ProxyRequest(2, this.zzSL, this.zzSM, this.zzSN, this.zzSO, this.zzSP);
        }
    }
}

