/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.common.zzi;
import com.google.android.gms.internal.common.zzj;
import com.google.android.gms.internal.common.zzl;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    @NonNull
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";
    private static final GoogleApiAvailabilityLight zza = GoogleApiAvailabilityLight.getInstance();
    private static final Object zzb = new Object();
    @GuardedBy(value="ProviderInstaller.lock")
    @Nullable
    private static Method zzc = null;
    @GuardedBy(value="ProviderInstaller.lock")
    private static boolean zzd = false;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void installIfNeeded(@NonNull Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Preconditions.checkNotNull(context, "Context must not be null");
        ProviderInstaller.zza.verifyGooglePlayServicesIsAvailable(var0, 11925000);
        var2_1 = SystemClock.uptimeMillis();
        var4_2 = ProviderInstaller.zzb;
        synchronized (var4_2) {
            block15: {
                var1_3 = ProviderInstaller.zzd;
                if (!var1_3) {
                    try {
                        var1_4 = DynamiteModule.load(var0, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "com.google.android.gms.providerinstaller.dynamite");
                        var1_4 = var1_4.getModuleContext();
                    }
                    catch (DynamiteModule.LoadingException var1_6) {
                        var1_4 = var1_6.getMessage();
                        Log.w((String)"ProviderInstaller", (String)"Failed to load providerinstaller module: ".concat(String.valueOf(var1_4)));
                        var1_4 = null;
                    }
                    if (var1_4 != null) {
                        ProviderInstaller.zzb((Context)var1_4, var0, "com.google.android.gms.providerinstaller.ProviderInstallerImpl");
                        return;
                    }
                }
                var1_3 = ProviderInstaller.zzd;
                var1_3 ^= true;
                var5_8 = GooglePlayServicesUtilLight.getRemoteContext(var0);
                if (var5_8 == null) {
                    var1_5 /* !! */  = null;
                } else {
                    ProviderInstaller.zzd = true;
                    if (var1_3) {
                        var6_9 = SystemClock.uptimeMillis();
                        var1_5 /* !! */  = "com.google.android.gms.common.security.ProviderInstallerImpl";
                        var8_10 = "reportRequestStats2";
                        var9_11 = var5_8.getClassLoader();
                        var10_12 = new zzj[3];
                        var11_13 = Context.class;
                        var10_12[0] = zzj.zzb(var11_13, var0);
                        var10_12[1] = zzi.zza(var2_1);
                        var10_12[2] = zzi.zza(var6_9);
                        zzl.zzb((String)var1_5 /* !! */ , var8_10, var9_11, var10_12);
                        var1_5 /* !! */  = var5_8;
                        ** GOTO lbl50
                    } else {
                        var1_5 /* !! */  = var5_8;
                    }
                }
                break block15;
                catch (Exception var1_7) {
                    var1_5 /* !! */  = var1_7.toString();
                    Log.w((String)"ProviderInstaller", (String)"Failed to report request stats: ".concat((String)var1_5 /* !! */ ));
                    var1_5 /* !! */  = var5_8;
                }
            }
            if (var1_5 /* !! */  != null) {
                ProviderInstaller.zzb(var1_5 /* !! */ , var0, "com.google.android.gms.common.security.ProviderInstallerImpl");
                return;
            }
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void installIfNeededAsync(@NonNull Context context, @NonNull ProviderInstallListener listener) {
        Context context2;
        void var1_1;
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(var1_1, "Listener must not be null");
        Preconditions.checkMainThread("Must be called on the UI thread");
        new zza(context2, (ProviderInstallListener)var1_1).execute(new Void[0]);
    }

    static /* bridge */ /* synthetic */ GoogleApiAvailabilityLight zza() {
        return zza;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="ProviderInstaller.lock")
    private static void zzb(Context context, Context object, String string2) throws GooglePlayServicesNotAvailableException {
        try {
            Method method = zzc;
            if (method == null) {
                void var2_9;
                Method method2;
                Class[] classArray = new Class[]{Context.class};
                String string3 = "insertProvider";
                zzc = method2 = context.getClassLoader().loadClass((String)var2_9).getMethod(string3, classArray);
            }
            zzc.invoke(null, context);
            return;
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                String string4 = throwable == null ? exception.toString() : throwable.toString();
                String string5 = "Failed to install provider: ";
                string4 = String.valueOf(string4);
                Log.e((String)"ProviderInstaller", (String)string5.concat(string4));
            }
            throw new GooglePlayServicesNotAvailableException(8);
        }
    }

    public static interface ProviderInstallListener {
        public void onProviderInstallFailed(int var1, @Nullable Intent var2);

        public void onProviderInstalled();
    }
}

