/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.wrappers.Wrappers;

@KeepForSdk
public final class UidVerifier {
    private UidVerifier() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public static boolean isGooglePlayServicesUid(@NonNull Context context, int uid) {
        Context context2;
        void var1_1;
        if (!UidVerifier.uidHasPackageName(context, (int)var1_1, "com.google.android.gms")) {
            return false;
        }
        PackageManager packageManager = context2.getPackageManager();
        try {
            packageManager = packageManager.getPackageInfo("com.google.android.gms", 64);
            return GoogleSignatureVerifier.getInstance(context2).isGooglePublicSignedPackage((PackageInfo)packageManager);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            if (!Log.isLoggable((String)"UidVerifier", (int)3)) return false;
            Log.d((String)"UidVerifier", (String)"Package manager can't find google play services package, defaulting to false");
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=19)
    @KeepForSdk
    public static boolean uidHasPackageName(@NonNull Context context, int uid, @NonNull String packageName) {
        void var2_2;
        void var1_1;
        return Wrappers.packageManager(context).zza((int)var1_1, (String)var2_2);
    }
}

