/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.SideEffectFree;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;

@KeepForSdk
public final class DeviceProperties {
    @Nullable
    private static Boolean zza;
    @Nullable
    private static Boolean zzb;
    @Nullable
    private static Boolean zzc;
    @Nullable
    private static Boolean zzd;
    @Nullable
    private static Boolean zze;
    @Nullable
    private static Boolean zzf;
    @Nullable
    private static Boolean zzg;
    @Nullable
    private static Boolean zzh;
    @Nullable
    private static Boolean zzi;
    @Nullable
    private static Boolean zzj;
    @Nullable
    private static Boolean zzk;
    @Nullable
    private static Boolean zzl;

    private DeviceProperties() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isAuto(@NonNull Context context) {
        Context context2 = context.getPackageManager();
        if (zzi == null) {
            boolean bl = PlatformVersion.isAtLeastO() ? context2.hasSystemFeature("android.hardware.type.automotive") : false;
            zzi = bl;
        }
        return zzi;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isBstar(@NonNull Context context) {
        if (zzl == null) {
            Context context2;
            boolean bl = PlatformVersion.isAtLeastR() ? context2.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE") : false;
            zzl = bl;
        }
        return zzl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isLatchsky(@NonNull Context context) {
        if (zzf == null) {
            Context context2;
            boolean bl = (context2 = context2.getPackageManager()).hasSystemFeature("com.google.android.feature.services_updater") ? context2.hasSystemFeature("cn.google.services") : false;
            zzf = bl;
        }
        return zzf;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isPhone(@NonNull Context context) {
        block7: {
            boolean bl;
            block6: {
                block8: {
                    block9: {
                        block10: {
                            block11: {
                                Context context2;
                                if (zza != null) break block7;
                                if (DeviceProperties.isTablet(context2)) break block8;
                                if (DeviceProperties.isWearable(context2)) break block9;
                                if (DeviceProperties.zzb(context2)) break block10;
                                if (zzh == null) {
                                    zzh = context2.getPackageManager().hasSystemFeature("org.chromium.arc");
                                }
                                if (zzh.booleanValue()) break block11;
                                if (!DeviceProperties.isAuto(context2)) {
                                    if (!DeviceProperties.isTv(context2)) {
                                        if (zzk == null) {
                                            zzk = context2.getPackageManager().hasSystemFeature("com.google.android.feature.AMATI_EXPERIENCE");
                                        }
                                        bl = !zzk.booleanValue() ? !DeviceProperties.isBstar(context2) : false;
                                        break block6;
                                    } else {
                                        bl = false;
                                    }
                                    break block6;
                                } else {
                                    bl = false;
                                }
                                break block6;
                            }
                            bl = false;
                            break block6;
                        }
                        bl = false;
                        break block6;
                    }
                    bl = false;
                    break block6;
                }
                bl = false;
            }
            zza = bl;
        }
        return zza;
    }

    @KeepForSdk
    public static boolean isSevenInchTablet(@NonNull Context context) {
        return DeviceProperties.zzc(context.getResources());
    }

    @TargetApi(value=21)
    @KeepForSdk
    public static boolean isSidewinder(@NonNull Context context) {
        return DeviceProperties.zza(context);
    }

    @KeepForSdk
    public static boolean isTablet(@NonNull Context context) {
        return DeviceProperties.isTablet(context.getResources());
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isTablet(@NonNull Resources resources) {
        if (resources == null) {
            return false;
        }
        if (zzb == null) {
            Resources resources2;
            boolean bl = (resources2.getConfiguration().screenLayout & 0xF) > 3 ? true : DeviceProperties.zzc(resources2);
            zzb = bl;
        }
        return zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isTv(@NonNull Context context) {
        Context context2 = context.getPackageManager();
        if (zzj == null) {
            boolean bl = !context2.hasSystemFeature("com.google.android.tv") ? (!context2.hasSystemFeature("android.hardware.type.television") ? context2.hasSystemFeature("android.software.leanback") : true) : true;
            zzj = bl;
        }
        return zzj;
    }

    @KeepForSdk
    public static boolean isUserBuild() {
        return "user".equals(Build.TYPE);
    }

    @TargetApi(value=20)
    @KeepForSdk
    @SideEffectFree
    public static boolean isWearable(@NonNull Context context) {
        return DeviceProperties.zzd(context.getPackageManager());
    }

    @TargetApi(value=26)
    @KeepForSdk
    public static boolean isWearableWithoutPlayStore(@NonNull Context context) {
        Context context2;
        return DeviceProperties.isWearable(context) && !PlatformVersion.isAtLeastN() || DeviceProperties.zza(context2) && (!PlatformVersion.isAtLeastO() || PlatformVersion.isAtLeastR());
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=21)
    public static boolean zza(@NonNull Context context) {
        if (zze == null) {
            boolean bl = PlatformVersion.isAtLeastLollipop() ? context.getPackageManager().hasSystemFeature("cn.google") : false;
            zze = bl;
        }
        return zze;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean zzb(@NonNull Context context) {
        if (zzg == null) {
            boolean bl = !context.getPackageManager().hasSystemFeature("android.hardware.type.iot") ? context.getPackageManager().hasSystemFeature("android.hardware.type.embedded") : true;
            zzg = bl;
        }
        return zzg;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean zzc(@NonNull Resources resources) {
        if (resources == null) {
            return false;
        }
        if (zzc == null) {
            resources = resources.getConfiguration();
            boolean bl = (resources.screenLayout & 0xF) <= 3 ? resources.smallestScreenWidthDp >= 600 : false;
            zzc = bl;
        }
        return zzc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=20)
    @SideEffectFree
    public static boolean zzd(@NonNull PackageManager packageManager) {
        if (zzd == null) {
            boolean bl = PlatformVersion.isAtLeastKitKatWatch() ? packageManager.hasSystemFeature("android.hardware.type.watch") : false;
            zzd = bl;
        }
        return zzd;
    }
}

