/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ConnectionTelemetryConfiguration;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.RootTelemetryConfigManager;
import com.google.android.gms.common.internal.RootTelemetryConfiguration;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    @KeepForSdk
    @NonNull
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    @KeepForSdk
    @NonNull
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    @KeepForSdk
    @NonNull
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES;
    private static final Feature[] zze;
    private int zzf;
    private long zzg;
    private long zzh;
    private int zzi;
    private long zzj;
    @Nullable
    private volatile String zzk;
    @VisibleForTesting
    zzv zza;
    private final Context zzl;
    private final Looper zzm;
    private final GmsClientSupervisor zzn;
    private final GoogleApiAvailabilityLight zzo;
    final Handler zzb;
    private final Object zzp;
    private final Object zzq;
    @GuardedBy(value="serviceBrokerLock")
    @Nullable
    private IGmsServiceBroker zzr;
    @VisibleForTesting
    @NonNull
    protected ConnectionProgressReportCallbacks zzc;
    @GuardedBy(value="lock")
    @Nullable
    private IInterface zzs;
    private final ArrayList zzt;
    @GuardedBy(value="lock")
    @Nullable
    private zze zzu;
    @GuardedBy(value="lock")
    private int zzv;
    @Nullable
    private final BaseConnectionCallbacks zzw;
    @Nullable
    private final BaseOnConnectionFailedListener zzx;
    private final int zzy;
    @Nullable
    private final String zzz;
    @Nullable
    private volatile String zzA;
    @Nullable
    private ConnectionResult zzB;
    private boolean zzC;
    @Nullable
    private volatile zzk zzD;
    @VisibleForTesting
    @NonNull
    protected AtomicInteger zzd;

    @KeepForSdk
    public int getGCoreServiceId() {
        return this.zzy;
    }

    @KeepForSdk
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @KeepForSdk
    @Nullable
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    @NonNull
    public final Context getContext() {
        return this.zzl;
    }

    @KeepForSdk
    @NonNull
    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    @KeepForSdk
    @Nullable
    public Bundle getConnectionHint() {
        return null;
    }

    @KeepForSdk
    @NonNull
    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = ((BaseGmsClient)((Object)this_)).zzq;
        synchronized (object) {
            IGmsServiceBroker this_ = ((BaseGmsClient)((Object)this_)).zzr;
            if (this_ != null) return this_.asBinder();
            return null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Nullable
    @KeepForSdk
    protected abstract T createServiceInterface(@NonNull IBinder var1);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public final T getService() throws DeadObjectException {
        Object object = this_.zzp;
        synchronized (object) {
            int n = this_.zzv;
            if (n == 5) {
                throw new DeadObjectException();
            }
            this_.checkConnected();
            BaseGmsClient this_ = this_.zzs;
            Preconditions.checkNotNull(this_, "Client is connected but service is null");
            return (T)this_;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @NonNull
    public final Looper getLooper() {
        return this.zzm;
    }

    @Nullable
    @KeepForSdk
    public ConnectionTelemetryConfiguration getTelemetryConfiguration() {
        zzk this_ = ((BaseGmsClient)((Object)this_)).zzD;
        if (this_ == null) {
            return null;
        }
        return this_.zzd;
    }

    @KeepForSdk
    @NonNull
    public String getEndpointPackageName() {
        if (!((BaseGmsClient)this).isConnected() || (this = ((BaseGmsClient)this).zza) == null) {
            throw new RuntimeException("Failed to connect when checking package");
        }
        return ((zzv)this).zza();
    }

    @KeepForSdk
    @Nullable
    public String getLastDisconnectMessage() {
        return this.zzk;
    }

    @Nullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    @NonNull
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @KeepForSdk
    @NonNull
    protected Set<Scope> getScopes() {
        return Collections.emptySet();
    }

    @KeepForSdk
    @Nullable
    protected Executor getBindServiceExecutor() {
        return null;
    }

    static {
        zze = new Feature[0];
        String string2 = "service_esmobile";
        GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{string2, "service_googleme"};
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Looper looper, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener, @Nullable String realClientName) {
        void var6_6;
        void var3_3;
        void var2_2;
        void var5_5;
        void var4_4;
        void var1_1;
        void v0 = var1_1;
        GmsClientSupervisor gmsClientSupervisor = GmsClientSupervisor.getInstance((Context)v0);
        GoogleApiAvailabilityLight googleApiAvailabilityLight = GoogleApiAvailabilityLight.getInstance();
        Preconditions.checkNotNull(var4_4);
        Preconditions.checkNotNull(var5_5);
        this((Context)v0, (Looper)var2_2, gmsClientSupervisor, googleApiAvailabilityLight, (int)var3_3, (BaseConnectionCallbacks)var4_4, (BaseOnConnectionFailedListener)var5_5, (String)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Handler handler, @NonNull GmsClientSupervisor supervisor, @NonNull GoogleApiAvailabilityLight apiAvailability, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zzk = null;
        this.zzp = new Object();
        this.zzq = new Object();
        this.zzt = new ArrayList();
        this.zzv = 1;
        this.zzB = null;
        this.zzC = false;
        this.zzD = null;
        this.zzd = new AtomicInteger(0);
        Preconditions.checkNotNull(var1_1, "Context must not be null");
        this.zzl = var1_1;
        Preconditions.checkNotNull(var2_2, "Handler must not be null");
        this.zzb = var2_2;
        this.zzm = var2_2.getLooper();
        Preconditions.checkNotNull(var3_3, "Supervisor must not be null");
        this.zzn = var3_3;
        Preconditions.checkNotNull(var4_4, "API availability must not be null");
        this.zzo = var4_4;
        this.zzy = var5_5;
        this.zzw = var6_6;
        this.zzx = var7_7;
        this.zzz = null;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@NonNull Context context, @NonNull Looper looper, @NonNull GmsClientSupervisor supervisor, @NonNull GoogleApiAvailabilityLight apiAvailability, int gCoreServiceId, @Nullable BaseConnectionCallbacks connectedListener, @Nullable BaseOnConnectionFailedListener connectionFailedListener, @Nullable String realClientName) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zzk = null;
        this.zzp = new Object();
        this.zzq = new Object();
        this.zzt = new ArrayList();
        this.zzv = 1;
        this.zzB = null;
        this.zzC = false;
        this.zzD = null;
        this.zzd = new AtomicInteger(0);
        Preconditions.checkNotNull(var1_1, "Context must not be null");
        this.zzl = var1_1;
        Preconditions.checkNotNull(var2_2, "Looper must not be null");
        this.zzm = var2_2;
        Preconditions.checkNotNull(var3_3, "Supervisor must not be null");
        this.zzn = var3_3;
        Preconditions.checkNotNull(var4_4, "API availability must not be null");
        this.zzo = var4_4;
        this.zzb = new zzb(this, (Looper)var2_2);
        this.zzy = var5_5;
        this.zzw = var6_6;
        this.zzx = var7_7;
        this.zzz = var8_8;
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzo.isGooglePlayServicesAvailable(this.zzl, this.getMinApkVersion());
        if (n != 0) {
            this.zzp(1, null);
            BaseGmsClient baseGmsClient = this;
            baseGmsClient.triggerNotAvailable(new LegacyClientCallbackAdapter(baseGmsClient), n, null);
            return;
        }
        BaseGmsClient baseGmsClient = this;
        baseGmsClient.connect(new LegacyClientCallbackAdapter(baseGmsClient));
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void connect(@NonNull ConnectionProgressReportCallbacks callbacks) {
        void var1_1;
        Preconditions.checkNotNull(callbacks, "Connection progress callbacks cannot be null.");
        this.zzc = var1_1;
        this.zzp(2, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void disconnect() {
        this.zzd.incrementAndGet();
        ArrayList arrayList = this.zzt;
        synchronized (arrayList) {
            int n = this.zzt.size();
            for (int i = 0; i < n; ++i) {
                ((zzc)this.zzt.get(i)).zzf();
            }
            this.zzt.clear();
        }
        Object object = this.zzq;
        synchronized (object) {
            this.zzr = null;
            // MONITOREXIT @DISABLED, blocks:[2, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var1_5
            this.zzp(1, null);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void disconnect(@NonNull String message) {
        void var1_1;
        this.zzk = var1_1;
        this.disconnect();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public void dump(@NonNull String prefix, @NonNull FileDescriptor object, @NonNull PrintWriter writer, @NonNull String[] stringArray) {
        long l;
        void var1_2;
        void var3_4;
        object = ((BaseGmsClient)this_).zzp;
        // MONITORENTER : object
        int n = ((BaseGmsClient)this_).zzv;
        IInterface iInterface = ((BaseGmsClient)this_).zzs;
        // MONITOREXIT : object
        object = ((BaseGmsClient)this_).zzq;
        // MONITORENTER : object
        IGmsServiceBroker iGmsServiceBroker = ((BaseGmsClient)this_).zzr;
        // MONITOREXIT : object
        var3_4.append((CharSequence)var1_2).append("mConnectState=");
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
        switch (n) {
            default: {
                var3_4.print("UNKNOWN");
                break;
            }
            case 5: {
                var3_4.print("DISCONNECTING");
                break;
            }
            case 4: {
                var3_4.print("CONNECTED");
                break;
            }
            case 3: {
                var3_4.print("LOCAL_CONNECTING");
                break;
            }
            case 2: {
                var3_4.print("REMOTE_CONNECTING");
                break;
            }
            case 1: {
                var3_4.print("DISCONNECTED");
            }
        }
        var3_4.append(" mService=");
        if (iInterface == null) {
            var3_4.append("null");
        } else {
            var3_4.append(((BaseGmsClient)this_).getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(iInterface.asBinder())));
        }
        var3_4.append(" mServiceBroker=");
        if (iGmsServiceBroker == null) {
            var3_4.println("null");
        } else {
            var3_4.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(iGmsServiceBroker.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (((BaseGmsClient)this_).zzh > 0L) {
            PrintWriter printWriter = var3_4.append((CharSequence)var1_2).append("lastConnectedTime=");
            l = ((BaseGmsClient)this_).zzh;
            String string2 = ((DateFormat)object).format(new Date(l));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(l);
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(" ");
            stringBuilder2.append(string2);
            printWriter.println(stringBuilder.toString());
        }
        if (((BaseGmsClient)this_).zzg > 0L) {
            var3_4.append((CharSequence)var1_2).append("lastSuspendedCause=");
            int n2 = ((BaseGmsClient)this_).zzf;
            switch (n2) {
                default: {
                    var3_4.append(String.valueOf(n2));
                    break;
                }
                case 3: {
                    var3_4.append("CAUSE_DEAD_OBJECT_EXCEPTION");
                    break;
                }
                case 2: {
                    var3_4.append("CAUSE_NETWORK_LOST");
                    break;
                }
                case 1: {
                    var3_4.append("CAUSE_SERVICE_DISCONNECTED");
                }
            }
            PrintWriter printWriter = var3_4.append(" lastSuspendedTime=");
            l = ((BaseGmsClient)this_).zzg;
            String string3 = ((DateFormat)object).format(new Date(l));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(l);
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.append(" ");
            stringBuilder3.append(string3);
            printWriter.println(stringBuilder.toString());
        }
        if (((BaseGmsClient)this_).zzj <= 0L) return;
        var3_4.append((CharSequence)var1_2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(((BaseGmsClient)this_).zzi));
        PrintWriter printWriter = var3_4.append(" lastFailedTime=");
        l = ((BaseGmsClient)this_).zzj;
        String string4 = ((DateFormat)object).format(new Date(l));
        Object this_ = new StringBuilder();
        ((StringBuilder)this_).append(l);
        Object object2 = this_;
        ((StringBuilder)object2).append(" ");
        ((StringBuilder)object2).append(string4);
        printWriter.println(((StringBuilder)this_).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(@Nullable IAccountAccessor authedAccountAccessor, @NonNull Set<Scope> scopes) {
        block15: {
            BaseGmsClient baseGmsClient;
            Object object;
            Object object2;
            GetServiceRequest getServiceRequest;
            Object object3 = this.zzA;
            GetServiceRequest getServiceRequest2 = getServiceRequest = new GetServiceRequest(6, this.zzy, GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE, null, null, GetServiceRequest.zza, new Bundle(), null, GetServiceRequest.zzb, GetServiceRequest.zzb, true, 0, false, (String)object3);
            getServiceRequest2.zzf = this.zzl.getPackageName();
            getServiceRequest2.zzi = this.getGetServiceRequestExtraArgs();
            if (object2 != null) {
                getServiceRequest.zzh = object2.toArray(new Scope[0]);
            }
            if (this.requiresSignIn()) {
                object2 = this.getAccount();
                if (object2 == null) {
                    object2 = new Account(DEFAULT_ACCOUNT, "com.google");
                }
                getServiceRequest.zzj = object2;
                if (object != null) {
                    getServiceRequest.zzg = object.asBinder();
                }
            } else if (this.requiresAccount()) {
                getServiceRequest.zzj = this.getAccount();
            }
            getServiceRequest.zzk = zze;
            getServiceRequest.zzl = this.getApiFeatures();
            if (this.usesClientTelemetry()) {
                getServiceRequest.zzo = true;
            }
            try {
                object = this.zzq;
                // MONITORENTER : object
                object2 = this.zzr;
                if (object2 == null) break block15;
                baseGmsClient = this;
            }
            catch (DeadObjectException deadObjectException) {
                Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
                this.triggerConnectionSuspended(3);
                return;
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (RemoteException | RuntimeException throwable) {
                Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
                this.onPostInitHandler(8, null, null, this.zzd.get());
                return;
            }
            object3 = new zzd(baseGmsClient, baseGmsClient.zzd.get());
            object2.getService((IGmsCallbacks)object3, getServiceRequest);
            // MONITOREXIT : object
            return;
        }
        Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
        return;
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@NonNull T t) {
        this.zzh = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(@NonNull ConnectionResult result) {
        void var1_1;
        this.zzi = var1_1.getErrorCode();
        this.zzj = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(int cause) {
        void var1_1;
        this.zzf = var1_1;
        this.zzg = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected void onPostInitHandler(int statusCode, @Nullable IBinder service, @Nullable Bundle resolution, int disconnectCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(1, (int)var4_4, -1, (Object)new zzf(this, (int)var1_1, (IBinder)var2_2, (Bundle)var3_3)));
    }

    @KeepForSdk
    public void onUserSignOut(@NonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setAttributionTag(@NonNull String attributionTag) {
        void var1_1;
        this.zzA = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void triggerConnectionSuspended(int cause) {
        void var1_1;
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(6, this.zzd.get(), (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@NonNull ConnectionProgressReportCallbacks callbacks, int errorCode, @Nullable PendingIntent resolution) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(callbacks, "Connection progress callbacks cannot be null.");
        this.zzc = var1_1;
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(3, this.zzd.get(), (int)var2_2, (Object)var3_3));
    }

    @KeepForSdk
    protected boolean enableLocalFallback() {
        return false;
    }

    @KeepForSdk
    protected boolean getUseDynamicLookup() {
        return this.getMinApkVersion() >= 211700000;
    }

    @KeepForSdk
    public boolean hasConnectionInfo() {
        return this.zzD != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isConnected() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl = this.zzv;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isConnecting() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl = this.zzv;
            if (bl) return true;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public boolean usesClientTelemetry() {
        return false;
    }

    @KeepForSdk
    @NonNull
    public Feature[] getApiFeatures() {
        return zze;
    }

    @Nullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        zzk this_ = ((BaseGmsClient)((Object)this_)).zzD;
        if (this_ == null) {
            return null;
        }
        return this_.zzb;
    }

    static /* bridge */ /* synthetic */ ConnectionResult zza(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzB;
    }

    static /* bridge */ /* synthetic */ BaseConnectionCallbacks zzb(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzw;
    }

    static /* bridge */ /* synthetic */ Object zzd(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzq;
    }

    @NonNull
    protected final String zze() {
        String string2 = this.zzz;
        if (string2 == null) {
            return this.zzl.getClass().getName();
        }
        return string2;
    }

    static /* bridge */ /* synthetic */ ArrayList zzf(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzt;
    }

    static /* bridge */ /* synthetic */ void zzg(BaseGmsClient baseGmsClient, ConnectionResult connectionResult) {
        baseGmsClient.zzB = connectionResult;
    }

    static /* bridge */ /* synthetic */ void zzh(BaseGmsClient baseGmsClient, IGmsServiceBroker iGmsServiceBroker) {
        baseGmsClient.zzr = iGmsServiceBroker;
    }

    static /* bridge */ /* synthetic */ void zzi(BaseGmsClient baseGmsClient, int n, IInterface iInterface) {
        baseGmsClient.zzp(n, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzj(BaseGmsClient object, zzk object2) {
        ((BaseGmsClient)object).zzD = object2;
        if (!((BaseGmsClient)object).usesClientTelemetry()) {
            return;
        }
        object = ((zzk)object2).zzd;
        object2 = RootTelemetryConfigManager.getInstance();
        object = object == null ? null : ((ConnectionTelemetryConfiguration)object).zza();
        ((RootTelemetryConfigManager)object2).zza((RootTelemetryConfiguration)object);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzk(BaseGmsClient baseGmsClient, int n) {
        int n2;
        block6: {
            Object object = baseGmsClient.zzp;
            synchronized (object) {
                int n3 = baseGmsClient.zzv;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl5 : MonitorExitStatement: MONITOREXIT : var1_3
                if (n3 == 3) {
                    baseGmsClient.zzC = true;
                    n2 = 5;
                    break block6;
                } else {
                    n2 = 4;
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        Handler handler = baseGmsClient.zzb;
        handler.sendMessage(handler.obtainMessage(n2, baseGmsClient.zzd.get(), 16));
    }

    protected final void zzl(int n, @Nullable Bundle bundle, int n2) {
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(7, n2, -1, (Object)new zzg(this, n, null)));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void zzp(int var1_2, @Nullable IInterface var2_11) {
        var3_12 = var1_2 == 4;
        {
            var4_14 = var2_11 != null;
            var3_12 = var3_12 == var4_14;
            Preconditions.checkArgument(var3_12);
            var3_13 = this.zzp;
            // MONITORENTER : var3_13
            ** try [egrp 0[TRYBLOCK] [0 : 33->638)] { 
lbl8:
            // 1 sources

            this.zzv = var1_2;
            this.zzs = var2_11;
            switch (var1_2) {
                case 4: {
                    Preconditions.checkNotNull(var2_11);
                    this.onConnectedLocked(var2_11);
                    ** break;
                }
                case 1: {
                    var1_3 = this.zzu;
                    if (var1_3 == null) return;
                    var2_11 = this.zzn;
                    var4_15 = this.zza.zzb();
                    Preconditions.checkNotNull(var4_15);
                    var5_18 = this.zza.zza();
                    var2_11.zzb(var4_15, var5_18, 4225, var1_3, this.zze(), this.zza.zzc());
                    this.zzu = null;
                }
lbl26:
                // 3 sources

                default: {
                    return;
                }
                case 2: 
                case 3: 
            }
            var1_4 = this.zzu;
            if (var1_4 != null && (var2_11 = this.zza) != null) {
                var4_16 = "GmsClient";
                var5_19 = var2_11.zzb();
                v0 = var2_11.zza();
                v1 = new StringBuilder();
                v1.append("Calling connect() while still connected, missing disconnect() for ");
                v1.append(var5_19);
                v1.append(" on ");
                v1.append(v0);
                Log.e((String)var4_16, (String)v1.toString());
                var2_11 = this.zzn;
                var4_16 = this.zza.zzb();
                Preconditions.checkNotNull(var4_16);
                var5_19 = this.zza.zza();
                var2_11.zzb(var4_16, var5_19, 4225, var1_4, this.zze(), this.zza.zzc());
                this.zzd.incrementAndGet();
            }
            v2 = this;
            this.zzu = var2_11 = new zze(v2, v2.zzd.get());
            var1_5 = this.zzv;
            if (var1_5 == 3 && (var1_6 = this.getLocalStartServiceAction()) != null) {
                var4_17 = this.getContext().getPackageName();
                var5_19 = this.getLocalStartServiceAction();
                var1_6 = new zzv(var4_17, var5_19, true, 4225, false);
            } else {
                var4_17 = this.getStartServicePackage();
                var5_19 = this.getStartServiceAction();
                var1_6 = new zzv(var4_17, var5_19, false, 4225, this.getUseDynamicLookup());
            }
            this.zza = var1_6;
            var1_7 = this.zza.zzc();
            if (var1_7 != 0 && (var1_7 = this.getMinApkVersion()) < 17895000) {
                this = this.zza.zzb();
                throw new IllegalStateException("Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: ".concat(String.valueOf(this)));
            }
            var1_8 = this.zzn;
            var4_17 = this.zza.zzb();
            Preconditions.checkNotNull(var4_17);
            var5_19 = this.zza.zza();
            var6_20 = this.zze();
            var7_21 = this.zza.zzc();
            var9_23 = new zzo(var4_17, var5_19, 4225, var7_21);
            var1_9 = var1_8.zzc(var9_23, (ServiceConnection)var2_11, var6_20, var8_22 = this.getBindServiceExecutor());
            if (!var1_9) {
                var1_10 = this.zza.zzb();
                v3 = this.zza.zza();
                v4 = new StringBuilder();
                v4.append("unable to connect to service: ");
                v4.append(var1_10);
                v4.append(" on ");
                v4.append(v3);
                Log.w((String)"GmsClient", (String)v4.toString());
                v5 = this;
                v5.zzl(16, null, v5.zzd.get());
                return;
            }
            // MONITOREXIT : var3_13
            return;
        }
lbl97:
        // 1 sources

        catch (Throwable var0_1) {}
        // MONITOREXIT : var3_13
        throw var0_1;
    }

    static /* bridge */ /* synthetic */ boolean zzm(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzC;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ boolean zzn(BaseGmsClient baseGmsClient, int n, int n2, IInterface iInterface) {
        Object object = baseGmsClient.zzp;
        synchronized (object) {
            int n3 = baseGmsClient.zzv;
            if (n3 != n) {
                return false;
            }
            baseGmsClient.zzp(n2, iInterface);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ boolean zzo(BaseGmsClient baseGmsClient) {
        if (baseGmsClient.zzC) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)baseGmsClient.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)baseGmsClient.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(baseGmsClient.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        @KeepForSdk
        public static final int CAUSE_DEAD_OBJECT_EXCEPTION = 3;

        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(int var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        @KeepForSdk
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        final /* synthetic */ BaseGmsClient zza;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public LegacyClientCallbackAdapter(BaseGmsClient this$0) {
            void var1_1;
            this.zza = var1_1;
        }

        @Override
        public final void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient baseGmsClient = this.zza;
                baseGmsClient.getRemoteService(null, baseGmsClient.getScopes());
                return;
            }
            if (this.zza.zzx != null) {
                this.zza.zzx.onConnectionFailed(connectionResult);
                return;
            }
        }
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }
}

