/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzb;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;

@SafeParcelable.Class(creator="StatusCreator")
public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_SUCCESS_CACHE = new Status(-1);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_SUCCESS = new Status(0);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_INTERRUPTED = new Status(14);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_INTERNAL_ERROR = new Status(8);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_TIMEOUT = new Status(15);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_CANCELED = new Status(16);
    @KeepForSdk
    @NonNull
    public static final Status RESULT_DEAD_CLIENT;
    @NonNull
    public static final Parcelable.Creator<Status> CREATOR;
    @ShowFirstParty
    @NonNull
    public static final Status zza;
    @SafeParcelable.VersionField(id=1000)
    final int zzb;
    @SafeParcelable.Field(id=1, getter="getStatusCode")
    private final int zzc;
    @SafeParcelable.Field(id=2, getter="getStatusMessage")
    @Nullable
    private final String zzd;
    @SafeParcelable.Field(id=3, getter="getPendingIntent")
    @Nullable
    private final PendingIntent zze;
    @SafeParcelable.Field(id=4, getter="getConnectionResult")
    @Nullable
    private final ConnectionResult zzf;

    @ResultIgnorabilityUnspecified
    public int getStatusCode() {
        return this.zzc;
    }

    public int hashCode() {
        return Objects.hashCode(this.zzb, this.zzc, this.zzd, this.zze, this.zzf);
    }

    @Nullable
    public PendingIntent getResolution() {
        return this.zze;
    }

    @Nullable
    public ConnectionResult getConnectionResult() {
        return this.zzf;
    }

    @Override
    @CanIgnoreReturnValue
    @NonNull
    public Status getStatus() {
        return this;
    }

    @Nullable
    public String getStatusMessage() {
        return this.zzd;
    }

    @NonNull
    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(this);
        toStringHelper.add("statusCode", this.zza());
        toStringHelper.add("resolution", this.zze);
        return toStringHelper.toString();
    }

    static {
        zza = new Status(17);
        RESULT_DEAD_CLIENT = new Status(18);
        CREATOR = new zzb();
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode) {
        this((int)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode, @Nullable String statusMessage) {
        this(1, (int)var1_1, (String)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(@NonNull ConnectionResult connectionResult, @NonNull String statusMessage) {
        this((ConnectionResult)var1_1, (String)var2_2, 17);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode, @Nullable String statusMessage, @Nullable PendingIntent pendingIntent) {
        this(1, (int)var1_1, (String)var2_2, (PendingIntent)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public Status(@NonNull ConnectionResult connectionResult, @NonNull String statusMessage, int statusCode) {
        this(1, (int)var3_3, (String)var2_2, var1_1.getResolution(), (ConnectionResult)var1_1);
        void var1_1;
        void var2_2;
        void var3_3;
    }

    @SafeParcelable.Constructor
    Status(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable PendingIntent pendingIntent, @SafeParcelable.Param(id=4) @Nullable ConnectionResult connectionResult) {
        this.zzb = n;
        this.zzc = n2;
        this.zzd = string2;
        this.zze = pendingIntent;
        this.zzf = connectionResult;
    }

    /*
     * WARNING - void declaration
     */
    public void startResolutionForResult(@NonNull Activity activity, int requestCode) throws IntentSender.SendIntentException {
        void var2_2;
        void var1_1;
        if (!this.hasResolution()) {
            return;
        }
        PendingIntent pendingIntent = this.zze;
        Preconditions.checkNotNull(pendingIntent);
        var1_1.startIntentSenderForResult(pendingIntent.getIntentSender(), (int)var2_2, null, 0, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader(out);
        SafeParcelWriter.writeInt((Parcel)var1_1, 1, this.getStatusCode());
        SafeParcelWriter.writeString((Parcel)var1_1, 2, this.getStatusMessage(), false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, 3, (Parcelable)this.zze, (int)var2_2, false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, 4, this.getConnectionResult(), (int)var2_2, false);
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, 1000, this.zzb);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, n);
    }

    public boolean equals(@Nullable Object obj) {
        Status status;
        if (!(obj instanceof Status)) {
            return false;
        }
        status = status;
        return this.zzb == status.zzb && this.zzc == status.zzc && Objects.equal(this.zzd, status.zzd) && Objects.equal(this.zze, status.zze) && Objects.equal(this.zzf, status.zzf);
    }

    @VisibleForTesting
    public boolean hasResolution() {
        return this.zze != null;
    }

    public boolean isCanceled() {
        return this.zzc == 16;
    }

    public boolean isInterrupted() {
        return this.zzc == 14;
    }

    @CheckReturnValue
    public boolean isSuccess() {
        return this.zzc <= 0;
    }

    @NonNull
    public final String zza() {
        String string2 = this.zzd;
        if (string2 != null) {
            return string2;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzc);
    }
}

