/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="ScopeCreator")
public final class Scope
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<Scope> CREATOR = new zza();
    @SafeParcelable.VersionField(id=1)
    final int zza;
    @SafeParcelable.Field(id=2, getter="getScopeUri")
    private final String zzb;

    public int hashCode() {
        return this.zzb.hashCode();
    }

    @KeepForSdk
    @NonNull
    public String getScopeUri() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    public Scope(@NonNull String scopeUri) {
        this(1, (String)var1_1);
        void var1_1;
    }

    @SafeParcelable.Constructor
    Scope(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string2) {
        Preconditions.checkNotEmpty(string2, "scopeUri must not be null or empty");
        this.zza = n;
        this.zzb = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader(dest);
        SafeParcelWriter.writeInt((Parcel)var1_1, 1, this.zza);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, 2, this.getScopeUri(), false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, n2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object o) {
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof Scope)) {
            return false;
        }
        return this.zzb.equals(((Scope)var1_1).zzb);
    }
}

