/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzf;
import com.google.android.gms.common.zzg;
import com.google.android.gms.common.zzh;
import com.google.android.gms.common.zzi;
import com.google.android.gms.common.zzj;
import com.google.android.gms.common.zzl;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzs;
import com.google.android.gms.common.zzv;
import com.google.android.gms.common.zzx;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.errorprone.annotations.CheckReturnValue;
import java.security.MessageDigest;

@CheckReturnValue
final class zzn {
    static final zzl zza;
    static final zzl zzb;
    static final zzl zzc;
    static final zzl zzd;
    private static volatile zzaf zze;
    private static final Object zzf;
    private static Context zzg;

    static zzx zza(String object, zzj zzj2, boolean bl, boolean bl2) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            object = zzn.zzh((String)object, zzj2, bl, bl2);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
        return object;
    }

    static zzx zzb(String string2, boolean bl, boolean bl2, boolean bl3) {
        return zzn.zzi(string2, bl, false, false, true);
    }

    private static zzx zzh(String object, zzj zzj2, boolean bl, boolean bl2) {
        block4: {
            try {
                zzn.zzj();
            }
            catch (DynamiteModule.LoadingException loadingException) {
                Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)loadingException);
                return zzx.zzd("module init: ".concat(String.valueOf(loadingException.getMessage())), loadingException);
            }
            Preconditions.checkNotNull(zzg);
            zzs zzs2 = new zzs((String)object, zzj2, bl, bl2);
            try {
                zzaf zzaf2 = zze;
                PackageManager packageManager = zzg.getPackageManager();
                boolean bl3 = zzaf2.zzh(zzs2, ObjectWrapper.wrap(packageManager));
                if (!bl3) break block4;
            }
            catch (RemoteException remoteException) {
                Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)remoteException);
                return zzx.zzd("module call", remoteException);
            }
            return zzx.zzb();
        }
        zze zze2 = new zze(bl, (String)object, zzj2);
        object = new zzv(zze2, null);
        return object;
    }

    static zzx zzc(String string2, boolean bl, boolean bl2, boolean bl3) {
        return zzn.zzi(string2, bl, false, false, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static zzx zzi(String var0, boolean var1_7, boolean var2_11, boolean var3_13, boolean var4_15) {
        block14: {
            var3_14 = StrictMode.allowThreadDiskReads();
            Preconditions.checkNotNull(zzn.zzg);
            try {
                zzn.zzj();
                var2_12 = new zzo((String)var0, (boolean)var1_7, false, (IBinder)ObjectWrapper.wrap(zzn.zzg), false);
                if (var4_15) {
                    break block14;
                }
                ** GOTO lbl-1000
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var3_14);
            }
        }
        ** try [egrp 2[TRYBLOCK] [4 : 37->47)] { 
lbl-1000:
        // 1 sources

        {
            catch (RemoteException var0_6) {
                Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)var0_6);
                var1_10 = "module call";
                var0_2 = zzx.zzd(var1_10, var0_6);
                return var0_2;
            }
        }
lbl-1000:
        // 1 sources

        {
            var0 = zzn.zze.zze((zzo)var2_12);
lbl24:
            // 2 sources

            while (true) {
                var1_7 = var0.zzb();
                if (var1_7 != 0) {
                    var0_1 = var0.zzc();
                    var0_2 = zzx.zzf(var0_1);
                    return var0_2;
                }
                var2_12 = var0.zza();
                var1_7 = var0.zzd();
                var1_8 = var1_7 == 4 ? new PackageManager.NameNotFoundException() : null;
                var4_16 = "error checking package certificate";
                if (var2_12 == null) {
                    var2_12 = var4_16;
                }
                var4_17 = var0.zzc();
                var0_3 = var0.zzd();
                var0_2 = zzx.zzg(var4_17, var0_3, (String)var2_12, var1_8);
                return var0_2;
            }
lbl-1000:
            // 1 sources

            {
                var0 = zzn.zze.zzf((zzo)var2_12);
                ** continue;
            }
            catch (DynamiteModule.LoadingException var0_5) {
                Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)var0_5);
                var1_9 = "module init: ".concat(String.valueOf(var0_5.getMessage()));
                var0_2 = zzx.zzd(var1_9, var0_5);
                return var0_2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ String zzd(boolean bl, String object, zzj zzj2) throws Exception {
        boolean bl2 = !bl ? zzn.zzh((String)object, (zzj)zzj2, (boolean)true, (boolean)false).zza : false;
        String string2 = true != bl2 ? "not allowed" : "debug cert rejected";
        Object[] objectArray = new Object[5];
        objectArray[0] = string2;
        objectArray[1] = object;
        object = AndroidUtilsLight.zza("SHA-256");
        Preconditions.checkNotNull(object);
        objectArray[2] = Hex.bytesToStringLowercase(((MessageDigest)object).digest(zzj2.zzf()));
        objectArray[3] = bl;
        objectArray[4] = "12451000.false";
        return String.format("%s: pkg=%s, sha256=%s, atk=%s, ver=%s", objectArray);
    }

    static {
        Object object = new zzf(zzj.zze("0\u0082\u0005\u00c80\u0082\u0003\u00b0\u00a0\u0003\u0002\u0001\u0002\u0002\u0014\u0010\u008ae\bs\u00f9/\u008eQ\u00ed"));
        zza = object;
        object = new zzg(zzj.zze("0\u0082\u0006\u00040\u0082\u0003\u00ec\u00a0\u0003\u0002\u0001\u0002\u0002\u0014\u0003\u00a3\u00b2\u00ad\u00d7\u00e1r\u00cak\u00ec"));
        zzb = object;
        object = new zzh(zzj.zze("0\u0082\u0004C0\u0082\u0003+\u00a0\u0003\u0002\u0001\u0002\u0002\t\u0000\u00c2\u00e0\u0087FdJ0\u008d0"));
        zzc = object;
        object = new zzi(zzj.zze("0\u0082\u0004\u00a80\u0082\u0003\u0090\u00a0\u0003\u0002\u0001\u0002\u0002\t\u0000\u00d5\u0085\u00b8l}\u00d3N\u00f50"));
        zzd = object;
        zzf = object = new Object();
    }

    static synchronized void zze(Context context) {
        if (zzg == null) {
            if (context != null) {
                zzg = context.getApplicationContext();
                return;
            }
            return;
        }
        Log.w((String)"GoogleCertificates", (String)"GoogleCertificates has been initialized already");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void zzj() throws DynamiteModule.LoadingException {
        if (zze != null) {
            return;
        }
        Preconditions.checkNotNull(zzg);
        Object object = zzf;
        synchronized (object) {
            zzaf zzaf2 = zze;
            if (zzaf2 != null) return;
            zzaf2 = DynamiteModule.load(zzg, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "com.google.android.gms.googlecertificates").instantiate("com.google.android.gms.common.GoogleCertificatesImpl");
            zze = zzae.zzb((IBinder)zzaf2);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static boolean zzf() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            zzn.zzj();
            boolean bl = zze.zzg();
            return bl;
        }
        catch (RemoteException | DynamiteModule.LoadingException throwable) {
            Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)throwable);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
        return false;
    }

    static boolean zzg() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            zzn.zzj();
            boolean bl = zze.zzi();
            return bl;
        }
        catch (RemoteException | DynamiteModule.LoadingException throwable) {
            Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)throwable);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
        return false;
    }
}

