/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.util.VisibleForTesting;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@VisibleForTesting
@KeepForSdk
public final class ArrayUtils {
    @KeepForSdk
    @NonNull
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    @KeepForSdk
    @NonNull
    public static <T> ArrayList<T> toArrayList(@NonNull T[] src) {
        int n = src.length;
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            T[] TArray;
            arrayList.add(TArray[i]);
        }
        return arrayList;
    }

    private ArrayUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void writeArray(@NonNull StringBuilder sb, @NonNull double[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            StringBuilder stringBuilder;
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Double.toString((double)var1_1[i]));
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void writeArray(@NonNull StringBuilder sb, @NonNull float[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            StringBuilder stringBuilder;
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Float.toString((float)var1_1[i]));
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void writeArray(@NonNull StringBuilder sb, @NonNull int[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            StringBuilder stringBuilder;
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString((int)var1_1[i]));
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void writeArray(@NonNull StringBuilder sb, @NonNull long[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            StringBuilder stringBuilder;
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Long.toString((long)var1_1[i]));
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static <T> void writeArray(@NonNull StringBuilder sb, @NonNull T[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            StringBuilder stringBuilder;
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(var1_1[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void writeArray(@NonNull StringBuilder sb, @NonNull boolean[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            StringBuilder stringBuilder;
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Boolean.toString((boolean)var1_1[i]));
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void writeStringArray(@NonNull StringBuilder sb, @NonNull String[] value) {
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            StringBuilder stringBuilder;
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"");
            stringBuilder.append((String)var1_1[i]);
            stringBuilder.append("\"");
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static boolean contains(@NonNull int[] array, int value) {
        int[] nArray;
        if (array == null) {
            return false;
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            if (nArray[i] != var1_1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static <T> boolean contains(@NonNull T[] array, @NonNull T searchValue) {
        T[] TArray;
        if (array == null) return false;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            void var1_1;
            if (Objects.equal(TArray[n2], var1_1)) {
                if (n2 < 0) return false;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @KeepForSdk
    @NonNull
    public static byte[] concatByteArrays(byte[] ... arrays) {
        if (arrays.length != 0) {
            byte[][] byArray;
            int n;
            int n2 = 0;
            for (n = 0; n < byArray.length; ++n) {
                n2 += byArray[n].length;
            }
            byte[] byArray2 = Arrays.copyOf(byArray[0], n2);
            n2 = byArray[0].length;
            for (n = 1; n < byArray.length; ++n) {
                byte[] byArray3 = byArray[n];
                int n3 = byArray3.length;
                System.arraycopy(byArray3, 0, byArray2, n2, n3);
                n2 += n3;
            }
            return byArray2;
        }
        return new byte[0];
    }

    @KeepForSdk
    @NonNull
    public static int[] toPrimitiveArray(@NonNull Collection<Integer> integerCollection) {
        Collection<Integer> collection;
        if (integerCollection == null || collection.size() == 0) {
            return new int[0];
        }
        int[] nArray = new int[collection.size()];
        Iterator<Integer> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = n + 1;
            nArray[n] = iterator.next();
            n = n2;
        }
        return nArray;
    }

    @KeepForSdk
    @Nullable
    public static Integer[] toWrapperArray(@NonNull int[] array) {
        int[] nArray;
        if (array == null) {
            return null;
        }
        int n = nArray.length;
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    @KeepForSdk
    @NonNull
    public static <T> T[] concat(T[] ... arrays) {
        T[][] TArray;
        if (arrays.length != 0) {
            int n;
            int n2 = 0;
            for (n = 0; n < TArray.length; ++n) {
                n2 += TArray[n].length;
            }
            T[] TArray2 = Arrays.copyOf(TArray[0], n2);
            n2 = TArray[0].length;
            for (n = 1; n < TArray.length; ++n) {
                T[] TArray3 = TArray[n];
                int n3 = TArray3.length;
                System.arraycopy(TArray3, 0, TArray2, n2, n3);
                n2 += n3;
            }
            return TArray2;
        }
        return (Object[])Array.newInstance(TArray.getClass(), 0);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @Nullable
    public static <T> T[] removeAll(@NonNull T[] array, T ... toBeRemoved) {
        int n;
        T[] TArray;
        void var1_3;
        if (array == null) {
            return null;
        }
        if (var1_3 == null) return Arrays.copyOf(TArray, TArray.length);
        int n2 = ((void)var1_3).length;
        if (n2 == 0) {
            return Arrays.copyOf(TArray, TArray.length);
        }
        Class<?> clazz = var1_3.getClass().getComponentType();
        int n3 = TArray.length;
        Object[] objectArray = (Object[])Array.newInstance(clazz, n3);
        if (n2 == 1) {
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                T t = TArray[i];
                if (Objects.equal(var1_3[0], t)) continue;
                int n4 = n2 + 1;
                objectArray[n2] = t;
                n2 = n4;
            }
            n = n2;
        } else {
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                T t = TArray[i];
                if (ArrayUtils.contains(var1_3, t)) continue;
                int n5 = n2 + 1;
                objectArray[n2] = t;
                n2 = n5;
            }
            n = n2;
        }
        if (objectArray == null) {
            return null;
        }
        if (n != objectArray.length) return Arrays.copyOf(objectArray, n);
        return objectArray;
    }
}

