/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzb;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;

@SafeParcelable.Class(creator="StatusCreator")
public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    @VisibleForTesting
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_SUCCESS;
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_INTERRUPTED;
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_INTERNAL_ERROR;
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_TIMEOUT;
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_CANCELED;
    @KeepForSdk
    @NonNull
    public static final Status RESULT_DEAD_CLIENT;
    @NonNull
    public static final Parcelable.Creator<Status> CREATOR;
    @VisibleForTesting
    @ShowFirstParty
    @NonNull
    public static final Status zza;
    @ShowFirstParty
    @NonNull
    public static final Status zzb;
    @SafeParcelable.VersionField(id=1000)
    final int zzc;
    @SafeParcelable.Field(id=1, getter="getStatusCode")
    private final int zzd;
    @SafeParcelable.Field(id=2, getter="getStatusMessage")
    @Nullable
    private final String zze;
    @SafeParcelable.Field(id=3, getter="getPendingIntent")
    @Nullable
    private final PendingIntent zzf;
    @SafeParcelable.Field(id=4, getter="getConnectionResult")
    @Nullable
    private final ConnectionResult zzg;

    public int getStatusCode() {
        return this.zzd;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzc, this.zzd, this.zze, this.zzf, this.zzg};
        return Objects.hashCode(objectArray);
    }

    @Nullable
    public PendingIntent getResolution() {
        return this.zzf;
    }

    @Nullable
    public ConnectionResult getConnectionResult() {
        return this.zzg;
    }

    @Override
    @NonNull
    public Status getStatus() {
        return this;
    }

    @Nullable
    public String getStatusMessage() {
        return this.zze;
    }

    @NonNull
    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(this);
        toStringHelper.add("statusCode", this.zza());
        toStringHelper.add("resolution", this.zzf);
        return toStringHelper.toString();
    }

    static {
        Object object = new Status(-1);
        zza = object;
        object = new Status(0);
        RESULT_SUCCESS = object;
        object = new Status(14);
        RESULT_INTERRUPTED = object;
        object = new Status(8);
        RESULT_INTERNAL_ERROR = object;
        object = new Status(15);
        RESULT_TIMEOUT = object;
        object = new Status(16);
        RESULT_CANCELED = object;
        object = new Status(17);
        zzb = object;
        object = new Status(18);
        RESULT_DEAD_CLIENT = object;
        object = new zzb();
        CREATOR = object;
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode) {
        this((int)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode, @Nullable String statusMessage) {
        this(1, (int)var1_1, (String)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(@NonNull ConnectionResult connectionResult, @NonNull String statusMessage) {
        this((ConnectionResult)var1_1, (String)var2_2, 17);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode, @Nullable String statusMessage, @Nullable PendingIntent pendingIntent) {
        this(1, (int)var1_1, (String)var2_2, (PendingIntent)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public Status(@NonNull ConnectionResult connectionResult, @NonNull String statusMessage, int statusCode) {
        this(1, (int)var3_3, (String)var2_2, var1_1.getResolution(), (ConnectionResult)var1_1);
        void var1_1;
        void var2_2;
        void var3_3;
    }

    @SafeParcelable.Constructor
    Status(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable PendingIntent pendingIntent, @SafeParcelable.Param(id=4) @Nullable ConnectionResult connectionResult) {
        this.zzc = n;
        this.zzd = n2;
        this.zze = string2;
        this.zzf = pendingIntent;
        this.zzg = connectionResult;
    }

    /*
     * WARNING - void declaration
     */
    public void startResolutionForResult(@NonNull Activity activity, int requestCode) throws IntentSender.SendIntentException {
        void var2_2;
        void var1_1;
        if (!this_.hasResolution()) {
            return;
        }
        Status this_ = this_.zzf;
        Preconditions.checkNotNull(this_);
        var1_1.startIntentSenderForResult(this_.getIntentSender(), (int)var2_2, null, 0, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader(out);
        SafeParcelWriter.writeInt((Parcel)var1_1, 1, this.getStatusCode());
        SafeParcelWriter.writeString((Parcel)var1_1, 2, this.getStatusMessage(), false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, 3, (Parcelable)this.zzf, (int)var2_2, false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, 4, this.getConnectionResult(), (int)var2_2, false);
        SafeParcelWriter.writeInt((Parcel)var1_1, 1000, this.zzc);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, n);
    }

    public boolean equals(@Nullable Object obj) {
        Status status;
        if (!(obj instanceof Status)) {
            return false;
        }
        status = status;
        return this.zzc == status.zzc && this.zzd == status.zzd && Objects.equal(this.zze, status.zze) && Objects.equal(this.zzf, status.zzf) && Objects.equal(this.zzg, status.zzg);
    }

    @VisibleForTesting
    public boolean hasResolution() {
        return this.zzf != null;
    }

    public boolean isCanceled() {
        return this.zzd == 16;
    }

    public boolean isInterrupted() {
        return this.zzd == 14;
    }

    public boolean isSuccess() {
        return this.zzd <= 0;
    }

    @NonNull
    public final String zza() {
        String string2 = this.zze;
        if (string2 != null) {
            return string2;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzd);
    }
}

