/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.content.Context;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public abstract class RemoteCreator<T> {
    private final String zza;
    private T zzb;

    @KeepForSdk
    @NonNull
    protected abstract T getRemoteCreator(@NonNull IBinder var1);

    @KeepForSdk
    @NonNull
    protected final T getRemoteCreatorInstance(@NonNull Context context) throws RemoteCreatorException {
        if (((RemoteCreator)this_).zzb == null) {
            Object object;
            Preconditions.checkNotNull(object);
            object = GooglePlayServicesUtilLight.getRemoteContext(object);
            if (object == null) {
                Object this_ = new RemoteCreatorException("Could not get remote context.");
                throw this_;
            }
            object = object.getClassLoader();
            try {
                ((RemoteCreator)this_).zzb = ((RemoteCreator)this_).getRemoteCreator((IBinder)object.loadClass(((RemoteCreator)this_).zza).newInstance());
            }
            catch (IllegalAccessException illegalAccessException) {
                object = new RemoteCreatorException("Could not access creator.", illegalAccessException);
                throw object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = new RemoteCreatorException("Could not load creator class.", classNotFoundException);
                throw object;
            }
            catch (InstantiationException instantiationException) {
                object = new RemoteCreatorException("Could not instantiate creator.", instantiationException);
                throw object;
            }
        }
        return ((RemoteCreator)this_).zzb;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected RemoteCreator(@NonNull String creatorClassName) {
        void var1_1;
        this.zza = var1_1;
    }

    @KeepForSdk
    public static class RemoteCreatorException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public RemoteCreatorException(@NonNull String message) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public RemoteCreatorException(@NonNull String message, @NonNull Throwable cause) {
            super((String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

