/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.content.Context;
import android.os.IBinder;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public abstract class RemoteCreator<T> {
    private final String zza;
    private T zzb;

    @KeepForSdk
    protected RemoteCreator(@RecentlyNonNull String string2) {
        this.zza = string2;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected final T getRemoteCreatorInstance(@RecentlyNonNull Context object) throws RemoteCreatorException {
        if (((RemoteCreator)object2).zzb == null) {
            Preconditions.checkNotNull(object);
            object = GooglePlayServicesUtilLight.getRemoteContext(object);
            if (object == null) {
                Object object2 = new RemoteCreatorException("Could not get remote context.");
                throw object2;
            }
            object = object.getClassLoader();
            try {
                ((RemoteCreator)object2).zzb = ((RemoteCreator)object2).getRemoteCreator((IBinder)object.loadClass(((RemoteCreator)object2).zza).newInstance());
            }
            catch (IllegalAccessException illegalAccessException) {
                object = new RemoteCreatorException("Could not access creator.", illegalAccessException);
                throw object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = new RemoteCreatorException("Could not load creator class.", classNotFoundException);
                throw object;
            }
            catch (InstantiationException instantiationException) {
                object = new RemoteCreatorException("Could not instantiate creator.", instantiationException);
                throw object;
            }
        }
        return ((RemoteCreator)object2).zzb;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected abstract T getRemoteCreator(@RecentlyNonNull IBinder var1);

    @KeepForSdk
    public static class RemoteCreatorException
    extends Exception {
        @KeepForSdk
        public RemoteCreatorException(@RecentlyNonNull String string2) {
            super(string2);
        }

        @KeepForSdk
        public RemoteCreatorException(@RecentlyNonNull String string2, @RecentlyNonNull Throwable throwable) {
            super(string2, throwable);
        }
    }
}

