/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.wrappers;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.Process;
import androidx.annotation.RecentlyNonNull;
import androidx.core.util.Pair;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.InstantApps;

@KeepForSdk
public class PackageManagerWrapper {
    @RecentlyNonNull
    protected final Context zza;

    public PackageManagerWrapper(@RecentlyNonNull Context context) {
        this.zza = context;
    }

    @KeepForSdk
    @RecentlyNonNull
    public ApplicationInfo getApplicationInfo(@RecentlyNonNull String string2, int n) throws PackageManager.NameNotFoundException {
        return this.zza.getPackageManager().getApplicationInfo(string2, n);
    }

    @KeepForSdk
    @RecentlyNonNull
    public PackageInfo getPackageInfo(@RecentlyNonNull String string2, int n) throws PackageManager.NameNotFoundException {
        return this.zza.getPackageManager().getPackageInfo(string2, n);
    }

    @KeepForSdk
    public int checkCallingOrSelfPermission(@RecentlyNonNull String string2) {
        return this.zza.checkCallingOrSelfPermission(string2);
    }

    @KeepForSdk
    public int checkPermission(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        return this.zza.getPackageManager().checkPermission(string2, string3);
    }

    @KeepForSdk
    @RecentlyNonNull
    public CharSequence getApplicationLabel(@RecentlyNonNull String string2) throws PackageManager.NameNotFoundException {
        return this.zza.getPackageManager().getApplicationLabel(this.zza.getPackageManager().getApplicationInfo(string2, 0));
    }

    @KeepForSdk
    @RecentlyNonNull
    public Pair<CharSequence, Drawable> getApplicationLabelAndIcon(@RecentlyNonNull String string2) throws PackageManager.NameNotFoundException {
        string2 = this.zza.getPackageManager().getApplicationInfo(string2, 0);
        return Pair.create((Object)this.zza.getPackageManager().getApplicationLabel((ApplicationInfo)string2), (Object)this.zza.getPackageManager().getApplicationIcon((ApplicationInfo)string2));
    }

    @KeepForSdk
    public boolean isCallerInstantApp() {
        String string2;
        if (Binder.getCallingUid() == Process.myUid()) {
            return InstantApps.isInstantApp(this.zza);
        }
        if (PlatformVersion.isAtLeastO() && (string2 = this.zza.getPackageManager().getNameForUid(Binder.getCallingUid())) != null) {
            return this.zza.getPackageManager().isInstantApp(string2);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=19)
    public final boolean zza(int n, @RecentlyNonNull String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            try {
                Object object = (AppOpsManager)((PackageManagerWrapper)object).zza.getSystemService("appops");
                if (object == null) {
                    object = new NullPointerException("context.getSystemService(Context.APP_OPS_SERVICE) is null");
                    throw object;
                }
                object.checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        String[] stringArray = ((PackageManagerWrapper)object).zza.getPackageManager().getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }
}

