/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.WorkSource;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.wrappers.Wrappers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@KeepForSdk
public class WorkSourceUtil {
    private static final int zza;
    @Nullable
    private static final Method zzb;
    @Nullable
    private static final Method zzc;
    @Nullable
    private static final Method zzd;
    @Nullable
    private static final Method zze;
    @Nullable
    private static final Method zzf;
    @Nullable
    private static final Method zzg;
    @Nullable
    private static final Method zzh;

    private WorkSourceUtil() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    @KeepForSdk
    public static WorkSource fromPackage(@RecentlyNonNull Context object, @Nullable String string2) {
        ApplicationInfo applicationInfo;
        String string3;
        block4: {
            void var0_4;
            block6: {
                String string4;
                block5: {
                    if (object == null) return null;
                    if (object.getPackageManager() == null) return null;
                    if (string3 == null) return null;
                    try {
                        applicationInfo = Wrappers.packageManager((Context)object).getApplicationInfo(string3, 0);
                        if (applicationInfo != null) break block4;
                        string4 = "Could not get applicationInfo from package: ";
                        if (string3.length() == 0) break block5;
                        String string5 = string4.concat(string3);
                        break block6;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        void var0_9;
                        String string7 = "Could not find package: ";
                        if (string3.length() != 0) {
                            String string8 = string7.concat(string3);
                        } else {
                            String string9 = string3 = new String(string7);
                        }
                        Log.e((String)"WorkSourceUtil", (String)var0_9);
                        return null;
                    }
                }
                String string6 = string3 = new String(string4);
            }
            Log.e((String)"WorkSourceUtil", (String)var0_4);
            return null;
        }
        int n = applicationInfo.uid;
        WorkSource workSource = new WorkSource();
        WorkSourceUtil.zza(workSource, n, string3);
        return workSource;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNullable
    @KeepForSdk
    public static WorkSource fromPackageAndModuleExperimentalPi(@RecentlyNonNull Context object, @RecentlyNonNull String objectArray, @RecentlyNonNull String string2) {
        void var0_6;
        String string3;
        Object[] objectArray2;
        void var2_17;
        block13: {
            ApplicationInfo applicationInfo;
            block10: {
                void var0_4;
                block12: {
                    String string4;
                    block11: {
                        if (object == null || object.getPackageManager() == null || var2_17 == null || objectArray2 == null) {
                            Log.w((String)"WorkSourceUtil", (String)"Unexpected null arguments");
                            return null;
                        }
                        try {
                            applicationInfo = Wrappers.packageManager(object).getApplicationInfo((String)objectArray2, 0);
                            if (applicationInfo != null) break block10;
                            string4 = "Could not get applicationInfo from package: ";
                            if (objectArray2.length() == 0) break block11;
                            String string5 = string4.concat((String)objectArray2);
                            break block12;
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            void var0_12;
                            String string6 = "Could not find package: ";
                            if (objectArray2.length() != 0) {
                                String string7 = string6.concat((String)objectArray2);
                            } else {
                                String string8 = string3 = new String(string6);
                            }
                            Log.e((String)"WorkSourceUtil", (String)var0_12);
                            int n = -1;
                        }
                    }
                    String string9 = string3 = new String(string4);
                }
                Log.e((String)"WorkSourceUtil", (String)var0_4);
                int n = -1;
                break block13;
            }
            int n = applicationInfo.uid;
        }
        if (var0_6 < 0) {
            return null;
        }
        string3 = new WorkSource();
        if (zzg == null || zzh == null) {
            WorkSourceUtil.zza((WorkSource)string3, (int)var0_6, (String)objectArray2);
            return string3;
        }
        try {
            Object object2 = zzg.invoke((Object)string3, new Object[0]);
            int n = zza;
            if (var0_6 != n) {
                Method method = zzh;
                Object[] objectArray3 = new Object[]{(int)var0_6, objectArray2};
                method.invoke(object2, objectArray3);
            }
            Method method = zzh;
            objectArray2 = new Object[]{zza, var2_17};
            method.invoke(object2, objectArray2);
            return string3;
        }
        catch (Exception exception) {
            Log.w((String)"WorkSourceUtil", (String)"Unable to assign chained blame through WorkSource", (Throwable)exception);
            return string3;
        }
    }

    /*
     * Unable to fully structure code
     */
    @KeepForSdk
    @RecentlyNonNull
    public static List<String> getNames(@Nullable WorkSource var0) {
        block10: {
            block8: {
                var4_1 = new ArrayList<String>();
                if (var0 != null) break block8;
                var1_2 = 0;
lbl4:
                // 4 sources

                while (true) {
                    block9: {
                        if (var1_2 == 0) break block9;
                        block5: for (var2_5 = 0; var2_5 < var1_2; ++var2_5) {
                            if (WorkSourceUtil.zzf != null) {
                                var3_6 = WorkSourceUtil.zzf;
                                var5_8 = new Object[]{var2_5};
                                var3_6 = (String)var3_6.invoke((Object)var0, var5_8);
lbl12:
                                // 3 sources

                                while (true) {
                                    if (Strings.isEmptyOrWhitespace((String)var3_6)) continue block5;
                                    Preconditions.checkNotNull(var3_6);
                                    var4_1.add((String)var3_6);
                                    continue block5;
                                    break;
                                }
                            }
                            var3_6 = null;
                            ** GOTO lbl12
                        }
                        return var4_1;
                    }
                    return var4_1;
                }
            }
            if (WorkSourceUtil.zzd == null) break block10;
            try {
                var1_3 = WorkSourceUtil.zzd.invoke((Object)var0, new Object[0]);
                Preconditions.checkNotNull(var1_3);
                var1_2 = (Integer)var1_3;
                ** GOTO lbl4
            }
            catch (Exception var1_4) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)var1_4);
                var1_2 = 0;
                ** continue;
            }
        }
        var1_2 = 0;
        ** GOTO lbl4
        catch (Exception var3_7) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)var3_7);
            var3_6 = null;
            ** continue;
        }
    }

    @KeepForSdk
    public static boolean hasWorkSourcePermission(@RecentlyNonNull Context context) {
        if (context == null) {
            return false;
        }
        if (context.getPackageManager() == null) {
            return false;
        }
        return Wrappers.packageManager(context).checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName()) == 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block25: {
            block24: {
                block23: {
                    block22: {
                        WorkSourceUtil.zza = Process.myUid();
                        try {
                            var0 = new Class[]{Integer.TYPE};
                            var0 = WorkSource.class.getMethod("add", (Class<?>)var0);
                        }
                        catch (Exception v0) {
                            var0 = null;
                        }
                        WorkSourceUtil.zzb = var0;
                        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                            var0 = new Class[]{Integer.TYPE, String.class};
                            var0 = WorkSource.class.getMethod("add", (Class<?>)var0);
                            ** GOTO lbl18
                        } else {
                            var0 = null;
                        }
                        break block22;
                        catch (Exception v1) {
                            var0 = null;
                        }
                    }
                    WorkSourceUtil.zzc = var0;
                    try {
                        var0 = WorkSource.class.getMethod("size", new Class[0]);
                    }
                    catch (Exception v2) {
                        var0 = null;
                    }
                    WorkSourceUtil.zzd = var0;
                    try {
                        var0 = new Class[]{Integer.TYPE};
                        var0 = WorkSource.class.getMethod("get", (Class<?>)var0);
                    }
                    catch (Exception v3) {
                        var0 = null;
                    }
                    WorkSourceUtil.zze = var0;
                    if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                        var0 = new Class[]{Integer.TYPE};
                        var0 = WorkSource.class.getMethod("getName", (Class<?>)var0);
                        ** GOTO lbl42
                    } else {
                        var0 = null;
                    }
                    break block23;
                    catch (Exception v4) {
                        var0 = null;
                    }
                }
                WorkSourceUtil.zzf = var0;
                if (PlatformVersion.isAtLeastP()) {
                    var0 = WorkSource.class.getMethod("createWorkChain", new Class[0]);
                    ** GOTO lbl54
                } else {
                    var0 = null;
                }
                break block24;
                catch (Exception var0_1) {
                    Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain API createWorkChain", (Throwable)var0_1);
                    var0 = null;
                }
            }
            WorkSourceUtil.zzg = var0;
            if (PlatformVersion.isAtLeastP()) {
                var0 = Class.forName("android.os.WorkSource$WorkChain");
                var1_3 = new Class[]{Integer.TYPE, String.class};
                var0 = var0.getMethod("addNode", var1_3);
                ** GOTO lbl68
            } else {
                var0 = null;
            }
            break block25;
            catch (Exception var0_2) {
                Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain class", (Throwable)var0_2);
                var0 = null;
            }
        }
        WorkSourceUtil.zzh = var0;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zza(@RecentlyNonNull WorkSource workSource, int n, @Nullable String object) {
        if (zzc != null) {
            Method method = zzc;
            Object[] objectArray = new Object[]{n, object};
            method.invoke((Object)workSource, objectArray);
            return;
        }
        if (zzb == null) return;
        try {
            object = zzb;
            Object[] objectArray = new Object[]{n};
            ((Method)object).invoke((Object)workSource, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return;
        }
    }
}

