/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.os.ParcelFileDescriptor;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;

@Deprecated
@ShowFirstParty
@KeepForSdk
public final class IOUtils {
    private IOUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static void closeQuietly(@Nullable ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor == null) return;
        try {
            parcelFileDescriptor.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @KeepForSdk
    public static boolean isGzipByteBuffer(@RecentlyNonNull byte[] byArray) {
        return byArray.length > 1 && (byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8) == 35615;
    }

    @Deprecated
    @KeepForSdk
    public static long copyStream(@RecentlyNonNull InputStream inputStream, @RecentlyNonNull OutputStream outputStream) throws IOException {
        return IOUtils.copyStream(inputStream, outputStream, false, 1024);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public static long copyStream(@RecentlyNonNull InputStream inputStream, @RecentlyNonNull OutputStream outputStream, boolean bl, int n) throws IOException {
        byte[] byArray = new byte[n];
        long l = 0L;
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                long l2 = l + (long)n2;
                outputStream.write(byArray, 0, n2);
                l = l2;
            }
            if (!bl) return l;
        }
        catch (Throwable throwable) {
            if (!bl) {
                throw throwable;
            }
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
        return l;
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static byte[] readInputStreamFully(@RecentlyNonNull InputStream inputStream) throws IOException {
        return IOUtils.readInputStreamFully(inputStream, true);
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static byte[] readInputStreamFully(@RecentlyNonNull InputStream inputStream, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copyStream(inputStream, byteArrayOutputStream, bl, 1024);
        return byteArrayOutputStream.toByteArray();
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static byte[] toByteArray(@RecentlyNonNull InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(byteArrayOutputStream);
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            ((OutputStream)byteArrayOutputStream).write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

