/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.util.VisibleForTesting;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@VisibleForTesting
@KeepForSdk
public final class ArrayUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static <T> boolean contains(@RecentlyNonNull T[] TArray, @RecentlyNonNull T t) {
        if (TArray == null) return false;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (Objects.equal(TArray[n2], t)) {
                if (n2 < 0) return false;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @KeepForSdk
    public static boolean contains(@RecentlyNonNull int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    @KeepForSdk
    @RecentlyNullable
    public static Integer[] toWrapperArray(@RecentlyNonNull int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    private ArrayUtils() {
    }

    @KeepForSdk
    public static <T> void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull T[] TArray) {
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(TArray[i]);
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString(nArray[i]));
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull long[] lArray) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Long.toString(lArray[i]));
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull float[] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Float.toString(fArray[i]));
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Double.toString(dArray[i]));
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull boolean[] blArray) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Boolean.toString(blArray[i]));
        }
    }

    @KeepForSdk
    public static void writeStringArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("\"");
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> T[] concat(T[] ... TArray) {
        if (TArray.length != 0) {
            int n;
            int n2 = 0;
            for (n = 0; n < TArray.length; ++n) {
                n2 += TArray[n].length;
            }
            T[] TArray2 = Arrays.copyOf(TArray[0], n2);
            n2 = TArray[0].length;
            for (n = 1; n < TArray.length; ++n) {
                T[] TArray3 = TArray[n];
                int n3 = TArray3.length;
                System.arraycopy(TArray3, 0, TArray2, n2, n3);
                n2 += n3;
            }
            return TArray2;
        }
        return (Object[])Array.newInstance(TArray.getClass(), 0);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static byte[] concatByteArrays(byte[] ... byArray) {
        if (byArray.length != 0) {
            int n;
            int n2 = 0;
            for (n = 0; n < byArray.length; ++n) {
                n2 += byArray[n].length;
            }
            byte[] byArray2 = Arrays.copyOf(byArray[0], n2);
            n2 = byArray[0].length;
            for (n = 1; n < byArray.length; ++n) {
                byte[] byArray3 = byArray[n];
                int n3 = byArray3.length;
                System.arraycopy(byArray3, 0, byArray2, n2, n3);
                n2 += n3;
            }
            return byArray2;
        }
        return new byte[0];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @RecentlyNonNull
    public static <T> T[] appendToArray(@RecentlyNonNull T[] object, @RecentlyNonNull T t) {
        void var0_2;
        void var1_5;
        if (object == null && var1_5 == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot generate array of generic type w/o class info");
            throw illegalArgumentException;
        }
        if (object == null) {
            Object[] objectArray = (Object[])Array.newInstance(var1_5.getClass(), 1);
        } else {
            T[] TArray = Arrays.copyOf(object, ((T[])object).length + 1);
        }
        var0_2[((void)var0_2).length + -1] = var1_5;
        return var0_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @RecentlyNullable
    public static <T> T[] removeAll(@RecentlyNonNull T[] TArray, T ... TArray2) {
        int n;
        if (TArray == null) {
            return null;
        }
        if (TArray2 == null) return Arrays.copyOf(TArray, TArray.length);
        int n2 = TArray2.length;
        if (n2 == 0) {
            return Arrays.copyOf(TArray, TArray.length);
        }
        Class<?> clazz = TArray2.getClass().getComponentType();
        int n3 = TArray.length;
        Object[] objectArray = (Object[])Array.newInstance(clazz, n3);
        if (n2 == 1) {
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                T t = TArray[i];
                if (Objects.equal(TArray2[0], t)) continue;
                int n4 = n2 + 1;
                objectArray[n2] = t;
                n2 = n4;
            }
            n = n2;
        } else {
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                T t = TArray[i];
                if (ArrayUtils.contains(TArray2, t)) continue;
                int n5 = n2 + 1;
                objectArray[n2] = t;
                n2 = n5;
            }
            n = n2;
        }
        if (objectArray == null) {
            return null;
        }
        if (n != objectArray.length) return Arrays.copyOf(objectArray, n);
        return objectArray;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> ArrayList<T> toArrayList(@RecentlyNonNull T[] TArray) {
        int n = TArray.length;
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(TArray[i]);
        }
        return arrayList;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static int[] toPrimitiveArray(@RecentlyNonNull Collection<Integer> collection) {
        if (collection == null || collection.size() == 0) {
            return new int[0];
        }
        int[] nArray = new int[collection.size()];
        Iterator<Integer> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = n + 1;
            nArray[n] = iterator.next();
            n = n2;
        }
        return nArray;
    }
}

