/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;

public final class zzm {
    @Nullable
    private final String zza;
    @Nullable
    private final String zzb;
    @Nullable
    private final ComponentName zzc;
    private final int zzd;
    private final boolean zze;
    private static final Uri zzf;

    public zzm(String string2, String string3, int n) {
        this(string2, "com.google.android.gms", n, false);
    }

    public zzm(String string2, String string3, int n, boolean bl) {
        Preconditions.checkNotEmpty(string2);
        this.zza = string2;
        Preconditions.checkNotEmpty(string3);
        this.zzb = string3;
        this.zzc = null;
        this.zzd = n;
        this.zze = bl;
    }

    public zzm(ComponentName componentName, int n) {
        this.zza = null;
        this.zzb = null;
        Preconditions.checkNotNull(componentName);
        this.zzc = componentName;
        this.zzd = n;
        this.zze = false;
    }

    public final String toString() {
        String string2 = this.zza;
        if (string2 == null) {
            Preconditions.checkNotNull(this.zzc);
            return this.zzc.flattenToString();
        }
        return string2;
    }

    @Nullable
    public final String zza() {
        return this.zzb;
    }

    @Nullable
    public final ComponentName zzb() {
        return this.zzc;
    }

    public final int zzc() {
        return this.zzd;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Intent zzd(Context object) {
        block6: {
            CharSequence charSequence;
            Object object2;
            if (this.zza == null) {
                object = new Intent();
                return object.setComponent(this.zzc);
            }
            if (this.zze) {
                object2 = new Bundle();
                object2.putString("serviceActionBundleKey", this.zza);
                object = object.getContentResolver().call(zzf, "serviceIntentCall", null, (Bundle)object2);
            }
            object = null;
            break block6;
            catch (IllegalArgumentException illegalArgumentException) {
                object = String.valueOf(illegalArgumentException);
                object2 = String.valueOf(object);
                int n = ((String)object2).length();
                charSequence = new StringBuilder(n + 34);
                ((StringBuilder)charSequence).append("Dynamic intent resolution failed: ");
                ((StringBuilder)charSequence).append((String)object);
                Log.w((String)"ConnectionStatusConfig", (String)((StringBuilder)charSequence).toString());
                object = null;
            }
            object = object == null ? null : (Intent)object.getParcelable("serviceResponseIntentKey");
            if (object == null) {
                String string2 = String.valueOf(this.zza);
                charSequence = "Dynamic lookup for intent failed for action: ";
                string2 = string2.length() != 0 ? ((String)charSequence).concat(string2) : new String((String)charSequence);
                Log.w((String)"ConnectionStatusConfig", (String)string2);
            }
        }
        if (object != null) {
            return object;
        }
        object = new Intent(this.zza);
        return object.setPackage(this.zzb);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze};
        return Objects.hashCode(objectArray);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzm)) {
            return false;
        }
        object = (zzm)object;
        return Objects.equal(this.zza, ((zzm)object).zza) && Objects.equal(this.zzb, ((zzm)object).zzb) && Objects.equal(this.zzc, ((zzm)object).zzc) && this.zzd == ((zzm)object).zzd && this.zze == ((zzm)object).zze;
    }

    static {
        Uri.Builder builder = new Uri.Builder();
        zzf = builder.scheme("content").authority("com.google.android.gms.chimera").build();
    }
}

