/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import androidx.annotation.RecentlyNonNull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class SafeParcelWriter {
    private SafeParcelWriter() {
    }

    public static int beginObjectHeader(@RecentlyNonNull Parcel parcel) {
        return SafeParcelWriter.zzb(parcel, 20293);
    }

    public static void finishObjectHeader(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeBoolean(@RecentlyNonNull Parcel parcel, int n, boolean bl) {
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeInt(bl ? 1 : 0);
    }

    public static void writeBooleanObject(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Boolean bl, boolean bl2) {
        if (bl == null) {
            if (bl2) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeInt(bl.booleanValue() ? 1 : 0);
    }

    public static void writeByte(@RecentlyNonNull Parcel parcel, int n, byte by) {
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeInt((int)by);
    }

    public static void writeChar(@RecentlyNonNull Parcel parcel, int n, char c) {
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeInt((int)c);
    }

    public static void writeShort(@RecentlyNonNull Parcel parcel, int n, short s) {
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeInt((int)s);
    }

    public static void writeInt(@RecentlyNonNull Parcel parcel, int n, int n2) {
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeInt(n2);
    }

    public static void writeIntegerObject(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Integer n2, boolean bl) {
        if (n2 == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeInt(n2.intValue());
    }

    public static void writeLong(@RecentlyNonNull Parcel parcel, int n, long l) {
        SafeParcelWriter.zza(parcel, n, 8);
        parcel.writeLong(l);
    }

    public static void writeLongObject(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Long l, boolean bl) {
        if (l == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        SafeParcelWriter.zza(parcel, n, 8);
        parcel.writeLong(l.longValue());
    }

    public static void writeBigInteger(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull BigInteger bigInteger, boolean bl) {
        if (bigInteger == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeByteArray(bigInteger.toByteArray());
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeFloat(@RecentlyNonNull Parcel parcel, int n, float f) {
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeFloat(f);
    }

    public static void writeFloatObject(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Float f, boolean bl) {
        if (f == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        SafeParcelWriter.zza(parcel, n, 4);
        parcel.writeFloat(f.floatValue());
    }

    public static void writeDouble(@RecentlyNonNull Parcel parcel, int n, double d) {
        SafeParcelWriter.zza(parcel, n, 8);
        parcel.writeDouble(d);
    }

    public static void writeDoubleObject(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Double d, boolean bl) {
        if (d == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        SafeParcelWriter.zza(parcel, n, 8);
        parcel.writeDouble(d.doubleValue());
    }

    public static void writeBigDecimal(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull BigDecimal bigDecimal, boolean bl) {
        if (bigDecimal == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeByteArray(bigDecimal.unscaledValue().toByteArray());
        parcel.writeInt(bigDecimal.scale());
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeString(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull String string2, boolean bl) {
        if (string2 == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeString(string2);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeIBinder(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull IBinder iBinder, boolean bl) {
        if (iBinder == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeStrongBinder(iBinder);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeParcelable(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable parcelable, int n2, boolean bl) {
        if (parcelable == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcelable.writeToParcel(parcel, n2);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeBundle(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Bundle bundle, boolean bl) {
        if (bundle == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeBundle(bundle);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeByteArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull byte[] byArray, boolean bl) {
        if (byArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeByteArray(byArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeByteArrayArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull byte[][] byArray, boolean bl) {
        if (byArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = byArray.length;
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeByteArray(byArray[n]);
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeBooleanArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull boolean[] blArray, boolean bl) {
        if (blArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeBooleanArray(blArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeCharArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull char[] cArray, boolean bl) {
        if (cArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeCharArray(cArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeIntArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull int[] nArray, boolean bl) {
        if (nArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeIntArray(nArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeLongArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull long[] lArray, boolean bl) {
        if (lArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeLongArray(lArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeBigIntegerArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull BigInteger[] bigIntegerArray, boolean bl) {
        if (bigIntegerArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = bigIntegerArray.length;
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeByteArray(bigIntegerArray[n].toByteArray());
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeFloatArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull float[] fArray, boolean bl) {
        if (fArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeFloatArray(fArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeDoubleArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull double[] dArray, boolean bl) {
        if (dArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeDoubleArray(dArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeBigDecimalArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull BigDecimal[] bigDecimalArray, boolean bl) {
        if (bigDecimalArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = bigDecimalArray.length;
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeByteArray(bigDecimalArray[n].unscaledValue().toByteArray());
            parcel.writeInt(bigDecimalArray[n].scale());
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeStringArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull String[] stringArray, boolean bl) {
        if (stringArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeStringArray(stringArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeIBinderArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull IBinder[] iBinderArray, boolean bl) {
        if (iBinderArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeBinderArray(iBinderArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeBooleanList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<Boolean> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = list.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(list.get(n).booleanValue() ? 1 : 0);
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeIntegerList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<Integer> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = list.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(list.get(n).intValue());
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeLongList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<Long> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = list.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeLong(list.get(n).longValue());
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeFloatList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<Float> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = list.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeFloat(list.get(n).floatValue());
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeDoubleList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<Double> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = list.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeDouble(list.get(n).doubleValue());
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeStringList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<String> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeStringList(list);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeIBinderList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<IBinder> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeBinderList(list);
        SafeParcelWriter.zzc(parcel, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T extends Parcelable> void writeTypedArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull T[] TArray, int n2, boolean bl) {
        if (TArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n3 = SafeParcelWriter.zzb(parcel, n);
        int n4 = TArray.length;
        parcel.writeInt(n4);
        n = 0;
        while (true) {
            if (n >= n4) {
                SafeParcelWriter.zzc(parcel, n3);
                return;
            }
            T t = TArray[n];
            if (t == null) {
                parcel.writeInt(0);
            } else {
                SafeParcelWriter.zzd(parcel, t, n2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T extends Parcelable> void writeTypedList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<T> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = list.size();
        parcel.writeInt(n3);
        n = 0;
        while (true) {
            if (n >= n3) {
                SafeParcelWriter.zzc(parcel, n2);
                return;
            }
            Parcelable parcelable = (Parcelable)list.get(n);
            if (parcelable == null) {
                parcel.writeInt(0);
            } else {
                SafeParcelWriter.zzd(parcel, parcelable, 0);
            }
            ++n;
        }
    }

    public static void writeParcel(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcel parcel2, boolean bl) {
        if (parcel2 == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.appendFrom(parcel2, 0, parcel2.dataSize());
        SafeParcelWriter.zzc(parcel, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeParcelArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcel[] parcelArray, boolean bl) {
        if (parcelArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = parcelArray.length;
        parcel.writeInt(n3);
        n = 0;
        while (true) {
            if (n >= n3) {
                SafeParcelWriter.zzc(parcel, n2);
                return;
            }
            Parcel parcel2 = parcelArray[n];
            if (parcel2 != null) {
                parcel.writeInt(parcel2.dataSize());
                parcel.appendFrom(parcel2, 0, parcel2.dataSize());
            } else {
                parcel.writeInt(0);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeParcelList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List<Parcel> list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = list.size();
        parcel.writeInt(n3);
        n = 0;
        while (true) {
            if (n >= n3) {
                SafeParcelWriter.zzc(parcel, n2);
                return;
            }
            Parcel parcel2 = list.get(n);
            if (parcel2 != null) {
                parcel.writeInt(parcel2.dataSize());
                parcel.appendFrom(parcel2, 0, parcel2.dataSize());
            } else {
                parcel.writeInt(0);
            }
            ++n;
        }
    }

    public static void writePendingIntent(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull PendingIntent pendingIntent, boolean bl) {
        if (pendingIntent == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        PendingIntent.writePendingIntentOrNullToParcel((PendingIntent)pendingIntent, (Parcel)parcel);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List list, boolean bl) {
        if (list == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeList(list);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeSparseBooleanArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseBooleanArray sparseBooleanArray, boolean bl) {
        if (sparseBooleanArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        n = SafeParcelWriter.zzb(parcel, n);
        parcel.writeSparseBooleanArray(sparseBooleanArray);
        SafeParcelWriter.zzc(parcel, n);
    }

    public static void writeDoubleSparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseArray<Double> sparseArray, boolean bl) {
        if (sparseArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseArray.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(sparseArray.keyAt(n));
            parcel.writeDouble(((Double)sparseArray.valueAt(n)).doubleValue());
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeFloatSparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseArray<Float> sparseArray, boolean bl) {
        if (sparseArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseArray.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(sparseArray.keyAt(n));
            parcel.writeFloat(((Float)sparseArray.valueAt(n)).floatValue());
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeSparseIntArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseIntArray sparseIntArray, boolean bl) {
        if (sparseIntArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseIntArray.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(sparseIntArray.keyAt(n));
            parcel.writeInt(sparseIntArray.valueAt(n));
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeSparseLongArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseLongArray sparseLongArray, boolean bl) {
        if (sparseLongArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseLongArray.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(sparseLongArray.keyAt(n));
            parcel.writeLong(sparseLongArray.valueAt(n));
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeStringSparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseArray<String> sparseArray, boolean bl) {
        if (sparseArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseArray.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(sparseArray.keyAt(n));
            parcel.writeString((String)sparseArray.valueAt(n));
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeParcelSparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseArray<Parcel> sparseArray, boolean bl) {
        if (sparseArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseArray.size();
        parcel.writeInt(n3);
        n = 0;
        while (true) {
            if (n >= n3) {
                SafeParcelWriter.zzc(parcel, n2);
                return;
            }
            parcel.writeInt(sparseArray.keyAt(n));
            Parcel parcel2 = (Parcel)sparseArray.valueAt(n);
            if (parcel2 != null) {
                parcel.writeInt(parcel2.dataSize());
                parcel.appendFrom(parcel2, 0, parcel2.dataSize());
            } else {
                parcel.writeInt(0);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T extends Parcelable> void writeTypedSparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseArray<T> sparseArray, boolean bl) {
        if (sparseArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseArray.size();
        parcel.writeInt(n3);
        n = 0;
        while (true) {
            if (n >= n3) {
                SafeParcelWriter.zzc(parcel, n2);
                return;
            }
            parcel.writeInt(sparseArray.keyAt(n));
            Parcelable parcelable = (Parcelable)sparseArray.valueAt(n);
            if (parcelable == null) {
                parcel.writeInt(0);
            } else {
                SafeParcelWriter.zzd(parcel, parcelable, 0);
            }
            ++n;
        }
    }

    public static void writeIBinderSparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseArray<IBinder> sparseArray, boolean bl) {
        if (sparseArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseArray.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(sparseArray.keyAt(n));
            parcel.writeStrongBinder((IBinder)sparseArray.valueAt(n));
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    public static void writeByteArraySparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull SparseArray<byte[]> sparseArray, boolean bl) {
        if (sparseArray == null) {
            if (bl) {
                SafeParcelWriter.zza(parcel, n, 0);
                return;
            }
            return;
        }
        int n2 = SafeParcelWriter.zzb(parcel, n);
        int n3 = sparseArray.size();
        parcel.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            parcel.writeInt(sparseArray.keyAt(n));
            parcel.writeByteArray((byte[])sparseArray.valueAt(n));
        }
        SafeParcelWriter.zzc(parcel, n2);
    }

    private static void zza(Parcel parcel, int n, int n2) {
        parcel.writeInt(n2 << 16 | n);
    }

    private static int zzb(Parcel parcel, int n) {
        parcel.writeInt(n | 0xFFFF0000);
        parcel.writeInt(0);
        return parcel.dataPosition();
    }

    private static void zzc(Parcel parcel, int n) {
        int n2 = parcel.dataPosition();
        parcel.setDataPosition(n + -4);
        parcel.writeInt(n2 - n);
        parcel.setDataPosition(n2);
    }

    private static <T extends Parcelable> void zzd(Parcel parcel, T t, int n) {
        int n2 = parcel.dataPosition();
        parcel.writeInt(1);
        int n3 = parcel.dataPosition();
        t.writeToParcel(parcel, n);
        int n4 = parcel.dataPosition();
        parcel.setDataPosition(n2);
        parcel.writeInt(n4 - n3);
        parcel.setDataPosition(n4);
    }
}

