/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.app.PendingIntent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import androidx.annotation.RecentlyNonNull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class SafeParcelReader {
    private SafeParcelReader() {
    }

    public static int readHeader(@RecentlyNonNull Parcel parcel) {
        return parcel.readInt();
    }

    public static int getFieldId(int n) {
        return (char)n;
    }

    public static int readSize(@RecentlyNonNull Parcel parcel, int n) {
        if ((n & 0xFFFF0000) != -65536) {
            return (char)(n >> 16);
        }
        return parcel.readInt();
    }

    public static void skipUnknownField(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        parcel.setDataPosition(parcel.dataPosition() + n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int validateObjectHeader(@RecentlyNonNull Parcel parcel) {
        int n = SafeParcelReader.readHeader(parcel);
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (SafeParcelReader.getFieldId(n) != 20293) {
            String string2 = String.valueOf(Integer.toHexString(n));
            String string3 = "Expected object header. Got 0x";
            string2 = string2.length() != 0 ? string3.concat(string2) : new String(string3);
            ParseException parseException = new ParseException(string2, parcel);
            throw parseException;
        }
        n = n3 + n2;
        if (n >= n3 && n <= parcel.dataSize()) {
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder(54);
        stringBuilder.append("Size read is invalid start=");
        stringBuilder.append(n3);
        stringBuilder.append(" end=");
        stringBuilder.append(n);
        ParseException parseException = new ParseException(stringBuilder.toString(), parcel);
        throw parseException;
    }

    public static boolean readBoolean(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readInt() != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNonNull
    public static Boolean readBooleanObject(@RecentlyNonNull Parcel parcel, int n) {
        boolean bl;
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, n, n2, 4);
        if (parcel.readInt() != 0) {
            bl = true;
            return bl;
        }
        bl = false;
        return bl;
    }

    public static byte readByte(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (byte)parcel.readInt();
    }

    public static char readChar(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (char)parcel.readInt();
    }

    public static short readShort(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return (short)parcel.readInt();
    }

    public static int readInt(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readInt();
    }

    @RecentlyNonNull
    public static Integer readIntegerObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, n, n2, 4);
        return parcel.readInt();
    }

    public static long readLong(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 8);
        return parcel.readLong();
    }

    @RecentlyNonNull
    public static Long readLongObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, n, n2, 8);
        return parcel.readLong();
    }

    @RecentlyNonNull
    public static BigInteger createBigInteger(@RecentlyNonNull Parcel object, int n) {
        n = SafeParcelReader.readSize(object, n);
        int n2 = object.dataPosition();
        if (n == 0) {
            return null;
        }
        byte[] byArray = object.createByteArray();
        object.setDataPosition(n2 + n);
        object = new BigInteger(byArray);
        return object;
    }

    public static float readFloat(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 4);
        return parcel.readFloat();
    }

    @RecentlyNonNull
    public static Float readFloatObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, n, n2, 4);
        return Float.valueOf(parcel.readFloat());
    }

    public static double readDouble(@RecentlyNonNull Parcel parcel, int n) {
        SafeParcelReader.zza(parcel, n, 8);
        return parcel.readDouble();
    }

    @RecentlyNonNull
    public static Double readDoubleObject(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        if (n2 == 0) {
            return null;
        }
        SafeParcelReader.zzb(parcel, n, n2, 8);
        return parcel.readDouble();
    }

    @RecentlyNonNull
    public static BigDecimal createBigDecimal(@RecentlyNonNull Parcel object, int n) {
        n = SafeParcelReader.readSize(object, n);
        int n2 = object.dataPosition();
        if (n == 0) {
            return null;
        }
        byte[] byArray = object.createByteArray();
        int n3 = object.readInt();
        object.setDataPosition(n2 + n);
        BigInteger bigInteger = new BigInteger(byArray);
        object = new BigDecimal(bigInteger, n3);
        return object;
    }

    @RecentlyNonNull
    public static String createString(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        String string2 = parcel.readString();
        parcel.setDataPosition(n2 + n);
        return string2;
    }

    @RecentlyNonNull
    public static IBinder readIBinder(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        IBinder iBinder = parcel.readStrongBinder();
        parcel.setDataPosition(n2 + n);
        return iBinder;
    }

    @RecentlyNonNull
    public static PendingIntent readPendingIntent(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        PendingIntent pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel((Parcel)parcel);
        parcel.setDataPosition(n2 + n);
        return pendingIntent;
    }

    @RecentlyNonNull
    public static <T extends Parcelable> T createParcelable(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable.Creator<T> parcelable) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        parcelable = parcelable.createFromParcel(parcel);
        parcelable = parcelable;
        parcel.setDataPosition(n2 + n);
        return (T)parcelable;
    }

    @RecentlyNonNull
    public static Bundle createBundle(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        Bundle bundle = parcel.readBundle();
        parcel.setDataPosition(n2 + n);
        return bundle;
    }

    @RecentlyNonNull
    public static byte[] createByteArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        byte[] byArray = parcel.createByteArray();
        parcel.setDataPosition(n2 + n);
        return byArray;
    }

    @RecentlyNonNull
    public static byte[][] createByteArrayArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        byte[][] byArrayArray = new byte[n4][];
        for (n = 0; n < n4; ++n) {
            byArrayArray[n] = parcel.createByteArray();
        }
        parcel.setDataPosition(n3 + n2);
        return byArrayArray;
    }

    @RecentlyNonNull
    public static boolean[] createBooleanArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        boolean[] blArray = parcel.createBooleanArray();
        parcel.setDataPosition(n2 + n);
        return blArray;
    }

    @RecentlyNonNull
    public static char[] createCharArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        char[] cArray = parcel.createCharArray();
        parcel.setDataPosition(n2 + n);
        return cArray;
    }

    @RecentlyNonNull
    public static int[] createIntArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        int[] nArray = parcel.createIntArray();
        parcel.setDataPosition(n2 + n);
        return nArray;
    }

    @RecentlyNonNull
    public static long[] createLongArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        long[] lArray = parcel.createLongArray();
        parcel.setDataPosition(n2 + n);
        return lArray;
    }

    @RecentlyNonNull
    public static BigInteger[] createBigIntegerArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        BigInteger[] bigIntegerArray = new BigInteger[n4];
        for (n = 0; n < n4; ++n) {
            BigInteger bigInteger;
            bigIntegerArray[n] = bigInteger = new BigInteger(parcel.createByteArray());
        }
        parcel.setDataPosition(n3 + n2);
        return bigIntegerArray;
    }

    @RecentlyNonNull
    public static float[] createFloatArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        float[] fArray = parcel.createFloatArray();
        parcel.setDataPosition(n2 + n);
        return fArray;
    }

    @RecentlyNonNull
    public static double[] createDoubleArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        double[] dArray = parcel.createDoubleArray();
        parcel.setDataPosition(n2 + n);
        return dArray;
    }

    @RecentlyNonNull
    public static BigDecimal[] createBigDecimalArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        BigDecimal[] bigDecimalArray = new BigDecimal[n4];
        for (n = 0; n < n4; ++n) {
            BigDecimal bigDecimal;
            byte[] byArray = parcel.createByteArray();
            int n5 = parcel.readInt();
            BigInteger bigInteger = new BigInteger(byArray);
            bigDecimalArray[n] = bigDecimal = new BigDecimal(bigInteger, n5);
        }
        parcel.setDataPosition(n3 + n2);
        return bigDecimalArray;
    }

    @RecentlyNonNull
    public static String[] createStringArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        String[] stringArray = parcel.createStringArray();
        parcel.setDataPosition(n2 + n);
        return stringArray;
    }

    @RecentlyNonNull
    public static IBinder[] createIBinderArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        IBinder[] iBinderArray = parcel.createBinderArray();
        parcel.setDataPosition(n2 + n);
        return iBinderArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public static ArrayList<Boolean> createBooleanList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        int n4 = parcel.readInt();
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return arrayList;
            }
            boolean bl = parcel.readInt() != 0;
            arrayList.add(bl);
            ++n;
        }
    }

    @RecentlyNonNull
    public static ArrayList<Integer> createIntegerList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList.add(parcel.readInt());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static SparseBooleanArray createSparseBooleanArray(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        SparseBooleanArray sparseBooleanArray = parcel.readSparseBooleanArray();
        parcel.setDataPosition(n2 + n);
        return sparseBooleanArray;
    }

    @RecentlyNonNull
    public static SparseIntArray createSparseIntArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseIntArray sparseIntArray = new SparseIntArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseIntArray.append(parcel.readInt(), parcel.readInt());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseIntArray;
    }

    @RecentlyNonNull
    public static SparseArray<Float> createFloatSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)Float.valueOf(parcel.readFloat()));
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static SparseArray<Double> createDoubleSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)parcel.readDouble());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static SparseLongArray createSparseLongArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseLongArray sparseLongArray = new SparseLongArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseLongArray.append(parcel.readInt(), parcel.readLong());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseLongArray;
    }

    @RecentlyNonNull
    public static SparseArray<String> createStringSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        SparseArray sparseArray = new SparseArray();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)parcel.readString());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public static SparseArray<Parcel> createParcelSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray();
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return sparseArray;
            }
            int n5 = parcel.readInt();
            int n6 = parcel.readInt();
            if (n6 != 0) {
                int n7 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n7, n6);
                sparseArray.append(n5, (Object)parcel2);
                parcel.setDataPosition(n7 + n6);
            } else {
                sparseArray.append(n5, null);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public static <T> SparseArray<T> createTypedSparseArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable.Creator<T> creator) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray();
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return sparseArray;
            }
            int n5 = parcel.readInt();
            Object object = parcel.readInt() != 0 ? creator.createFromParcel(parcel) : null;
            sparseArray.append(n5, object);
            ++n;
        }
    }

    @RecentlyNonNull
    public static SparseArray<IBinder> createIBinderSparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray(n4);
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)parcel.readStrongBinder());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static SparseArray<byte[]> createByteArraySparseArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        SparseArray sparseArray = new SparseArray(n4);
        for (n = 0; n < n4; ++n) {
            sparseArray.append(parcel.readInt(), (Object)parcel.createByteArray());
        }
        parcel.setDataPosition(n3 + n2);
        return sparseArray;
    }

    @RecentlyNonNull
    public static ArrayList<Long> createLongList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList.add(parcel.readLong());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<Float> createFloatList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList.add(Float.valueOf(parcel.readFloat()));
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<Double> createDoubleList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n4 = parcel.readInt();
        for (n = 0; n < n4; ++n) {
            arrayList.add(parcel.readDouble());
        }
        parcel.setDataPosition(n3 + n2);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<String> createStringList(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createStringArrayList();
        parcel.setDataPosition(n2 + n);
        return arrayList;
    }

    @RecentlyNonNull
    public static ArrayList<IBinder> createIBinderList(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        ArrayList arrayList = parcel.createBinderArrayList();
        parcel.setDataPosition(n2 + n);
        return arrayList;
    }

    @RecentlyNonNull
    public static <T> T[] createTypedArray(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable.Creator<T> objectArray) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        objectArray = parcel.createTypedArray(objectArray);
        parcel.setDataPosition(n2 + n);
        return objectArray;
    }

    @RecentlyNonNull
    public static <T> ArrayList<T> createTypedList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull Parcelable.Creator<T> object) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        object = parcel.createTypedArrayList(object);
        parcel.setDataPosition(n2 + n);
        return object;
    }

    @RecentlyNonNull
    public static Parcel createParcel(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return null;
        }
        Parcel parcel2 = Parcel.obtain();
        parcel2.appendFrom(parcel, n2, n);
        parcel.setDataPosition(n2 + n);
        return parcel2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public static Parcel[] createParcelArray(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        Parcel[] parcelArray = new Parcel[n4];
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return parcelArray;
            }
            int n5 = parcel.readInt();
            if (n5 != 0) {
                int n6 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n6, n5);
                parcelArray[n] = parcel2;
                parcel.setDataPosition(n6 + n5);
            } else {
                parcelArray[n] = null;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public static ArrayList<Parcel> createParcelList(@RecentlyNonNull Parcel parcel, int n) {
        int n2 = SafeParcelReader.readSize(parcel, n);
        int n3 = parcel.dataPosition();
        if (n2 == 0) {
            return null;
        }
        int n4 = parcel.readInt();
        ArrayList<Parcel> arrayList = new ArrayList<Parcel>();
        n = 0;
        while (true) {
            if (n >= n4) {
                parcel.setDataPosition(n3 + n2);
                return arrayList;
            }
            int n5 = parcel.readInt();
            if (n5 != 0) {
                int n6 = parcel.dataPosition();
                Parcel parcel2 = Parcel.obtain();
                parcel2.appendFrom(parcel, n6, n5);
                arrayList.add(parcel2);
                parcel.setDataPosition(n6 + n5);
            } else {
                arrayList.add(null);
            }
            ++n;
        }
    }

    public static void readList(@RecentlyNonNull Parcel parcel, int n, @RecentlyNonNull List list, @RecentlyNonNull ClassLoader classLoader) {
        n = SafeParcelReader.readSize(parcel, n);
        int n2 = parcel.dataPosition();
        if (n == 0) {
            return;
        }
        parcel.readList(list, classLoader);
        parcel.setDataPosition(n2 + n);
    }

    public static void ensureAtEnd(@RecentlyNonNull Parcel parcel, int n) {
        if (parcel.dataPosition() != n) {
            StringBuilder stringBuilder = new StringBuilder(37);
            stringBuilder.append("Overread allowed size end=");
            stringBuilder.append(n);
            ParseException parseException = new ParseException(stringBuilder.toString(), parcel);
            throw parseException;
        }
    }

    private static void zza(Parcel parcel, int n, int n2) {
        if ((n = SafeParcelReader.readSize(parcel, n)) != n2) {
            String string2 = Integer.toHexString(n);
            String string3 = String.valueOf(string2);
            int n3 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + 46);
            stringBuilder.append("Expected size ");
            stringBuilder.append(n2);
            stringBuilder.append(" got ");
            stringBuilder.append(n);
            stringBuilder.append(" (0x");
            stringBuilder.append(string2);
            stringBuilder.append(")");
            ParseException parseException = new ParseException(stringBuilder.toString(), parcel);
            throw parseException;
        }
    }

    private static void zzb(Parcel parcel, int n, int n2, int n3) {
        if (n2 != n3) {
            String string2 = Integer.toHexString(n2);
            String string3 = String.valueOf(string2);
            int n4 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n4 + 46);
            stringBuilder.append("Expected size ");
            stringBuilder.append(n3);
            stringBuilder.append(" got ");
            stringBuilder.append(n2);
            stringBuilder.append(" (0x");
            stringBuilder.append(string2);
            stringBuilder.append(")");
            ParseException parseException = new ParseException(stringBuilder.toString(), parcel);
            throw parseException;
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(@RecentlyNonNull String string2, @RecentlyNonNull Parcel parcel) {
            int n = parcel.dataPosition();
            int n2 = parcel.dataSize();
            String string3 = String.valueOf(string2);
            int n3 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + 41);
            stringBuilder.append(string2);
            stringBuilder.append(" Parcel: pos=");
            stringBuilder.append(n);
            stringBuilder.append(" size=");
            stringBuilder.append(n2);
            super(stringBuilder.toString());
        }
    }
}

