/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.zzb;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

@KeepForSdk
public final class Preconditions {
    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    @NonNull
    public static <T> T checkNotNull(@Nullable T object) {
        if (object == null) {
            object = new Object("null reference");
            throw object;
        }
        return object;
    }

    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    @RecentlyNonNull
    public static String checkNotEmpty(@Nullable String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = new IllegalArgumentException("Given String is empty or null");
            throw object;
        }
        return object;
    }

    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    @RecentlyNonNull
    public static String checkNotEmpty(@Nullable String object, @RecentlyNonNull Object object2) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = new IllegalArgumentException(String.valueOf(object2));
            throw object;
        }
        return object;
    }

    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    @NonNull
    public static <T> T checkNotNull(@RecentlyNonNull T object, @RecentlyNonNull Object object2) {
        if (object == null) {
            object = new Object(String.valueOf(object2));
            throw object;
        }
        return object;
    }

    @KeepForSdk
    public static int checkNotZero(int n, @RecentlyNonNull Object object) {
        if (n == 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.valueOf(object));
            throw illegalArgumentException;
        }
        return n;
    }

    @KeepForSdk
    public static int checkNotZero(int n) {
        if (n == 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Given Integer is zero");
            throw illegalArgumentException;
        }
        return n;
    }

    @KeepForSdk
    public static long checkNotZero(long l, @RecentlyNonNull Object object) {
        if (l == 0L) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.valueOf(object));
            throw illegalArgumentException;
        }
        return l;
    }

    @KeepForSdk
    public static long checkNotZero(long l) {
        if (l == 0L) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Given Long is zero");
            throw illegalArgumentException;
        }
        return l;
    }

    @KeepForSdk
    public static void checkState(boolean bl) {
        if (!bl) {
            IllegalStateException illegalStateException = new IllegalStateException();
            throw illegalStateException;
        }
    }

    @KeepForSdk
    public static void checkState(boolean bl, @RecentlyNonNull Object object) {
        if (!bl) {
            IllegalStateException illegalStateException = new IllegalStateException(String.valueOf(object));
            throw illegalStateException;
        }
    }

    @KeepForSdk
    public static void checkState(boolean bl, @RecentlyNonNull String string2, Object ... objectArray) {
        if (!bl) {
            IllegalStateException illegalStateException = new IllegalStateException(String.format(string2, objectArray));
            throw illegalStateException;
        }
    }

    @KeepForSdk
    public static void checkArgument(boolean bl, @RecentlyNonNull Object object) {
        if (!bl) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.valueOf(object));
            throw illegalArgumentException;
        }
    }

    @KeepForSdk
    public static void checkArgument(boolean bl, @RecentlyNonNull String string2, Object ... objectArray) {
        if (!bl) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format(string2, objectArray));
            throw illegalArgumentException;
        }
    }

    @KeepForSdk
    public static void checkArgument(boolean bl) {
        if (!bl) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            throw illegalArgumentException;
        }
    }

    private Preconditions() {
        Object object = new AssertionError((Object)"Uninstantiable");
        throw object;
    }

    @KeepForSdk
    public static void checkMainThread(@RecentlyNonNull String string2) {
        if (!zzb.zza()) {
            IllegalStateException illegalStateException = new IllegalStateException(string2);
            throw illegalStateException;
        }
    }

    @KeepForSdk
    public static void checkNotMainThread() {
        Preconditions.checkNotMainThread("Must not be called on the main application thread");
    }

    @KeepForSdk
    public static void checkNotMainThread(@RecentlyNonNull String string2) {
        if (zzb.zza()) {
            IllegalStateException illegalStateException = new IllegalStateException(string2);
            throw illegalStateException;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static void checkHandlerThread(@RecentlyNonNull Handler object) {
        void var1_4;
        Looper looper = Looper.myLooper();
        if (looper == object.getLooper()) {
            return;
        }
        if (looper != null) {
            String string2 = looper.getThread().getName();
        } else {
            String string3 = "null current looper";
        }
        String string4 = object.getLooper().getThread().getName();
        String string5 = String.valueOf(string4);
        int n = string5.length();
        String string6 = String.valueOf(var1_4);
        int n2 = string6.length();
        StringBuilder stringBuilder = new StringBuilder(n + 36 + n2);
        stringBuilder.append("Must be called on ");
        stringBuilder.append(string4);
        stringBuilder.append(" thread, but got ");
        stringBuilder.append((String)var1_4);
        stringBuilder.append(".");
        IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
        throw illegalStateException;
    }

    @KeepForSdk
    public static void checkHandlerThread(@RecentlyNonNull Handler object, @RecentlyNonNull String string2) {
        if (Looper.myLooper() != object.getLooper()) {
            object = new IllegalStateException(string2);
            throw object;
        }
    }
}

