/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ConnectionTelemetryConfiguration;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.RootTelemetryConfigManager;
import com.google.android.gms.common.internal.RootTelemetryConfiguration;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    @KeepForSdk
    @RecentlyNonNull
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    @KeepForSdk
    @RecentlyNonNull
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    @KeepForSdk
    @RecentlyNonNull
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES;
    private static final Feature[] zze;
    private int zzf;
    private long zzg;
    private long zzh;
    private int zzi;
    private long zzj;
    @Nullable
    private volatile String zzk;
    @VisibleForTesting
    zzt zza;
    private final Context zzl;
    private final Looper zzm;
    private final GmsClientSupervisor zzn;
    private final GoogleApiAvailabilityLight zzo;
    final Handler zzb;
    private final Object zzp;
    private final Object zzq;
    @GuardedBy(value="mServiceBrokerLock")
    @Nullable
    private IGmsServiceBroker zzr;
    @VisibleForTesting
    @RecentlyNonNull
    protected ConnectionProgressReportCallbacks zzc;
    @GuardedBy(value="mLock")
    @Nullable
    private T zzs;
    private final ArrayList<zzc<?>> zzt;
    @GuardedBy(value="mLock")
    @Nullable
    private zze zzu;
    @GuardedBy(value="mLock")
    private int zzv;
    @Nullable
    private final BaseConnectionCallbacks zzw;
    @Nullable
    private final BaseOnConnectionFailedListener zzx;
    private final int zzy;
    @Nullable
    private final String zzz;
    @Nullable
    private volatile String zzA;
    @Nullable
    private ConnectionResult zzB;
    private boolean zzC;
    @Nullable
    private volatile zzi zzD;
    @VisibleForTesting
    @RecentlyNonNull
    protected AtomicInteger zzd;

    @KeepForSdk
    protected BaseGmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, int n, @Nullable BaseConnectionCallbacks baseConnectionCallbacks, @Nullable BaseOnConnectionFailedListener baseOnConnectionFailedListener, @Nullable String string2) {
        GmsClientSupervisor gmsClientSupervisor = GmsClientSupervisor.getInstance(context);
        GoogleApiAvailabilityLight googleApiAvailabilityLight = GoogleApiAvailabilityLight.getInstance();
        Preconditions.checkNotNull(baseConnectionCallbacks);
        Preconditions.checkNotNull(baseOnConnectionFailedListener);
        this(context, looper, gmsClientSupervisor, googleApiAvailabilityLight, n, baseConnectionCallbacks, baseOnConnectionFailedListener, string2);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@RecentlyNonNull Context object, @RecentlyNonNull Looper looper, @RecentlyNonNull GmsClientSupervisor gmsClientSupervisor, @RecentlyNonNull GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, @Nullable BaseConnectionCallbacks baseConnectionCallbacks, @Nullable BaseOnConnectionFailedListener baseOnConnectionFailedListener, @Nullable String string2) {
        this.zzk = null;
        Serializable serializable = new Serializable();
        this.zzp = serializable;
        serializable = new Serializable();
        this.zzq = serializable;
        serializable = new Serializable();
        this.zzt = serializable;
        this.zzv = 1;
        this.zzB = null;
        this.zzC = false;
        this.zzD = null;
        super(0);
        this.zzd = serializable;
        Preconditions.checkNotNull(object, "Context must not be null");
        this.zzl = object;
        Preconditions.checkNotNull(looper, "Looper must not be null");
        this.zzm = looper;
        Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzn = gmsClientSupervisor;
        Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzo = googleApiAvailabilityLight;
        super(this, looper);
        this.zzb = object;
        this.zzy = n;
        this.zzw = baseConnectionCallbacks;
        this.zzx = baseOnConnectionFailedListener;
        this.zzz = string2;
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Handler handler, @RecentlyNonNull GmsClientSupervisor gmsClientSupervisor, @RecentlyNonNull GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, @Nullable BaseConnectionCallbacks baseConnectionCallbacks, @Nullable BaseOnConnectionFailedListener baseOnConnectionFailedListener) {
        this.zzk = null;
        Serializable serializable = new Serializable();
        this.zzp = serializable;
        serializable = new Serializable();
        this.zzq = serializable;
        serializable = new Serializable();
        this.zzt = serializable;
        this.zzv = 1;
        this.zzB = null;
        this.zzC = false;
        this.zzD = null;
        super(0);
        this.zzd = serializable;
        Preconditions.checkNotNull(context, "Context must not be null");
        this.zzl = context;
        Preconditions.checkNotNull(handler, "Handler must not be null");
        this.zzb = handler;
        this.zzm = handler.getLooper();
        Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzn = gmsClientSupervisor;
        Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzo = googleApiAvailabilityLight;
        this.zzy = n;
        this.zzw = baseConnectionCallbacks;
        this.zzx = baseOnConnectionFailedListener;
        this.zzz = null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    @RecentlyNonNull
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    @KeepForSdk
    public void setAttributionTag(@RecentlyNonNull String string2) {
        this.zzA = string2;
    }

    @RecentlyNullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    @RecentlyNullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        zzi zzi2 = ((BaseGmsClient)((Object)zzi2)).zzD;
        if (zzi2 == null) {
            return null;
        }
        return zzi2.zzb;
    }

    @RecentlyNullable
    @KeepForSdk
    public ConnectionTelemetryConfiguration getTelemetryConfiguration() {
        zzi zzi2 = ((BaseGmsClient)((Object)zzi2)).zzD;
        if (zzi2 == null) {
            return null;
        }
        return zzi2.zzd;
    }

    @KeepForSdk
    public boolean hasConnectionInfo() {
        return this.zzD != null;
    }

    @KeepForSdk
    public int getGCoreServiceId() {
        return this.zzy;
    }

    @RecentlyNullable
    @KeepForSdk
    protected abstract T createServiceInterface(@RecentlyNonNull IBinder var1);

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@RecentlyNonNull T t) {
        this.zzh = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(int n) {
        this.zzf = n;
        this.zzg = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(@RecentlyNonNull ConnectionResult connectionResult) {
        this.zzi = connectionResult.getErrorCode();
        this.zzj = System.currentTimeMillis();
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzo.isGooglePlayServicesAvailable(this.zzl, this.getMinApkVersion());
        if (n != 0) {
            this.zzp(1, null);
            LegacyClientCallbackAdapter legacyClientCallbackAdapter = new LegacyClientCallbackAdapter();
            this.triggerNotAvailable(legacyClientCallbackAdapter, n, null);
            return;
        }
        LegacyClientCallbackAdapter legacyClientCallbackAdapter = new LegacyClientCallbackAdapter();
        this.connect(legacyClientCallbackAdapter);
    }

    @KeepForSdk
    public void connect(@RecentlyNonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zzc = connectionProgressReportCallbacks;
        this.zzp(2, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isConnected() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl = this.zzv;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public boolean isConnecting() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl = this.zzv;
            if (bl) return true;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    public void disconnect(@RecentlyNonNull String string2) {
        this.zzk = string2;
        this.disconnect();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void disconnect() {
        this.zzd.incrementAndGet();
        ArrayList<zzc<?>> arrayList = this.zzt;
        synchronized (arrayList) {
            int n = this.zzt.size();
            for (int i = 0; i < n; ++i) {
                this.zzt.get(i).zzg();
            }
            this.zzt.clear();
        }
        Object object = this.zzq;
        synchronized (object) {
            this.zzr = null;
            // MONITOREXIT @DISABLED, blocks:[2, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var1_5
            this.zzp(1, null);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @RecentlyNullable
    public String getLastDisconnectMessage() {
        return this.zzk;
    }

    @KeepForSdk
    public void triggerConnectionSuspended(int n) {
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(6, this.zzd.get(), n));
    }

    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@RecentlyNonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks, int n, @Nullable PendingIntent pendingIntent) {
        Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zzc = connectionProgressReportCallbacks;
        connectionProgressReportCallbacks = this.zzb;
        connectionProgressReportCallbacks.sendMessage(connectionProgressReportCallbacks.obtainMessage(3, this.zzd.get(), n, pendingIntent));
    }

    @KeepForSdk
    @RecentlyNonNull
    public final Context getContext() {
        return this.zzl;
    }

    @KeepForSdk
    @RecentlyNonNull
    public final Looper getLooper() {
        return this.zzm;
    }

    @KeepForSdk
    @RecentlyNullable
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Feature[] getApiFeatures() {
        return zze;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected Bundle getGetServiceRequestExtraArgs() {
        BaseGmsClient baseGmsClient = new Bundle();
        return baseGmsClient;
    }

    @KeepForSdk
    protected void onPostInitHandler(int n, @Nullable IBinder iBinder, @Nullable Bundle bundle, int n2) {
        Handler handler = this.zzb;
        zzf zzf2 = new zzf(this, n, iBinder, bundle);
        handler.sendMessage(handler.obtainMessage(1, n2, -1, (Object)zzf2));
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!((BaseGmsClient)object).isConnected()) {
            Object object = new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
            throw object;
        }
    }

    @KeepForSdk
    @RecentlyNullable
    public Bundle getConnectionHint() {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @RecentlyNonNull
    public final T getService() throws DeadObjectException {
        Object object = baseGmsClient.zzp;
        synchronized (object) {
            BaseGmsClient<T> baseGmsClient;
            int n = baseGmsClient.zzv;
            if (n == 5) {
                baseGmsClient = new DeadObjectException();
                throw baseGmsClient;
            }
            baseGmsClient.checkConnected();
            baseGmsClient = baseGmsClient.zzs;
            Preconditions.checkNotNull(baseGmsClient, "Client is connected but service is null");
            return (T)baseGmsClient;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(@Nullable IAccountAccessor object, @RecentlyNonNull Set<Scope> object2) {
        block15: {
            Object object3 = this.getGetServiceRequestExtraArgs();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzy, this.zzA);
            getServiceRequest.zzd = this.zzl.getPackageName();
            getServiceRequest.zzg = object3;
            if (object2 != null) {
                getServiceRequest.zzf = object2.toArray(new Scope[object2.size()]);
            }
            if (this.requiresSignIn()) {
                object2 = this.getAccount();
                if (object2 == null) {
                    object2 = new Account(DEFAULT_ACCOUNT, "com.google");
                }
                getServiceRequest.zzh = object2;
                if (object != null) {
                    getServiceRequest.zze = object.asBinder();
                }
            } else if (this.requiresAccount()) {
                getServiceRequest.zzh = this.getAccount();
            }
            getServiceRequest.zzi = zze;
            getServiceRequest.zzj = this.getApiFeatures();
            if (this.usesClientTelemetry()) {
                getServiceRequest.zzm = true;
            }
            try {
                object = this.zzq;
                // MONITORENTER : object
                object2 = this.zzr;
                if (object2 == null) break block15;
            }
            catch (DeadObjectException deadObjectException) {
                Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
                this.triggerConnectionSuspended(3);
                return;
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (RemoteException | RuntimeException throwable) {
                Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
                this.onPostInitHandler(8, null, null, this.zzd.get());
                return;
            }
            object3 = new zzd(this, this.zzd.get());
            object2.getService((IGmsCallbacks)object3, getServiceRequest);
            // MONITOREXIT : object
            return;
        }
        Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
        return;
    }

    @KeepForSdk
    protected boolean enableLocalFallback() {
        return false;
    }

    @KeepForSdk
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public void onUserSignOut(@RecentlyNonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    @KeepForSdk
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Intent getSignInIntent() {
        Object object = new UnsupportedOperationException("Not a sign in API");
        throw object;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected Set<Scope> getScopes() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public void dump(@RecentlyNonNull String object, @RecentlyNonNull FileDescriptor object2, @RecentlyNonNull PrintWriter appendable, @RecentlyNonNull String[] stringArray) {
        StringBuilder stringBuilder;
        long l;
        object2 = ((BaseGmsClient)object5).zzp;
        // MONITORENTER : object2
        int n = ((BaseGmsClient)object5).zzv;
        Object object3 = ((BaseGmsClient)object5).zzs;
        // MONITOREXIT : object2
        object2 = ((BaseGmsClient)object5).zzq;
        // MONITORENTER : object2
        Object object4 = ((BaseGmsClient)object5).zzr;
        // MONITOREXIT : object2
        ((PrintWriter)appendable).append((CharSequence)object).append("mConnectState=");
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object2
                throw throwable;
            }
        }
        switch (n) {
            default: {
                ((PrintWriter)appendable).print("UNKNOWN");
                break;
            }
            case 5: {
                ((PrintWriter)appendable).print("DISCONNECTING");
                break;
            }
            case 4: {
                ((PrintWriter)appendable).print("CONNECTED");
                break;
            }
            case 3: {
                ((PrintWriter)appendable).print("LOCAL_CONNECTING");
                break;
            }
            case 2: {
                ((PrintWriter)appendable).print("REMOTE_CONNECTING");
                break;
            }
            case 1: {
                ((PrintWriter)appendable).print("DISCONNECTED");
            }
        }
        ((PrintWriter)appendable).append(" mService=");
        if (object3 == null) {
            ((PrintWriter)appendable).append("null");
        } else {
            ((PrintWriter)appendable).append(((BaseGmsClient)object5).getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(object3.asBinder())));
        }
        ((PrintWriter)appendable).append(" mServiceBroker=");
        if (object4 == null) {
            ((PrintWriter)appendable).println("null");
        } else {
            ((PrintWriter)appendable).append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(object4.asBinder())));
        }
        object2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (((BaseGmsClient)object5).zzh > 0L) {
            PrintWriter printWriter = ((PrintWriter)appendable).append((CharSequence)object);
            printWriter = printWriter.append("lastConnectedTime=");
            l = ((BaseGmsClient)object5).zzh;
            object3 = new Object(l);
            object3 = ((DateFormat)object2).format((Date)object3);
            object4 = String.valueOf(object3);
            int n2 = ((String)object4).length();
            stringBuilder = new StringBuilder(n2 + 21);
            stringBuilder.append(l);
            stringBuilder.append(" ");
            stringBuilder.append((String)object3);
            printWriter.println(stringBuilder.toString());
        }
        if (((BaseGmsClient)object5).zzg > 0L) {
            ((PrintWriter)appendable).append((CharSequence)object).append("lastSuspendedCause=");
            int n3 = ((BaseGmsClient)object5).zzf;
            switch (n3) {
                default: {
                    ((PrintWriter)appendable).append(String.valueOf(n3));
                    break;
                }
                case 3: {
                    ((PrintWriter)appendable).append("CAUSE_DEAD_OBJECT_EXCEPTION");
                    break;
                }
                case 2: {
                    ((PrintWriter)appendable).append("CAUSE_NETWORK_LOST");
                    break;
                }
                case 1: {
                    ((PrintWriter)appendable).append("CAUSE_SERVICE_DISCONNECTED");
                }
            }
            PrintWriter printWriter = ((PrintWriter)appendable).append(" lastSuspendedTime=");
            l = ((BaseGmsClient)object5).zzg;
            object3 = new Object(l);
            object3 = ((DateFormat)object2).format((Date)object3);
            object4 = String.valueOf(object3);
            int n4 = ((String)object4).length();
            stringBuilder = new StringBuilder(n4 + 21);
            stringBuilder.append(l);
            stringBuilder.append(" ");
            stringBuilder.append((String)object3);
            printWriter.println(stringBuilder.toString());
        }
        if (((BaseGmsClient)object5).zzj <= 0L) return;
        ((PrintWriter)appendable).append((CharSequence)object).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(((BaseGmsClient)object5).zzi));
        object = ((PrintWriter)appendable).append(" lastFailedTime=");
        l = ((BaseGmsClient)object5).zzj;
        Object object5 = new Date(l);
        object5 = ((DateFormat)object2).format((Date)object5);
        object2 = String.valueOf(object5);
        int n5 = ((String)object2).length();
        appendable = new StringBuilder(n5 + 21);
        ((StringBuilder)appendable).append(l);
        ((StringBuilder)appendable).append(" ");
        ((StringBuilder)appendable).append((String)object5);
        ((PrintWriter)object).println(((StringBuilder)appendable).toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = ((BaseGmsClient)((Object)iGmsServiceBroker)).zzq;
        synchronized (object) {
            IGmsServiceBroker iGmsServiceBroker = ((BaseGmsClient)((Object)iGmsServiceBroker)).zzr;
            if (iGmsServiceBroker != null) return iGmsServiceBroker.asBinder();
            return null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getEndpointPackageName() {
        if (!((BaseGmsClient)object).isConnected() || (object = ((BaseGmsClient)object).zza) == null) {
            Object object = new RuntimeException("Failed to connect when checking package");
            throw object;
        }
        return ((zzt)object).zzb();
    }

    @KeepForSdk
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @KeepForSdk
    protected boolean getUseDynamicLookup() {
        return false;
    }

    @KeepForSdk
    public boolean usesClientTelemetry() {
        return false;
    }

    static {
        zze = new Feature[0];
        String[] stringArray = new String[]{"service_esmobile", "service_googleme"};
        GOOGLE_PLUS_REQUIRED_FEATURES = stringArray;
    }

    @RecentlyNonNull
    protected final String zza() {
        String string2 = this.zzz;
        if (string2 == null) {
            return this.zzl.getClass().getName();
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzp(int var1_1, @Nullable T var2_11) {
        var3_12 = var1_1 != 4 ? 0 : 1;
        var4_14 = var2_11 == null ? 0 : 1;
        var3_12 = var3_12 == var4_14 ? 1 : 0;
        Preconditions.checkArgument((boolean)var3_12);
        var3_13 = this.zzp;
        synchronized (var3_13) {
            block14: {
                this.zzv = var1_1;
                this.zzs = var2_11;
                switch (var1_1) {
                    case 2: 
                    case 3: {
                        var1_2 = this.zzu;
                        if (var1_2 != null && (var2_11 = this.zza) != null) {
                            var4_15 = "GmsClient";
                            var2_11 = var2_11.zza();
                            var5_18 = this.zza.zzb();
                            var6_20 = String.valueOf(var2_11).length();
                            var6_20 += 70;
                            var7_22 = String.valueOf(var5_18).length();
                            var7_23 /* !! */  = new StringBuilder(var6_20 += var7_22);
                            var7_23 /* !! */ .append("Calling connect() while still connected, missing disconnect() for ");
                            var7_23 /* !! */ .append((String)var2_11);
                            var7_23 /* !! */ .append(" on ");
                            var7_23 /* !! */ .append(var5_18);
                            Log.e((String)var4_15, (String)var7_23 /* !! */ .toString());
                            var2_11 = this.zzn;
                            var4_15 = this.zza.zza();
                            Preconditions.checkNotNull(var4_15);
                            var2_11.zza(var4_15, this.zza.zzb(), this.zza.zzc(), var1_2, this.zza(), this.zza.zzd());
                            this.zzd.incrementAndGet();
                        }
                        this.zzu = var2_11 = new zze((BaseGmsClient)this, this.zzd.get());
                        var1_3 = this.zzv;
                        var1_4 = var1_3 == 3 && (var1_4 = this.getLocalStartServiceAction()) != null ? new zzt(this.getContext().getPackageName(), this.getLocalStartServiceAction(), true, GmsClientSupervisor.getDefaultBindFlags(), false) : new zzt(this.getStartServicePackage(), this.getStartServiceAction(), false, GmsClientSupervisor.getDefaultBindFlags(), this.getUseDynamicLookup());
                        this.zza = var1_4;
                        var1_5 = this.zza.zzd();
                        if (var1_5 != 0 && (var1_5 = this.getMinApkVersion()) < 17895000) {
                            var2_11 = "Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: ";
                            this = String.valueOf(this.zza.zza());
                            var4_14 = this.length();
                            this = var4_14 != 0 ? var2_11.concat((String)this) : new String((String)var2_11);
                        }
                        var1_7 = this.zzn;
                        var4_16 = this.zza.zza();
                        Preconditions.checkNotNull(var4_16);
                        var5_18 = this.zza.zzb();
                        var6_20 = this.zza.zzc();
                        var7_23 /* !! */  = this.zza();
                        var8_24 = this.zza.zzd();
                        var9_25 = new zzm(var4_16, var5_18, var6_20, var8_24);
                        var1_8 = var1_7.zzb(var9_25, (ServiceConnection)var2_11, (String)var7_23 /* !! */ );
                        if (!var1_8) {
                            var1_9 = "GmsClient";
                            var2_11 = this.zza.zza();
                            var4_16 = this.zza.zzb();
                            var5_19 = String.valueOf(var2_11).length();
                            var5_19 += 34;
                            var6_20 = String.valueOf(var4_16).length();
                            var6_21 = new StringBuilder(var5_19 += var6_20);
                            var6_21.append("unable to connect to service: ");
                            var6_21.append((String)var2_11);
                            var6_21.append(" on ");
                            var6_21.append(var4_16);
                            Log.e((String)var1_9, (String)var6_21.toString());
                            this.zzb(16, null, this.zzd.get());
                            ** break;
                        }
                        ** GOTO lbl87
                    }
                    case 1: {
                        var1_10 = this.zzu;
                        if (var1_10 != null) {
                            var2_11 = this.zzn;
                            var4_17 = this.zza.zza();
                            Preconditions.checkNotNull(var4_17);
                            var2_11.zza(var4_17, this.zza.zzb(), this.zza.zzc(), var1_10, this.zza(), this.zza.zzd());
                            this.zzu = null;
                        }
                    }
lbl87:
                    // 6 sources

                    default: {
                        break block14;
                    }
                    case 4: 
                }
                Preconditions.checkNotNull(var2_11);
                this.onConnectedLocked(var2_11);
            }
            return;
            var1_6 = new IllegalStateException((String)this);
            throw var1_6;
        }
    }

    protected final void zzb(int n, @Nullable Bundle bundle, int n2) {
        bundle = this.zzb;
        zzg zzg2 = new zzg(this, n, null);
        bundle.sendMessage(bundle.obtainMessage(7, n2, -1, (Object)zzg2));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ void zzc(BaseGmsClient baseGmsClient, int n) {
        int n2;
        block6: {
            Object object = baseGmsClient.zzp;
            synchronized (object) {
                int n3 = baseGmsClient.zzv;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl5 : MonitorExitStatement: MONITOREXIT : var1_3
                if (n3 == 3) {
                    baseGmsClient.zzC = true;
                    n2 = 5;
                    break block6;
                } else {
                    n2 = 4;
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        Handler handler = baseGmsClient.zzb;
        handler.sendMessage(handler.obtainMessage(n2, baseGmsClient.zzd.get(), 16));
    }

    static /* synthetic */ Object zzd(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzq;
    }

    static /* synthetic */ IGmsServiceBroker zze(BaseGmsClient baseGmsClient, IGmsServiceBroker iGmsServiceBroker) {
        baseGmsClient.zzr = iGmsServiceBroker;
        return iGmsServiceBroker;
    }

    static /* synthetic */ ConnectionResult zzf(BaseGmsClient baseGmsClient, ConnectionResult connectionResult) {
        baseGmsClient.zzB = connectionResult;
        return connectionResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ boolean zzg(BaseGmsClient baseGmsClient) {
        if (baseGmsClient.zzC) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)baseGmsClient.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)baseGmsClient.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(baseGmsClient.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ boolean zzh(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzC;
    }

    static /* synthetic */ void zzi(BaseGmsClient baseGmsClient, int n, IInterface iInterface) {
        baseGmsClient.zzp(n, null);
    }

    static /* synthetic */ ConnectionResult zzj(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzB;
    }

    static /* synthetic */ BaseConnectionCallbacks zzk(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzw;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ boolean zzl(BaseGmsClient baseGmsClient, int n, int n2, IInterface iInterface) {
        Object object = baseGmsClient.zzp;
        synchronized (object) {
            int n3 = baseGmsClient.zzv;
            if (n3 != n) {
                return false;
            }
            baseGmsClient.zzp(n2, iInterface);
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static /* synthetic */ ArrayList zzm(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzt;
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ void zzo(BaseGmsClient object, zzi object2) {
        ((BaseGmsClient)object).zzD = object2;
        if (!((BaseGmsClient)object).usesClientTelemetry()) {
            return;
        }
        object = ((zzi)object2).zzd;
        object2 = RootTelemetryConfigManager.getInstance();
        object = object == null ? null : ((ConnectionTelemetryConfiguration)object).getRootTelemetryConfiguration();
        ((RootTelemetryConfigManager)object2).zza((RootTelemetryConfiguration)object);
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        @KeepForSdk
        public LegacyClientCallbackAdapter() {
        }

        @Override
        public final void onReportServiceBinding(@RecentlyNonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient baseGmsClient = ((LegacyClientCallbackAdapter)((Object)baseGmsClient)).BaseGmsClient.this;
                baseGmsClient.getRemoteService(null, baseGmsClient.getScopes());
                return;
            }
            if (((LegacyClientCallbackAdapter)((Object)baseGmsClient)).BaseGmsClient.this.zzx != null) {
                ((LegacyClientCallbackAdapter)((Object)baseGmsClient)).BaseGmsClient.this.zzx.onConnectionFailed(connectionResult);
                return;
            }
        }
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@RecentlyNonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        @KeepForSdk
        public void onConnectionFailed(@RecentlyNonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        @KeepForSdk
        public static final int CAUSE_DEAD_OBJECT_EXCEPTION = 3;

        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(int var1);
    }
}

