/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@KeepForSdk
public class BlockingServiceConnection
implements ServiceConnection {
    boolean zza = false;
    private final BlockingQueue<IBinder> zzb;

    public BlockingServiceConnection() {
        LinkedBlockingQueue<IBinder> linkedBlockingQueue = new LinkedBlockingQueue<IBinder>();
        this.zzb = linkedBlockingQueue;
    }

    public final void onServiceConnected(@RecentlyNonNull ComponentName componentName, @RecentlyNonNull IBinder iBinder) {
        this.zzb.add(iBinder);
    }

    public final void onServiceDisconnected(@RecentlyNonNull ComponentName componentName) {
    }

    @KeepForSdk
    @RecentlyNonNull
    public IBinder getServiceWithTimeout(long l, @RecentlyNonNull TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        Object object;
        Preconditions.checkNotMainThread("BlockingServiceConnection.getServiceWithTimeout() called on main thread");
        if (((BlockingServiceConnection)object).zza) {
            object = new IllegalStateException("Cannot call get on this connection more than once");
            throw object;
        }
        ((BlockingServiceConnection)object).zza = true;
        object = ((BlockingServiceConnection)object).zzb.poll(l, timeUnit);
        if (object == null) {
            object = new TimeoutException("Timed out waiting for the service connection");
            throw object;
        }
        return object;
    }

    @KeepForSdk
    @RecentlyNonNull
    public IBinder getService() throws InterruptedException {
        Preconditions.checkNotMainThread("BlockingServiceConnection.getService() called on main thread");
        if (((BlockingServiceConnection)object).zza) {
            Object object = new IllegalStateException("Cannot call get on this connection more than once");
            throw object;
        }
        ((BlockingServiceConnection)object).zza = true;
        return ((BlockingServiceConnection)object).zzb.take();
    }
}

