/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.accounts.Account;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.zza;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class AccountPicker {
    private AccountPicker() {
    }

    @Deprecated
    @RecentlyNonNull
    public static Intent newChooseAccountIntent(@Nullable Account account, @Nullable ArrayList<Account> arrayList, @Nullable String[] stringArray, boolean bl, @Nullable String string, @Nullable String string2, @Nullable String[] stringArray2, @Nullable Bundle bundle) {
        Intent intent = new Intent();
        Preconditions.checkArgument(true, "We only support hostedDomain filter for account chip styled account picker");
        intent.setAction("com.google.android.gms.common.account.CHOOSE_ACCOUNT");
        intent.setPackage("com.google.android.gms");
        intent.putExtra("allowableAccounts", arrayList);
        intent.putExtra("allowableAccountTypes", stringArray);
        intent.putExtra("addAccountOptions", bundle);
        intent.putExtra("selectedAccount", (Parcelable)account);
        intent.putExtra("alwaysPromptForAccount", bl);
        intent.putExtra("descriptionTextOverride", string);
        intent.putExtra("authTokenType", string2);
        intent.putExtra("addAccountRequiredFeatures", stringArray2);
        intent.putExtra("setGmsCoreAccount", false);
        intent.putExtra("overrideTheme", 0);
        intent.putExtra("overrideCustomTheme", 0);
        intent.putExtra("hostedDomainFilter", null);
        return intent;
    }

    @RecentlyNonNull
    public static Intent newChooseAccountIntent(@RecentlyNonNull AccountChooserOptions accountChooserOptions) {
        Intent intent = new Intent();
        AccountChooserOptions.zza(accountChooserOptions);
        AccountChooserOptions.zzb(accountChooserOptions);
        Preconditions.checkArgument(true, "We only support hostedDomain filter for account chip styled account picker");
        AccountChooserOptions.zzc(accountChooserOptions);
        Preconditions.checkArgument(true, "Consent is only valid for account chip styled account picker");
        AccountChooserOptions.zzd(accountChooserOptions);
        Preconditions.checkArgument(true, "Making the selected account non-clickable is only supported for the theme THEME_DAY_NIGHT_GOOGLE_MATERIAL2");
        AccountChooserOptions.zza(accountChooserOptions);
        intent.setAction("com.google.android.gms.common.account.CHOOSE_ACCOUNT");
        intent.setPackage("com.google.android.gms");
        intent.putExtra("allowableAccounts", (Serializable)accountChooserOptions.zzc);
        if (accountChooserOptions.zzd != null) {
            intent.putExtra("allowableAccountTypes", accountChooserOptions.zzd.toArray(new String[0]));
        }
        intent.putExtra("addAccountOptions", accountChooserOptions.zzg);
        intent.putExtra("selectedAccount", (Parcelable)accountChooserOptions.zza);
        AccountChooserOptions.zzd(accountChooserOptions);
        intent.putExtra("selectedAccountIsNotClickable", false);
        intent.putExtra("alwaysPromptForAccount", accountChooserOptions.zze);
        intent.putExtra("descriptionTextOverride", accountChooserOptions.zzf);
        AccountChooserOptions.zzl(accountChooserOptions);
        intent.putExtra("setGmsCoreAccount", false);
        AccountChooserOptions.zzm(accountChooserOptions);
        intent.putExtra("realClientPackage", null);
        AccountChooserOptions.zze(accountChooserOptions);
        intent.putExtra("overrideTheme", 0);
        AccountChooserOptions.zza(accountChooserOptions);
        intent.putExtra("overrideCustomTheme", 0);
        AccountChooserOptions.zzb(accountChooserOptions);
        intent.putExtra("hostedDomainFilter", null);
        Bundle bundle = new Bundle();
        AccountChooserOptions.zza(accountChooserOptions);
        AccountChooserOptions.zzc(accountChooserOptions);
        AccountChooserOptions.zzn(accountChooserOptions);
        AccountChooserOptions.zzo(accountChooserOptions);
        if (!bundle.isEmpty()) {
            intent.putExtra("first_party_options_bundle", bundle);
        }
        return intent;
    }

    public static class AccountChooserOptions {
        @Nullable
        private Account zza;
        private boolean zzb;
        @Nullable
        private ArrayList<Account> zzc;
        @Nullable
        private ArrayList<String> zzd;
        private boolean zze;
        @Nullable
        private String zzf;
        @Nullable
        private Bundle zzg;
        private boolean zzh;
        private int zzi;
        @Nullable
        private String zzj;
        private boolean zzk;
        @Nullable
        private zza zzl;
        @Nullable
        private String zzm;
        private boolean zzn;
        private boolean zzo;

        static /* synthetic */ boolean zza(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzk;
            return false;
        }

        static /* synthetic */ String zzb(AccountChooserOptions accountChooserOptions) {
            String cfr_ignored_0 = accountChooserOptions.zzj;
            return null;
        }

        static /* synthetic */ zza zzc(AccountChooserOptions accountChooserOptions) {
            zza cfr_ignored_0 = accountChooserOptions.zzl;
            return null;
        }

        static /* synthetic */ boolean zzd(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzb;
            return false;
        }

        static /* synthetic */ int zze(AccountChooserOptions accountChooserOptions) {
            int cfr_ignored_0 = accountChooserOptions.zzi;
            return 0;
        }

        static /* synthetic */ boolean zzl(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzh;
            return false;
        }

        static /* synthetic */ String zzm(AccountChooserOptions accountChooserOptions) {
            String cfr_ignored_0 = accountChooserOptions.zzm;
            return null;
        }

        static /* synthetic */ boolean zzn(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzn;
            return false;
        }

        static /* synthetic */ boolean zzo(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzo;
            return false;
        }

        static /* synthetic */ ArrayList zzp(AccountChooserOptions accountChooserOptions, ArrayList arrayList) {
            accountChooserOptions.zzd = arrayList;
            return arrayList;
        }

        static /* synthetic */ ArrayList zzq(AccountChooserOptions accountChooserOptions, ArrayList arrayList) {
            accountChooserOptions.zzc = arrayList;
            return arrayList;
        }

        static /* synthetic */ boolean zzr(AccountChooserOptions accountChooserOptions, boolean bl) {
            accountChooserOptions.zze = bl;
            return bl;
        }

        static /* synthetic */ zza zzs(AccountChooserOptions accountChooserOptions, zza zza2) {
            accountChooserOptions.zzl = null;
            return null;
        }

        static /* synthetic */ String zzt(AccountChooserOptions accountChooserOptions, String string) {
            accountChooserOptions.zzj = null;
            return null;
        }

        static /* synthetic */ Bundle zzu(AccountChooserOptions accountChooserOptions, Bundle bundle) {
            accountChooserOptions.zzg = bundle;
            return bundle;
        }

        static /* synthetic */ Account zzv(AccountChooserOptions accountChooserOptions, Account account) {
            accountChooserOptions.zza = account;
            return account;
        }

        static /* synthetic */ boolean zzw(AccountChooserOptions accountChooserOptions, boolean bl) {
            accountChooserOptions.zzb = false;
            return false;
        }

        static /* synthetic */ boolean zzx(AccountChooserOptions accountChooserOptions, boolean bl) {
            accountChooserOptions.zzh = false;
            return false;
        }

        static /* synthetic */ String zzy(AccountChooserOptions accountChooserOptions, String string) {
            accountChooserOptions.zzm = null;
            return null;
        }

        static /* synthetic */ int zzz(AccountChooserOptions accountChooserOptions, int n) {
            accountChooserOptions.zzi = 0;
            return 0;
        }

        static /* synthetic */ String zzA(AccountChooserOptions accountChooserOptions, String string) {
            accountChooserOptions.zzf = string;
            return string;
        }

        static /* synthetic */ boolean zzB(AccountChooserOptions accountChooserOptions, boolean bl) {
            accountChooserOptions.zzk = false;
            return false;
        }

        static /* synthetic */ boolean zzC(AccountChooserOptions accountChooserOptions, boolean bl) {
            accountChooserOptions.zzn = false;
            return false;
        }

        static /* synthetic */ boolean zzD(AccountChooserOptions accountChooserOptions, boolean bl) {
            accountChooserOptions.zzo = false;
            return false;
        }

        public static class Builder {
            @Nullable
            private Account zza;
            @Nullable
            private ArrayList<Account> zzb;
            @Nullable
            private ArrayList<String> zzc;
            private boolean zzd = false;
            @Nullable
            private String zze;
            @Nullable
            private Bundle zzf;

            @RecentlyNonNull
            public Builder setSelectedAccount(@Nullable Account account) {
                this.zza = account;
                return this;
            }

            /*
             * Enabled aggressive block sorting
             */
            @RecentlyNonNull
            public Builder setAllowableAccounts(@Nullable List<Account> list) {
                if (list == null) {
                    list = null;
                } else {
                    ArrayList<Account> arrayList = new ArrayList<Account>(list);
                    list = arrayList;
                }
                this.zzb = list;
                return this;
            }

            /*
             * Enabled aggressive block sorting
             */
            @RecentlyNonNull
            public Builder setAllowableAccountsTypes(@Nullable List<String> list) {
                if (list == null) {
                    list = null;
                } else {
                    ArrayList<String> arrayList = new ArrayList<String>(list);
                    list = arrayList;
                }
                this.zzc = list;
                return this;
            }

            @RecentlyNonNull
            public Builder setAlwaysShowAccountPicker(boolean bl) {
                this.zzd = bl;
                return this;
            }

            @RecentlyNonNull
            public Builder setTitleOverrideText(@Nullable String string) {
                this.zze = string;
                return this;
            }

            @RecentlyNonNull
            public Builder setOptionsForAddingAccount(@Nullable Bundle bundle) {
                this.zzf = bundle;
                return this;
            }

            @RecentlyNonNull
            public AccountChooserOptions build() {
                Preconditions.checkArgument(true, "We only support hostedDomain filter for account chip styled account picker");
                Preconditions.checkArgument(true, "Consent is only valid for account chip styled account picker");
                AccountChooserOptions accountChooserOptions = new AccountChooserOptions();
                AccountChooserOptions.zzp(accountChooserOptions, this.zzc);
                AccountChooserOptions.zzq(accountChooserOptions, this.zzb);
                AccountChooserOptions.zzr(accountChooserOptions, this.zzd);
                AccountChooserOptions.zzs(accountChooserOptions, null);
                AccountChooserOptions.zzt(accountChooserOptions, null);
                AccountChooserOptions.zzu(accountChooserOptions, this.zzf);
                AccountChooserOptions.zzv(accountChooserOptions, this.zza);
                AccountChooserOptions.zzw(accountChooserOptions, false);
                AccountChooserOptions.zzx(accountChooserOptions, false);
                AccountChooserOptions.zzy(accountChooserOptions, null);
                AccountChooserOptions.zzz(accountChooserOptions, 0);
                AccountChooserOptions.zzA(accountChooserOptions, this.zze);
                AccountChooserOptions.zzB(accountChooserOptions, false);
                AccountChooserOptions.zzC(accountChooserOptions, false);
                AccountChooserOptions.zzD(accountChooserOptions, false);
                return accountChooserOptions;
            }
        }
    }
}

