/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzg;

@KeepForSdk
public abstract class GmsClientSupervisor {
    private static int zza = 4225;
    private static final Object zzb = new Object();
    private static GmsClientSupervisor zzc;

    @KeepForSdk
    public static int getDefaultBindFlags() {
        return zza;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public static GmsClientSupervisor getInstance(@RecentlyNonNull Context context) {
        Object object = zzb;
        synchronized (object) {
            if (zzc == null) {
                zzc = new zzg(context.getApplicationContext());
            }
        }
        return zzc;
    }

    @KeepForSdk
    public boolean bindService(@RecentlyNonNull String string2, @RecentlyNonNull ServiceConnection serviceConnection, @RecentlyNonNull String string3) {
        return this.zza(new zza(string2, GmsClientSupervisor.getDefaultBindFlags()), serviceConnection, string3);
    }

    @KeepForSdk
    public boolean bindService(@RecentlyNonNull ComponentName componentName, @RecentlyNonNull ServiceConnection serviceConnection, @RecentlyNonNull String string2) {
        return this.zza(new zza(componentName, GmsClientSupervisor.getDefaultBindFlags()), serviceConnection, string2);
    }

    @KeepForSdk
    public void unbindService(@RecentlyNonNull String string2, @RecentlyNonNull ServiceConnection serviceConnection, @RecentlyNonNull String string3) {
        this.zzb(new zza(string2, GmsClientSupervisor.getDefaultBindFlags()), serviceConnection, string3);
    }

    public final void zza(@RecentlyNonNull String string2, @RecentlyNonNull String string3, int n, @RecentlyNonNull ServiceConnection serviceConnection, @RecentlyNonNull String string4, boolean bl) {
        this.zzb(new zza(string2, string3, n, bl), serviceConnection, string4);
    }

    @KeepForSdk
    public void unbindService(@RecentlyNonNull ComponentName componentName, @RecentlyNonNull ServiceConnection serviceConnection, @RecentlyNonNull String string2) {
        this.zzb(new zza(componentName, GmsClientSupervisor.getDefaultBindFlags()), serviceConnection, string2);
    }

    protected abstract boolean zza(zza var1, ServiceConnection var2, String var3);

    protected abstract void zzb(zza var1, ServiceConnection var2, String var3);

    protected static final class zza {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final ComponentName zzc;
        private final int zzd;
        private final boolean zze;
        private static final Uri zzf = new Uri.Builder().scheme("content").authority("com.google.android.gms.chimera").build();

        public zza(String string2, int n) {
            this(string2, "com.google.android.gms", n);
        }

        private zza(String string2, String string3, int n) {
            this(string2, string3, n, false);
        }

        public zza(String string2, String string3, int n, boolean bl) {
            this.zza = Preconditions.checkNotEmpty(string2);
            this.zzb = Preconditions.checkNotEmpty(string3);
            this.zzc = null;
            this.zzd = n;
            this.zze = bl;
        }

        public zza(ComponentName componentName, int n) {
            this.zza = null;
            this.zzb = null;
            this.zzc = Preconditions.checkNotNull(componentName);
            this.zzd = n;
            this.zze = false;
        }

        public final String toString() {
            if (this.zza == null) {
                Preconditions.checkNotNull(this.zzc);
                return this.zzc.flattenToString();
            }
            return this.zza;
        }

        @Nullable
        public final String zza() {
            return this.zzb;
        }

        @Nullable
        public final ComponentName zzb() {
            return this.zzc;
        }

        public final int zzc() {
            return this.zzd;
        }

        public final Intent zza(Context context) {
            Intent intent = null;
            if (this.zza != null) {
                if (this.zze) {
                    intent = this.zzb(context);
                }
                if (intent == null) {
                    intent = new Intent(this.zza).setPackage(this.zzb);
                }
            } else {
                intent = new Intent().setComponent(this.zzc);
            }
            return intent;
        }

        @Nullable
        private final Intent zzb(Context context) {
            Intent intent;
            Bundle bundle = new Bundle();
            bundle.putString("serviceActionBundleKey", this.zza);
            Bundle bundle2 = null;
            try {
                bundle2 = context.getContentResolver().call(zzf, "serviceIntentCall", null, bundle);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = String.valueOf(illegalArgumentException);
                Log.w((String)"ConnectionStatusConfig", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("Dynamic intent resolution failed: ").append(string2).toString());
            }
            if ((intent = bundle2 == null ? null : (Intent)bundle2.getParcelable("serviceResponseIntentKey")) == null) {
                String string3 = String.valueOf(this.zza);
                Log.w((String)"ConnectionStatusConfig", (String)(string3.length() != 0 ? "Dynamic lookup for intent failed for action: ".concat(string3) : new String("Dynamic lookup for intent failed for action: ")));
            }
            return intent;
        }

        public final int hashCode() {
            return Objects.hashCode(this.zza, this.zzb, this.zzc, this.zzd, this.zze);
        }

        public final boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return Objects.equal(this.zza, zza2.zza) && Objects.equal(this.zzb, zza2.zzb) && Objects.equal(this.zzc, zza2.zzc) && this.zzd == zza2.zzd && this.zze == zza2.zze;
        }
    }
}

