/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.R;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.util.VisibleForTesting;
import javax.annotation.concurrent.GuardedBy;

@Deprecated
@KeepForSdk
public final class GoogleServices {
    private static final Object zza = new Object();
    @GuardedBy(value="sLock")
    @Nullable
    private static GoogleServices zzb;
    @Nullable
    private final String zzc;
    private final Status zzd;
    private final boolean zze;
    private final boolean zzf;

    @VisibleForTesting
    @KeepForSdk
    GoogleServices(Context context) {
        Resources resources = context.getResources();
        String string2 = resources.getResourcePackageName(R.string.common_google_play_services_unknown_issue);
        boolean bl = true;
        int n = resources.getIdentifier("google_app_measurement_enable", "integer", string2);
        if (n != 0) {
            bl = resources.getInteger(n) != 0;
            this.zzf = !bl;
        } else {
            this.zzf = false;
        }
        this.zze = bl;
        String string3 = zzt.zza(context);
        if (string3 == null) {
            string3 = new StringResourceValueReader(context).getString("google_app_id");
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.zzd = new Status(10, "Missing google app id value from from string resources with name google_app_id.");
            this.zzc = null;
            return;
        }
        this.zzc = string3;
        this.zzd = Status.RESULT_SUCCESS;
    }

    @VisibleForTesting
    @KeepForSdk
    GoogleServices(String string2, boolean bl) {
        this.zzc = string2;
        this.zzd = Status.RESULT_SUCCESS;
        this.zze = bl;
        this.zzf = !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public static Status initialize(@RecentlyNonNull Context context, @RecentlyNonNull String string2, boolean bl) {
        Preconditions.checkNotNull(context, "Context must not be null.");
        Preconditions.checkNotEmpty(string2, "App ID must be nonempty.");
        Object object = zza;
        synchronized (object) {
            if (zzb != null) {
                return zzb.checkGoogleAppId(string2);
            }
            zzb = new GoogleServices(string2, bl);
            return GoogleServices.zzb.zzd;
        }
    }

    @VisibleForTesting
    @KeepForSdk
    final Status checkGoogleAppId(String string2) {
        if (this.zzc != null && !this.zzc.equals(string2)) {
            String string3 = this.zzc;
            return new Status(10, new StringBuilder(97 + String.valueOf(string3).length()).append("Initialize was called with two different Google App IDs.  Only the first app ID will be used: '").append(string3).append("'.").toString());
        }
        return Status.RESULT_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public static Status initialize(@RecentlyNonNull Context context) {
        Preconditions.checkNotNull(context, "Context must not be null.");
        Object object = zza;
        synchronized (object) {
            if (zzb == null) {
                zzb = new GoogleServices(context);
            }
            return GoogleServices.zzb.zzd;
        }
    }

    @KeepForSdk
    @RecentlyNullable
    public static String getGoogleAppId() {
        return GoogleServices.checkInitialized((String)"getGoogleAppId").zzc;
    }

    @KeepForSdk
    public static boolean isMeasurementEnabled() {
        GoogleServices googleServices = GoogleServices.checkInitialized("isMeasurementEnabled");
        return googleServices.zzd.isSuccess() && googleServices.zze;
    }

    @KeepForSdk
    public static boolean isMeasurementExplicitlyDisabled() {
        return GoogleServices.checkInitialized((String)"isMeasurementExplicitlyDisabled").zzf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @KeepForSdk
    static void clearInstanceForTest() {
        Object object = zza;
        synchronized (object) {
            zzb = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    private static GoogleServices checkInitialized(String string2) {
        Object object = zza;
        synchronized (object) {
            if (zzb == null) {
                throw new IllegalStateException(new StringBuilder(34 + String.valueOf(string2).length()).append("Initialize must be called before ").append(string2).append(".").toString());
            }
            return zzb;
        }
    }
}

