/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.os.IBinder;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.RetainForClient;
import com.google.android.gms.dynamic.IObjectWrapper;
import java.lang.reflect.Field;

@KeepForSdk
@RetainForClient
public final class ObjectWrapper<T>
extends IObjectWrapper.Stub {
    private final T zza;

    private ObjectWrapper(T t) {
        this.zza = t;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> IObjectWrapper wrap(@RecentlyNonNull T t) {
        return new ObjectWrapper<T>(t);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> T unwrap(@RecentlyNonNull IObjectWrapper iObjectWrapper) {
        if (iObjectWrapper instanceof ObjectWrapper) {
            return ((ObjectWrapper)iObjectWrapper).zza;
        }
        IBinder iBinder = iObjectWrapper.asBinder();
        Field[] fieldArray = iBinder.getClass().getDeclaredFields();
        Field field = null;
        int n = 0;
        Field[] fieldArray2 = fieldArray;
        int n2 = fieldArray.length;
        for (int i = 0; i < n2; ++i) {
            Field field2 = fieldArray2[i];
            if (field2.isSynthetic()) continue;
            field = field2;
            ++n;
        }
        if (n == 1) {
            if (!((Field)Preconditions.checkNotNull(field)).isAccessible()) {
                field.setAccessible(true);
                try {
                    return (T)field.get(iBinder);
                }
                catch (NullPointerException nullPointerException) {
                    throw new IllegalArgumentException("Binder object is null.", nullPointerException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Could not access the field in remoteBinder.", illegalAccessException);
                }
            }
            throw new IllegalArgumentException("IObjectWrapper declared field not private!");
        }
        int n3 = fieldArray.length;
        throw new IllegalArgumentException(new StringBuilder(64).append("Unexpected number of IObjectWrapper declared fields: ").append(n3).toString());
    }
}

