/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;

@KeepForSdk
public final class DeviceProperties {
    @Nullable
    private static Boolean zza;
    @Nullable
    private static Boolean zzb;
    @Nullable
    private static Boolean zzc;
    @Nullable
    private static Boolean zzd;
    @Nullable
    private static Boolean zze;
    @Nullable
    private static Boolean zzf;
    @Nullable
    private static Boolean zzg;
    @Nullable
    private static Boolean zzh;

    private DeviceProperties() {
    }

    /*
     * Unable to fully structure code
     */
    @KeepForSdk
    @RecentlyNonNull
    public static boolean isTablet(@RecentlyNonNull Resources var0) {
        block4: {
            if (var0 == null) {
                return false;
            }
            if (DeviceProperties.zza != null) break block4;
            if ((var0.getConfiguration().screenLayout & 15) > 3) ** GOTO lbl-1000
            var1_1 = var0;
            if (DeviceProperties.zzb == null) {
                var2_2 = var1_1.getConfiguration();
                DeviceProperties.zzb = (var2_2.screenLayout & 15) <= 3 && var2_2.smallestScreenWidthDp >= 600;
            }
            if (DeviceProperties.zzb.booleanValue()) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            DeviceProperties.zza = v0;
        }
        return DeviceProperties.zza;
    }

    @TargetApi(value=20)
    @KeepForSdk
    @RecentlyNonNull
    public static boolean isWearable(@RecentlyNonNull Context context) {
        return DeviceProperties.isWearable(context.getPackageManager());
    }

    @TargetApi(value=20)
    @KeepForSdk
    @RecentlyNonNull
    public static boolean isWearable(@RecentlyNonNull PackageManager packageManager) {
        if (zzc == null) {
            zzc = PlatformVersion.isAtLeastKitKatWatch() && packageManager.hasSystemFeature("android.hardware.type.watch");
        }
        return zzc;
    }

    @TargetApi(value=26)
    @KeepForSdk
    @RecentlyNonNull
    public static boolean isWearableWithoutPlayStore(@RecentlyNonNull Context context) {
        return DeviceProperties.isWearable(context) && (!PlatformVersion.isAtLeastN() || DeviceProperties.zzb(context) && !PlatformVersion.isAtLeastO());
    }

    @TargetApi(value=21)
    @KeepForSdk
    @RecentlyNonNull
    public static boolean isSidewinder(@RecentlyNonNull Context context) {
        return DeviceProperties.zzb(context);
    }

    @TargetApi(value=21)
    private static boolean zzb(Context context) {
        if (zzd == null) {
            zzd = PlatformVersion.isAtLeastLollipop() && context.getPackageManager().hasSystemFeature("cn.google");
        }
        return zzd;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isLatchsky(@RecentlyNonNull Context context) {
        if (zze == null) {
            PackageManager packageManager = context.getPackageManager();
            zze = packageManager.hasSystemFeature("com.google.android.feature.services_updater") && packageManager.hasSystemFeature("cn.google.services");
        }
        return zze;
    }

    @RecentlyNonNull
    public static boolean zza(@RecentlyNonNull Context context) {
        if (zzf == null) {
            zzf = context.getPackageManager().hasSystemFeature("android.hardware.type.iot") || context.getPackageManager().hasSystemFeature("android.hardware.type.embedded");
        }
        return zzf;
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static boolean isFeaturePhone(@RecentlyNonNull Context context) {
        return false;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAuto(@RecentlyNonNull Context context) {
        return DeviceProperties.isAuto(context.getPackageManager());
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isAuto(@RecentlyNonNull PackageManager packageManager) {
        if (zzg == null) {
            zzg = PlatformVersion.isAtLeastO() && packageManager.hasSystemFeature("android.hardware.type.automotive");
        }
        return zzg;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isTv(@RecentlyNonNull Context context) {
        return DeviceProperties.isTv(context.getPackageManager());
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isTv(@RecentlyNonNull PackageManager packageManager) {
        if (zzh == null) {
            zzh = packageManager.hasSystemFeature("com.google.android.tv") || packageManager.hasSystemFeature("android.hardware.type.television") || packageManager.hasSystemFeature("android.software.leanback");
        }
        return zzh;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isUserBuild() {
        return "user".equals(Build.TYPE);
    }
}

