/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.util.VisibleForTesting;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

@VisibleForTesting
@KeepForSdk
public final class ArrayUtils {
    @KeepForSdk
    @RecentlyNonNull
    public static <T> boolean contains(@RecentlyNonNull T[] TArray, @RecentlyNonNull T t) {
        int n;
        block1: {
            T t2 = t;
            T[] TArray2 = TArray;
            int n2 = TArray != null ? TArray2.length : 0;
            for (int i = 0; i < n2; ++i) {
                if (!Objects.equal(TArray2[i], t2)) continue;
                n = i;
                break block1;
            }
            n = -1;
        }
        return n >= 0;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean contains(@RecentlyNonNull int[] nArray, @RecentlyNonNull int n) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray2[i] != n) continue;
            return true;
        }
        return false;
    }

    @KeepForSdk
    @RecentlyNullable
    public static Integer[] toWrapperArray(@RecentlyNonNull int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    private ArrayUtils() {
    }

    @KeepForSdk
    public static <T> void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull T[] TArray) {
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(TArray[i]);
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString(nArray[i]));
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull long[] lArray) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Long.toString(lArray[i]));
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull float[] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Float.toString(fArray[i]));
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Double.toString(dArray[i]));
        }
    }

    @KeepForSdk
    public static void writeArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull boolean[] blArray) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Boolean.toString(blArray[i]));
        }
    }

    @KeepForSdk
    public static void writeStringArray(@RecentlyNonNull StringBuilder stringBuilder, @RecentlyNonNull String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(stringArray[i]).append("\"");
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> T[] concat(T[] ... TArray) {
        if (TArray.length == 0) {
            return (Object[])Array.newInstance(TArray.getClass(), 0);
        }
        int n = 0;
        for (int i = 0; i < TArray.length; ++i) {
            n += TArray[i].length;
        }
        T[] TArray2 = Arrays.copyOf(TArray[0], n);
        int n2 = TArray[0].length;
        for (int i = 1; i < TArray.length; ++i) {
            T[] TArray3 = TArray[i];
            System.arraycopy(TArray3, 0, TArray2, n2, TArray3.length);
            n2 += TArray3.length;
        }
        return TArray2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static byte[] concatByteArrays(byte[] ... byArray) {
        if (byArray.length == 0) {
            return new byte[0];
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i].length;
        }
        byte[] byArray2 = Arrays.copyOf(byArray[0], n);
        int n2 = byArray[0].length;
        for (int i = 1; i < byArray.length; ++i) {
            byte[] byArray3 = byArray[i];
            System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
            n2 += byArray3.length;
        }
        return byArray2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> T[] appendToArray(@RecentlyNonNull T[] TArray, @RecentlyNonNull T t) {
        if (TArray == null && t == null) {
            throw new IllegalArgumentException("Cannot generate array of generic type w/o class info");
        }
        Object[] objectArray = TArray == null ? (Object[])Array.newInstance(t.getClass(), 1) : Arrays.copyOf(TArray, TArray.length + 1);
        objectArray[objectArray.length - 1] = t;
        return objectArray;
    }

    @KeepForSdk
    @RecentlyNullable
    public static <T> T[] removeAll(@RecentlyNonNull T[] TArray, T ... TArray2) {
        if (TArray == null) {
            return null;
        }
        if (TArray2 == null || TArray2.length == 0) {
            return Arrays.copyOf(TArray, TArray.length);
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray2.getClass().getComponentType(), TArray.length);
        int n = 0;
        if (TArray2.length == 1) {
            T[] TArray3 = TArray;
            int n2 = TArray.length;
            for (int i = 0; i < n2; ++i) {
                T t = TArray3[i];
                if (Objects.equal(TArray2[0], t)) continue;
                objectArray[n++] = t;
            }
        } else {
            T[] TArray4 = TArray;
            int n3 = TArray.length;
            for (int i = 0; i < n3; ++i) {
                T t = TArray4[i];
                if (ArrayUtils.contains(TArray2, t)) continue;
                objectArray[n++] = t;
            }
        }
        int n4 = n;
        Object[] objectArray2 = objectArray;
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray3 = objectArray2;
        if (n4 != objectArray2.length) {
            objectArray3 = Arrays.copyOf(objectArray2, n4);
        }
        return objectArray3;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> ArrayList<T> toArrayList(@RecentlyNonNull T[] TArray) {
        int n = TArray.length;
        ArrayList<T> arrayList = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(TArray[i]);
        }
        return arrayList;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static int[] toPrimitiveArray(@RecentlyNonNull Collection<Integer> collection) {
        if (collection == null || collection.size() == 0) {
            return new int[0];
        }
        int n = 0;
        int[] nArray = new int[collection.size()];
        for (Integer n2 : collection) {
            nArray[n++] = n2;
        }
        return nArray;
    }
}

