/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public final class BackgroundDetector
implements Application.ActivityLifecycleCallbacks,
ComponentCallbacks2 {
    private static final BackgroundDetector zza = new BackgroundDetector();
    private final AtomicBoolean zzb = new AtomicBoolean();
    private final AtomicBoolean zzc = new AtomicBoolean();
    @GuardedBy(value="sInstance")
    private final ArrayList<BackgroundStateChangeListener> zzd = new ArrayList();
    @GuardedBy(value="sInstance")
    private boolean zze = false;

    @KeepForSdk
    private BackgroundDetector() {
    }

    @KeepForSdk
    @RecentlyNonNull
    public static BackgroundDetector getInstance() {
        return zza;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void initialize(@RecentlyNonNull Application application) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            if (!BackgroundDetector.zza.zze) {
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zza);
                application.registerComponentCallbacks((ComponentCallbacks)zza);
                BackgroundDetector.zza.zze = true;
            }
            return;
        }
    }

    @TargetApi(value=16)
    @KeepForSdk
    @RecentlyNonNull
    public final boolean readCurrentStateIfPossible(@RecentlyNonNull boolean bl) {
        if (!this.zzc.get()) {
            if (PlatformVersion.isAtLeastJellyBean()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
                ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)runningAppProcessInfo);
                if (!this.zzc.getAndSet(true) && runningAppProcessInfo.importance > 100) {
                    this.zzb.set(true);
                }
            } else {
                return bl;
            }
        }
        return this.isInBackground();
    }

    @KeepForSdk
    @RecentlyNonNull
    public final boolean isInBackground() {
        return this.zzb.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final void addListener(@RecentlyNonNull BackgroundStateChangeListener backgroundStateChangeListener) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            this.zzd.add(backgroundStateChangeListener);
            return;
        }
    }

    public final void onActivityCreated(@RecentlyNonNull Activity activity, @Nullable Bundle bundle) {
        boolean bl = this.zzb.compareAndSet(true, false);
        this.zzc.set(true);
        if (bl) {
            this.zza(false);
        }
    }

    public final void onActivityResumed(@RecentlyNonNull Activity activity) {
        boolean bl = this.zzb.compareAndSet(true, false);
        this.zzc.set(true);
        if (bl) {
            this.zza(false);
        }
    }

    public final void onTrimMemory(@RecentlyNonNull int n) {
        if (n == 20 && this.zzb.compareAndSet(false, true)) {
            this.zzc.set(true);
            this.zza(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(boolean bl) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            ArrayList<BackgroundStateChangeListener> arrayList = this.zzd;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                BackgroundStateChangeListener backgroundStateChangeListener = arrayList.get(i);
                backgroundStateChangeListener.onBackgroundStateChanged(bl);
            }
            return;
        }
    }

    public final void onActivityStarted(@RecentlyNonNull Activity activity) {
    }

    public final void onActivityPaused(@RecentlyNonNull Activity activity) {
    }

    public final void onActivityStopped(@RecentlyNonNull Activity activity) {
    }

    public final void onActivitySaveInstanceState(@RecentlyNonNull Activity activity, @RecentlyNonNull Bundle bundle) {
    }

    public final void onActivityDestroyed(@RecentlyNonNull Activity activity) {
    }

    public final void onConfigurationChanged(@RecentlyNonNull Configuration configuration) {
    }

    public final void onLowMemory() {
    }

    @KeepForSdk
    public static interface BackgroundStateChangeListener {
        @KeepForSdk
        public void onBackgroundStateChanged(@RecentlyNonNull boolean var1);
    }
}

