/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;

@ShowFirstParty
@KeepForSdk
public class GoogleApiAvailabilityLight {
    @KeepForSdk
    @RecentlyNonNull
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = GooglePlayServicesUtilLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @KeepForSdk
    @RecentlyNonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @KeepForSdk
    @RecentlyNonNull
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @KeepForSdk
    static final String TRACKING_SOURCE_DIALOG = "d";
    @KeepForSdk
    static final String TRACKING_SOURCE_NOTIFICATION = "n";
    private static final GoogleApiAvailabilityLight zza = new GoogleApiAvailabilityLight();

    @KeepForSdk
    @RecentlyNonNull
    public static GoogleApiAvailabilityLight getInstance() {
        return zza;
    }

    @KeepForSdk
    GoogleApiAvailabilityLight() {
    }

    @HideFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public int isGooglePlayServicesAvailable(@RecentlyNonNull Context context) {
        return this.isGooglePlayServicesAvailable(context, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    @KeepForSdk
    @RecentlyNonNull
    public int isGooglePlayServicesAvailable(@RecentlyNonNull Context context, @RecentlyNonNull int n) {
        int n2 = GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, n);
        if (GooglePlayServicesUtilLight.isPlayServicesPossiblyUpdating(context, n2)) {
            n2 = 18;
        }
        return n2;
    }

    @KeepForSdk
    public void verifyGooglePlayServicesIsAvailable(@RecentlyNonNull Context context, @RecentlyNonNull int n) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        GooglePlayServicesUtilLight.ensurePlayServicesAvailable(context, n);
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean isUserResolvableError(@RecentlyNonNull int n) {
        return GooglePlayServicesUtilLight.isUserRecoverableError(n);
    }

    @Deprecated
    @RecentlyNullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@RecentlyNonNull int n) {
        return this.getErrorResolutionIntent(null, n, null);
    }

    @RecentlyNullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@Nullable Context context, @RecentlyNonNull int n, @Nullable String string2) {
        switch (n) {
            case 1: 
            case 2: {
                if (context != null && DeviceProperties.isWearableWithoutPlayStore(context)) {
                    return zzj.zza();
                }
                return zzj.zza(GOOGLE_PLAY_SERVICES_PACKAGE, GoogleApiAvailabilityLight.zza(context, string2));
            }
            case 3: {
                return zzj.zza(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
        }
        return null;
    }

    @RecentlyNullable
    @KeepForSdk
    public PendingIntent getErrorResolutionPendingIntent(@RecentlyNonNull Context context, @RecentlyNonNull int n, @RecentlyNonNull int n2) {
        return this.getErrorResolutionPendingIntent(context, n, n2, null);
    }

    @RecentlyNullable
    @ShowFirstParty
    @KeepForSdk
    public PendingIntent getErrorResolutionPendingIntent(@RecentlyNonNull Context context, @RecentlyNonNull int n, @RecentlyNonNull int n2, @Nullable String string2) {
        Intent intent = this.getErrorResolutionIntent(context, n, string2);
        if (intent == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)context, (int)n2, (Intent)intent, (int)0x8000000);
    }

    @KeepForSdk
    public void cancelAvailabilityErrorNotifications(@RecentlyNonNull Context context) {
        GooglePlayServicesUtilLight.cancelAvailabilityErrorNotifications(context);
    }

    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public int getClientVersion(@RecentlyNonNull Context context) {
        return GooglePlayServicesUtilLight.getClientVersion(context);
    }

    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public int getApkVersion(@RecentlyNonNull Context context) {
        return GooglePlayServicesUtilLight.getApkVersion(context);
    }

    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public boolean isPlayServicesPossiblyUpdating(@RecentlyNonNull Context context, @RecentlyNonNull int n) {
        return GooglePlayServicesUtilLight.isPlayServicesPossiblyUpdating(context, n);
    }

    @ShowFirstParty
    @KeepForSdk
    @RecentlyNonNull
    public boolean isPlayStorePossiblyUpdating(@RecentlyNonNull Context context, @RecentlyNonNull int n) {
        return GooglePlayServicesUtilLight.isPlayStorePossiblyUpdating(context, n);
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean isUninstalledAppPossiblyUpdating(@RecentlyNonNull Context context, @RecentlyNonNull String string2) {
        return GooglePlayServicesUtilLight.zza(context, string2);
    }

    @KeepForSdk
    @NonNull
    public String getErrorString(@RecentlyNonNull int n) {
        return GooglePlayServicesUtilLight.getErrorString(n);
    }

    @VisibleForTesting
    private static String zza(@Nullable Context context, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("gcore_");
        stringBuilder.append(GOOGLE_PLAY_SERVICES_VERSION_CODE);
        stringBuilder.append("-");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string2);
        }
        stringBuilder.append("-");
        if (context != null) {
            stringBuilder.append(context.getPackageName());
        }
        stringBuilder.append("-");
        if (context != null) {
            try {
                PackageInfo packageInfo = Wrappers.packageManager(context).getPackageInfo(context.getPackageName(), 0);
                stringBuilder.append(packageInfo.versionCode);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return stringBuilder.toString();
    }
}

