/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamite;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.zzc;
import com.google.android.gms.dynamite.zzd;
import com.google.android.gms.dynamite.zze;
import com.google.android.gms.dynamite.zzf;
import com.google.android.gms.dynamite.zzg;
import com.google.android.gms.dynamite.zzh;
import com.google.android.gms.dynamite.zzi;
import com.google.android.gms.dynamite.zzj;
import com.google.android.gms.dynamite.zzk;
import com.google.android.gms.dynamite.zzl;
import com.google.android.gms.dynamite.zzm;
import dalvik.system.DelegateLastClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public final class DynamiteModule {
    @GuardedBy(value="DynamiteModule.class")
    private static Boolean zza;
    @GuardedBy(value="DynamiteModule.class")
    private static zzk zzb;
    @GuardedBy(value="DynamiteModule.class")
    private static zzm zzc;
    @GuardedBy(value="DynamiteModule.class")
    private static String zzd;
    @GuardedBy(value="DynamiteModule.class")
    private static int zze;
    private static final ThreadLocal<zza> zzf;
    private static final VersionPolicy.zzb zzg;
    @KeepForSdk
    public static final VersionPolicy PREFER_REMOTE;
    @KeepForSdk
    public static final VersionPolicy PREFER_LOCAL;
    @KeepForSdk
    public static final VersionPolicy PREFER_REMOTE_VERSION_NO_FORCE_STAGING;
    @KeepForSdk
    public static final VersionPolicy PREFER_HIGHEST_OR_LOCAL_VERSION;
    @KeepForSdk
    public static final VersionPolicy PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING;
    @KeepForSdk
    public static final VersionPolicy PREFER_HIGHEST_OR_REMOTE_VERSION;
    private static final VersionPolicy zzh;
    private final Context zzi;

    /*
     * Loose catch block
     */
    @KeepForSdk
    public static DynamiteModule load(Context context, VersionPolicy versionPolicy, String string2) throws LoadingException {
        zza zza2 = zzf.get();
        zza zza3 = new zza(null);
        zzf.set(zza3);
        try {
            VersionPolicy.zza zza4 = versionPolicy.zza(context, string2, zzg);
            int n = zza4.zza;
            int n2 = zza4.zzb;
            Log.i((String)"DynamiteModule", (String)new StringBuilder(68 + String.valueOf(string2).length() + String.valueOf(string2).length()).append("Considering local module ").append(string2).append(":").append(n).append(" and remote module ").append(string2).append(":").append(n2).toString());
            if (zza4.zzc == 0 || zza4.zzc == -1 && zza4.zza == 0 || zza4.zzc == 1 && zza4.zzb == 0) {
                n = zza4.zza;
                n2 = zza4.zzb;
                throw new LoadingException(new StringBuilder(91).append("No acceptable module found. Local version is ").append(n).append(" and remote version is ").append(n2).append(".").toString(), null);
            }
            if (zza4.zzc == -1) {
                DynamiteModule dynamiteModule = DynamiteModule.zza(context, string2);
                return dynamiteModule;
            }
            if (zza4.zzc == 1) {
                try {
                    DynamiteModule dynamiteModule = DynamiteModule.zza(context, string2, zza4.zzb);
                    return dynamiteModule;
                }
                catch (LoadingException loadingException) {
                    block12: {
                        DynamiteModule dynamiteModule;
                        block13: {
                            String string3 = String.valueOf(loadingException.getMessage());
                            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load remote module: ".concat(string3) : new String("Failed to load remote module: ")));
                            if (zza4.zza == 0 || versionPolicy.zza((Context)context, (String)string2, (VersionPolicy.zzb)new zzb((int)zza4.zza, (int)0)).zzc != -1) break block12;
                            dynamiteModule = DynamiteModule.zza(context, string2);
                            if (zza3.zza == null) break block13;
                            zza3.zza.close();
                        }
                        zzf.set(zza2);
                        return dynamiteModule;
                    }
                    throw new LoadingException("Remote load failed. No local fallback found.", loadingException, null);
                }
            }
            n = zza4.zzc;
            throw new LoadingException(new StringBuilder(47).append("VersionPolicy returned invalid code:").append(n).toString(), null);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (zza3.zza != null) {
                zza3.zza.close();
            }
            zzf.set(zza2);
        }
    }

    @KeepForSdk
    public static int getLocalVersion(Context context, String string2) {
        try {
            Class<?> clazz = context.getApplicationContext().getClassLoader().loadClass(new StringBuilder(61 + String.valueOf(string2).length()).append("com.google.android.gms.dynamite.descriptors.").append(string2).append(".ModuleDescriptor").toString());
            Field field = clazz.getDeclaredField("MODULE_ID");
            Field field2 = clazz.getDeclaredField("MODULE_VERSION");
            if (!field.get(null).equals(string2)) {
                String string3 = String.valueOf(field.get(null));
                Log.e((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Module descriptor id '").append(string3).append("' didn't match expected id '").append(string2).append("'").toString());
                return 0;
            }
            return field2.getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"DynamiteModule", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Local module descriptor class for ").append(string2).append(" not found.").toString());
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.getMessage());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load module descriptor class: ".concat(string4) : new String("Failed to load module descriptor class: ")));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int zza(Context context, String string2, boolean bl) {
        try {
            Class<DynamiteModule> clazz = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                Boolean bl2 = zza;
                if (bl2 == null) {
                    try {
                        Field field = context.getApplicationContext().getClassLoader().loadClass(DynamiteLoaderClassLoader.class.getName()).getDeclaredField("sClassLoader");
                        Class<?> clazz2 = field.getDeclaringClass();
                        synchronized (clazz2) {
                            ClassLoader classLoader = (ClassLoader)field.get(null);
                            if (classLoader != null) {
                                if (classLoader == ClassLoader.getSystemClassLoader()) {
                                    bl2 = Boolean.FALSE;
                                } else {
                                    try {
                                        DynamiteModule.zza(classLoader);
                                    }
                                    catch (LoadingException loadingException) {}
                                    bl2 = Boolean.TRUE;
                                }
                            } else if ("com.google.android.gms".equals(context.getApplicationContext().getPackageName())) {
                                field.set(null, ClassLoader.getSystemClassLoader());
                                bl2 = Boolean.FALSE;
                            } else {
                                try {
                                    int n = DynamiteModule.zzc(context, string2, bl);
                                    if (zzd == null || zzd.isEmpty()) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 2, 18, 3, 5, 22, 7, 8, 24] lbl30 : MonitorExitStatement: MONITOREXIT : var6_9
                                        // ** MonitorExit[var4_3] (shouldn't be in output)
                                        return n;
                                    }
                                    classLoader = Build.VERSION.SDK_INT >= 29 ? new DelegateLastClassLoader(zzd, ClassLoader.getSystemClassLoader()) : new zzi(zzd, ClassLoader.getSystemClassLoader());
                                    DynamiteModule.zza(classLoader);
                                    field.set(null, classLoader);
                                    zza = Boolean.TRUE;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 18, 3, 5, 22, 7, 8, 24] lbl37 : MonitorExitStatement: MONITOREXIT : var6_9
                                    // ** MonitorExit[var4_3] (shouldn't be in output)
                                    return n;
                                }
                                catch (LoadingException loadingException) {
                                    field.set(null, ClassLoader.getSystemClassLoader());
                                    bl2 = Boolean.FALSE;
                                }
                            }
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                        String string3 = String.valueOf(reflectiveOperationException);
                        Log.w((String)"DynamiteModule", (String)new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to load module via V2: ").append(string3).toString());
                        bl2 = Boolean.FALSE;
                    }
                    zza = bl2;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (bl2.booleanValue()) {
                    try {
                        return DynamiteModule.zzc(context, string2, bl);
                    }
                    catch (LoadingException loadingException) {
                        String string4 = String.valueOf(loadingException.getMessage());
                        Log.w((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to retrieve remote module version: ".concat(string4) : new String("Failed to retrieve remote module version: ")));
                        return 0;
                    }
                }
                return DynamiteModule.zzb(context, string2, bl);
            }
        }
        catch (Throwable throwable) {
            CrashUtils.addDynamiteErrorToDropBox(context, throwable);
            throw throwable;
        }
    }

    private static int zzb(Context context, String string2, boolean bl) {
        zzk zzk2 = DynamiteModule.zza(context);
        if (zzk2 == null) {
            return 0;
        }
        try {
            if (zzk2.zzb() >= 2) {
                return zzk2.zzb(ObjectWrapper.wrap(context), string2, bl);
            }
            Log.w((String)"DynamiteModule", (String)"IDynamite loader version < 2, falling back to getModuleVersion2");
            return zzk2.zza(ObjectWrapper.wrap(context), string2, bl);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to retrieve remote module version: ".concat(string3) : new String("Failed to retrieve remote module version: ")));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int zzc(Context context, String string2, boolean bl) throws LoadingException {
        try (Cursor cursor = null;){
            boolean bl2 = bl;
            String string3 = string2;
            boolean bl3 = bl2;
            String string4 = string3;
            String string5 = bl3 ? "api_force_staging" : "api";
            cursor = context.getContentResolver().query(Uri.parse((String)new StringBuilder(42 + String.valueOf(string5).length() + String.valueOf(string4).length()).append("content://com.google.android.gms.chimera/").append(string5).append("/").append(string4).toString()), null, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                Log.w((String)"DynamiteModule", (String)"Failed to retrieve remote module version.");
                throw new LoadingException("Failed to connect to dynamite module ContentResolver.", null);
            }
            int n = cursor.getInt(0);
            if (n <= 0) return n;
            Object object = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                zzd = cursor.getString(2);
                int n2 = cursor.getColumnIndex("loaderVersion");
                if (n2 >= 0) {
                    zze = cursor.getInt(n2);
                }
                // ** MonitorExit[var5_11] (shouldn't be in output)
                object = zzf.get();
                if (object == null || ((zza)object).zza != null) return n;
                ((zza)object).zza = cursor;
                cursor = null;
                return n;
            }
        }
    }

    @KeepForSdk
    public static int getRemoteVersion(Context context, String string2) {
        return DynamiteModule.zza(context, string2, false);
    }

    private static DynamiteModule zza(Context context, String string2) {
        String string3 = String.valueOf(string2);
        Log.i((String)"DynamiteModule", (String)(string3.length() != 0 ? "Selected local version of ".concat(string3) : new String("Selected local version of ")));
        return new DynamiteModule(context.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zza(Context context, String string2, int n) throws LoadingException {
        try {
            Class<DynamiteModule> clazz = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                IObjectWrapper iObjectWrapper;
                Boolean bl = zza;
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (bl == null) {
                    throw new LoadingException("Failed to determine which loading route to use.", null);
                }
                if (bl.booleanValue()) {
                    return DynamiteModule.zzb(context, string2, n);
                }
                int n2 = n;
                String string3 = string2;
                Context context2 = context;
                Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length()).append("Selected remote version of ").append(string3).append(", version >= ").append(n2).toString());
                zzk zzk2 = DynamiteModule.zza(context2);
                if (zzk2 == null) {
                    throw new LoadingException("Failed to create IDynamiteLoader.", null);
                }
                if (zzk2.zzb() >= 2) {
                    iObjectWrapper = zzk2.zzb(ObjectWrapper.wrap(context2), string3, n2);
                } else {
                    Log.w((String)"DynamiteModule", (String)"Dynamite loader version < 2, falling back to createModuleContext");
                    iObjectWrapper = zzk2.zza(ObjectWrapper.wrap(context2), string3, n2);
                }
                if (ObjectWrapper.unwrap(iObjectWrapper) == null) {
                    throw new LoadingException("Failed to load remote module.", null);
                }
                return new DynamiteModule((Context)ObjectWrapper.unwrap(iObjectWrapper));
            }
        }
        catch (RemoteException remoteException) {
            throw new LoadingException("Failed to load remote module.", remoteException, null);
        }
        catch (LoadingException loadingException) {
            throw loadingException;
        }
        catch (Throwable throwable) {
            CrashUtils.addDynamiteErrorToDropBox(context, throwable);
            throw new LoadingException("Failed to load remote module.", throwable, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzk zza(Context context) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            if (zzb != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return zzb;
            }
            try {
                IInterface iInterface;
                zzk zzk2;
                IBinder iBinder = (IBinder)context.createPackageContext("com.google.android.gms", 3).getClassLoader().loadClass("com.google.android.gms.chimera.container.DynamiteLoaderImpl").newInstance();
                if ((iBinder == null ? null : (zzk2 = (iInterface = iBinder.queryLocalInterface("com.google.android.gms.dynamite.IDynamiteLoader")) instanceof zzk ? (zzk)iInterface : new zzj(iBinder))) != null) {
                    zzb = zzk2;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return zzk2;
                }
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"DynamiteModule", (String)(string2.length() != 0 ? "Failed to load IDynamiteLoader from GmsCore: ".concat(string2) : new String("Failed to load IDynamiteLoader from GmsCore: ")));
            }
            return null;
        }
    }

    @KeepForSdk
    public final Context getModuleContext() {
        return this.zzi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zzb(Context context, String string2, int n) throws LoadingException, RemoteException {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        Object object = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            IObjectWrapper iObjectWrapper;
            zzm zzm2 = zzc;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (zzm2 == null) {
                throw new LoadingException("DynamiteLoaderV2 was not cached.", null);
            }
            object = zzf.get();
            if (object == null || ((zza)object).zza == null) {
                throw new LoadingException("No result cursor", null);
            }
            zzm zzm3 = zzm2;
            Cursor cursor = ((zza)object).zza;
            int n2 = n;
            String string3 = string2;
            Context context2 = context.getApplicationContext();
            ObjectWrapper.wrap(null);
            if (DynamiteModule.zza().booleanValue()) {
                Log.v((String)"DynamiteModule", (String)"Dynamite loader version >= 2, using loadModule2NoCrashUtils");
                iObjectWrapper = zzm3.zzb(ObjectWrapper.wrap(context2), string3, n2, ObjectWrapper.wrap(cursor));
            } else {
                Log.w((String)"DynamiteModule", (String)"Dynamite loader version < 2, falling back to loadModule2");
                iObjectWrapper = zzm3.zza(ObjectWrapper.wrap(context2), string3, n2, ObjectWrapper.wrap(cursor));
            }
            Context context3 = (Context)ObjectWrapper.unwrap(iObjectWrapper);
            if (context3 == null) {
                throw new LoadingException("Failed to get module context", null);
            }
            return new DynamiteModule(context3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean zza() {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return zze >= 2;
        }
    }

    @GuardedBy(value="DynamiteModule.class")
    private static void zza(ClassLoader classLoader) throws LoadingException {
        try {
            IInterface iInterface;
            IBinder iBinder = (IBinder)classLoader.loadClass("com.google.android.gms.dynamiteloader.DynamiteLoaderV2").getConstructor(new Class[0]).newInstance(new Object[0]);
            zzc = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.android.gms.dynamite.IDynamiteLoaderV2")) instanceof zzm ? (zzm)iInterface : new zzl(iBinder));
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new LoadingException("Failed to instantiate dynamite loader", reflectiveOperationException, null);
        }
    }

    @KeepForSdk
    public final IBinder instantiate(String string2) throws LoadingException {
        try {
            return (IBinder)this.zzi.getClassLoader().loadClass(string2).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            String string3 = String.valueOf(string2);
            throw new LoadingException(string3.length() != 0 ? "Failed to instantiate module class: ".concat(string3) : new String("Failed to instantiate module class: "), reflectiveOperationException, null);
        }
    }

    private DynamiteModule(Context context) {
        this.zzi = Preconditions.checkNotNull(context);
    }

    static {
        zze = -1;
        zzf = new ThreadLocal();
        zzg = new com.google.android.gms.dynamite.zzb();
        PREFER_REMOTE = new com.google.android.gms.dynamite.zza();
        PREFER_LOCAL = new zzd();
        PREFER_REMOTE_VERSION_NO_FORCE_STAGING = new zzc();
        PREFER_HIGHEST_OR_LOCAL_VERSION = new zzf();
        PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING = new zze();
        PREFER_HIGHEST_OR_REMOTE_VERSION = new zzh();
        zzh = new zzg();
    }

    @DynamiteApi
    public static class DynamiteLoaderClassLoader {
        @GuardedBy(value="DynamiteLoaderClassLoader.class")
        public static ClassLoader sClassLoader;
    }

    private static final class zza {
        public Cursor zza;

        private zza() {
        }

        /* synthetic */ zza(com.google.android.gms.dynamite.zzb zzb2) {
            this();
        }
    }

    @KeepForSdk
    public static class LoadingException
    extends Exception {
        private LoadingException(String string2) {
            super(string2);
        }

        private LoadingException(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        /* synthetic */ LoadingException(String string2, com.google.android.gms.dynamite.zzb zzb2) {
            this(string2);
        }

        /* synthetic */ LoadingException(String string2, Throwable throwable, com.google.android.gms.dynamite.zzb zzb2) {
            this(string2, throwable);
        }
    }

    private static final class zzb
    implements VersionPolicy.zzb {
        private final int zza;
        private final int zzb;

        public zzb(int n, int n2) {
            this.zza = n;
            this.zzb = 0;
        }

        @Override
        public final int zza(Context context, String string2, boolean bl) {
            return 0;
        }

        @Override
        public final int zza(Context context, String string2) {
            return this.zza;
        }
    }

    public static interface VersionPolicy {
        public zza zza(Context var1, String var2, zzb var3) throws LoadingException;

        public static final class zza {
            public int zza = 0;
            public int zzb = 0;
            public int zzc = 0;
        }

        public static interface zzb {
            public int zza(Context var1, String var2, boolean var3) throws LoadingException;

            public int zza(Context var1, String var2);
        }
    }
}

