/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zzd;
import com.google.android.gms.internal.common.zzi;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzc
extends Fragment
implements LifecycleFragment {
    private static WeakHashMap<FragmentActivity, WeakReference<zzc>> zza = new WeakHashMap();
    private Map<String, LifecycleCallback> zzb = Collections.synchronizedMap(new ArrayMap());
    private int zzc = 0;
    private Bundle zzd;

    public static zzc zza(FragmentActivity fragmentActivity) {
        zzc zzc2;
        WeakReference<zzc> weakReference = zza.get(fragmentActivity);
        if (weakReference != null && (zzc2 = (zzc)weakReference.get()) != null) {
            return zzc2;
        }
        try {
            zzc2 = (zzc)fragmentActivity.getSupportFragmentManager().findFragmentByTag("SupportLifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag SupportLifecycleFragmentImpl is not a SupportLifecycleFragmentImpl", classCastException);
        }
        if (zzc2 == null || zzc2.isRemoving()) {
            zzc2 = new zzc();
            fragmentActivity.getSupportFragmentManager().beginTransaction().add((Fragment)zzc2, "SupportLifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zza.put(fragmentActivity, new WeakReference<zzc>(zzc2));
        return zzc2;
    }

    @Override
    public final <T extends LifecycleCallback> T getCallbackOrNull(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzb.get(string2)));
    }

    @Override
    public final void addCallback(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzb.containsKey(string2)) {
            this.zzb.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzc zzc2 = this;
            if (zzc2.zzc > 0) {
                new zzi(Looper.getMainLooper()).post(new zzd(zzc2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    @Override
    public final boolean isCreated() {
        return this.zzc > 0;
    }

    @Override
    public final boolean isStarted() {
        return this.zzc >= 2;
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzc = 1;
        this.zzd = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzb.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzc = 2;
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzc = 3;
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onResume();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzb.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzc = 4;
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzc = 5;
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    public final /* synthetic */ Activity getLifecycleActivity() {
        return this.getActivity();
    }

    static /* synthetic */ int zza(zzc zzc2) {
        return zzc2.zzc;
    }

    static /* synthetic */ Bundle zzb(zzc zzc2) {
        return zzc2.zzd;
    }
}

