/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;

@ShowFirstParty
@KeepForSdk
public class Hex {
    private static final char[] zzhm = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] zzhn = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @KeepForSdk
    public static String bytesToStringUppercase(byte[] byArray) {
        return Hex.bytesToStringUppercase(byArray, false);
    }

    @KeepForSdk
    public static String bytesToStringUppercase(byte[] byArray, boolean bl) {
        int n = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n << 1);
        for (int i = 0; !(i >= n || bl && i == n - 1 && (byArray[i] & 0xFF) == 0); ++i) {
            stringBuilder.append(zzhm[(byArray[i] & 0xF0) >>> 4]);
            stringBuilder.append(zzhm[byArray[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    @KeepForSdk
    public static String bytesToStringLowercase(byte[] byArray) {
        char[] cArray = new char[byArray.length << 1];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[n++] = zzhn[n2 >>> 4];
            cArray[n++] = zzhn[n2 & 0xF];
        }
        return new String(cArray);
    }

    @KeepForSdk
    public static byte[] stringToBytes(String string2) throws IllegalArgumentException {
        int n = string2.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Hex string has odd number of characters");
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)Integer.parseInt(string2.substring(i, i + 2), 16);
        }
        return byArray;
    }
}

